#!/usr/bin/env python
# -*- coding: euc-jp -*-

"""
mixi
utilitiy to get mixi information.
Original Author : OHTANI Hiroki       <hiro@liris.org>
         Edited : SETOGUCHI Mitsuhiro <setomits@matatabi.homeip.net>
"""

import urllib, re, time, warnings
import BeautifulSoup

############################
# Variables
############################
__version__  = '0.1'
LOGIN_SUCCESS_STR = '<html><head><meta http-equiv="refresh" content="0;url=/check.pl?n=home.pl"></head></html>'
WARNING = "Oh, we got mixi access restriction. We defer to access for a while.."
MIXI_BASE_URL = "http://mixi.jp"
CACHE_SEC = 600

############################
# Classes
############################
class LoginFailure(Exception):
    """
    Raised whenever the login process fails--could be wrong username/password,
    or mixi service error, for example.
    """

class MIXI:
    """
    MIXI class to handle mixi(http://mixi.jp).
    """

    ############################
    # Internal Class Methods
    ############################
    def __init__(self, proxy = None, err_retry_interval = 5):
        """
        proxy - proxy url if you are behind proxy. If None, does not use proxy.
        err_retry_itenrval - if we got mixi access restriction if the sever is busy and so on,
                             we delay to access to server. this value is priod to delay(second)
        """
        self.cookie = []
        self.cache = {}
        proxy_dict = None
        if proxy:
            proxy_dict = {"http": proxy}
        self.opener = urllib.FancyURLopener(proxy_dict)
	self.mixiid = None
        self.last_access = 0
        self.err_retry_interval = err_retry_interval

    def _get_soup(self, url, retry_cnt=0):
        now = time.time()
	u = "%s/%s" % (MIXI_BASE_URL, url)
        if self.cache.has_key(u) and self._fresh(cache[u], now):
            return self.cache[u][1]

        if retry_cnt:
            warnings.warn(WARNING)
            time.sleep(self.err_retry_interval)
        self.last_access = now
        try:
            f = self.opener.open(u)
            data = f.read()
	    f.close()
	    soup = BeautifulSoup.BeautifulSoup(data)

	    self._purge_cache(now)
            self.cache[u] = (now, soup)

            return soup
        except:
            if retry_cnt == 0:
                return self._get_soup(url, 1)
            else:
                return None

    def _fresh(self, (accessed, soup), now):
	if now - accessed < CACHE_SEC:
	    return True
	else:
	    return False
    
    def _purge_cache(self, now):
	for u in self.cache.keys():
	    if self._fresh(self.cache[u], now):
		pass
	    else:
		del self.cache[u]

    def _get_binary(self, url):
        f = self.opener.open(url)
        data = f.read()
	f.close()

        return data

    def _get_absurl(self, url):
	try:
	    params = dict([kv.split("=") for kv in url[url.find("?")+1:].split("&")])
	    if params.has_key("url"):
		return urllib.unquote(params["url"])
	    return urllib.unquote("%s/%s" % (MIXI_BASE_URL, url))
	except:
	    return url

    def _mixidatetime2ptime(self, s):
	return time.strptime(s, u"%Yǯ%m%d %H:%M")

    def _mixidate2ptime(self, s):
	s = u"%dǯ%s" % (time.localtime()[0], s)
	return time.strptime(s, u"%Yǯ%m%d  ")

    def _url_to_ids(self, url):
	pat = re.compile(u"id=(\d*)")

	return pat.findall(url)

    def _get_next_link(self, soup):
	ancs = soup.findAll("a")
	for anc in ancs:
	    if anc.string == u"ɽ":
		return anc["href"]
	else:
	    return None

    def _node_to_text(self, node):
	l = []
	for content in node.contents:
	    if type(content) == BeautifulSoup.NavigableString:
		content = content.replace("&nbsp;", "").strip()
		if len(content):
		    l.append(content)
	    else:
		l += self._node_to_text(content)

	return l

    def _get_name_and_num(self, s):
        n = s.rfind("(")
        name = s[:n-2]
        num = int(s[n+1:-1])

        return name, num

    def _get_list_friend(self, u, l = []):
	soup = self._get_soup(u)
	table = soup.find("table", {"border": "0", "cellspacing": "1",
				    "cellpadding": "2", "width": "560"})

	imgtds = table.findAll("td", {"width": "20%", "height": "100"})
	infotds = table.findAll("td", {"valign": "middle"})

	for i in range(len(imgtds)):
	    anc = imgtds[i].find("a")
	    if not anc:
		continue
	    item = {}
	    item["link"] = self._get_absurl(anc["href"])
	    item["id"] = self._url_to_ids(item["link"])[0]
	    item["name"], item["num"] = self._get_name_and_num(infotds[i].contents[0])
	    l.append(item)

	next_link = self._get_next_link(soup)
	if next_link:
	    l = self._get_list_friend(next_link, l)

	return l

    def _get_diary_entry(self, url):
        """
        get the diary entry(content).
        url - url to get.
        """

	if url.startswith(MIXI_BASE_URL):
	    soup = self._get_soup(url[len(MIXI_BASE_URL)+1:])
	    if not soup:
	        return ret[u"error"]

            node = soup.find("td", {"class": "h12"})

	    return self._node_to_text(node)
	else:
	    return []

    ############################
    # Class Methods
    ############################
    def login(self, email, passwd):
        """
        login to mixi server. If failed, LoginFailure exception is raised.
        email - login email address
        password - password to login. 
        """
        params = urllib.urlencode({"email": email, "password":passwd,
                                   "next_url":"home.pl"})
        f = self.opener.open("%s/login.pl" % MIXI_BASE_URL, params)
        s = f.read()
        if not f.headers.status and s.count(LOGIN_SUCCESS_STR):
            self.cookie = f.headers.getheaders("Set-Cookie")
            cl = []
            for c in self.cookie:
                c = c[:c.find(";")]
                if c.find("BF_SESSION=") == 0:
                    l = len("BF_SESSION=")
                    self.mixiid = c[l:c.find("_", l)]
                cl.append(c)
            self.opener.addheader("Cookie", ";".join(cl))
	    f.close()
        else:
            raise LoginFailure

    def new_friend_diary(self, max = 50, with_content = False):
        """
        get the latest mixi friend diary entry.
        if success, return the array of entries.
        Each etnry is dictionary which contaisn date, title, link, creator and content.
        date is the python time object. link is the absolute url to the entry.
        max - max number to get. the maximun value is 50.
        with_content - this method get only entry pointers.
                       If you want to get entry, itself., set this value to True
        """
        u = "new_friend_diary.pl"

        soup = self._get_soup(u)
	table = soup.find("table", {"border": "0", "cellspacing": "1",
				    "cellpadding": "4", "width": "630"})
	l = []
	for tr in table.findAll("tr"):
            item = {}

	    td = tr.find("td", {"width": "180"})
            item["date"] = self._mixidatetime2ptime(td.contents[1])

            td = tr.find("td", {"width": "450"})
	    anc = td.a
            item["title"] = anc.string
            item["link"] = self._get_absurl(anc["href"])
	    item["creator"] = td.contents[1].strip()[1:-1]

	    if with_content:
		item["content"] = self._get_diary_entry(item["link"])

	    l.append(item)

        return l

    def friend_diary(self, mixiid, with_content=False):
        """
        get the latest mixi user diary entry.
        if success, return the array of entries.
        Each etnry is dictionary which contaisn date, title, link, creator and content.
        date is the python time object. link is the absolute url to the entry.
        mixiid - mixi id to get diary
        with_content - this method get only entry pointers.
                       If you want to get entry, itself., set this value to True
        """
	u = "show_friend.pl?id=%s" % (mixiid)
	soup = self._get_soup(u)
	comment = soup.find(text = re.compile("start: diary_new"))
	creator = soup.head.title.string[len("[mixi] "):]

        l = []
        if not comment:
            return l

	td = comment.next.next.findAll("td")[1]
	ancs = td.findAll("a")[:-1]

	for anc in ancs:
	    item = {}
	    item["creator"] = creator
	    item["date"] = self._mixidate2ptime(anc.previous.strip())
	    item["title"] = anc.string
	    item["link"] = self._get_absurl(anc["href"])
	    item["id"] = mixiid

	    if with_content:
		item["content"] = self._get_diary_entry(item["link"])

	    l.append(item)

        return l

    def show_log(self):
        """
        get mixi user list, who visit your mixi site.
        the result value is the array. Each element is the dictionay,
        which contains date, link(to his/her page), name and mixi id.
        """
        u = "show_log.pl"

	soup = self._get_soup(u)
	td = soup.find("td", {"class": "h130"})
	ancs = td.findAll("a")

        l = []
	for anc in ancs:
	    item = {}
	    item["date"] = self._mixidatetime2ptime(anc.previous.strip())
	    item["link"] = self._get_absurl(anc["href"])
	    item["creator"] = anc.string
	    item["id"] = self._url_to_ids(item["link"])[0]
	    l.append(item)

        return l

    def list_friend(self, mixiid = None):
        """
        get the friend list.
        the result value is the array. Each element is the dictionay,
        which contains date, link(to his/her page), name and mixi id.
        
        mixiid - mixi id to get list. if not specified, get your mixi friend list.
        """
        if not mixiid:
            mixiid = self.mixiid
        u = "list_friend.pl?id=%s" % (mixiid)

        return self._get_list_friend(u)

    def get_profile(self, mixiid = None):
        """
        get profield.
        the result value is the dictionary.
        """
        if not mixiid or mixiid == self.mixiid:
            u = "show_profile.pl"
        else:
            u = "show_friend.pl?id=%s" % mixiid

	soup = self._get_soup(u)
	table = soup.find("table", {"border": "0", "cellspacing": "1",
				    "cellpadding": "4", "width": "425"})

	trs = table.findAll("tr")
	item = {}
	for tr in trs:
	    tds = tr.findAll("td")
	    try:
		key_node = tds[0].next
		val_node = tds[1]
		key = "".join(self._node_to_text(key_node))
		val = self._node_to_text(val_node)
		item[key] = val
	    except:
		pass

	return item

    def get_image(self, mixiid, thumnail=False):
        """
        get the image file for user. the result value is file name and image byte array.
        mixiid - mixi id whose image you want.
        thumnail - not implement yet.
        """
        if not mixiid or mixiid == self.mixiid:
            u = "home.pl"
        else:
            u = "show_friend.pl?id=%s" % mixiid
	    
	soup = self._get_soup(u)
	table = soup.find("table", {"border": "0", "cellspacing": "0",
				    "cellpadding": "3", "width": "250",
				    "bgcolor":"#FFFFFF"})
	src = table.next.next.img["src"]

	if src.endswith("no_photo.gif"):
            return None, None
	else:
            if thumnail:
                src = src[:-4] + "s.jpg"

            return src[src.rfind("/")+1:], self._get_binary(src)
