#include "advanced_api.h"


PyObject *
senna_sen_sym_open(PyObject *self, PyObject *args, PyObject *keywds)
{
  sen_sym *sym;
  PyObject *sym_obj;
  char *path = "";
  static char *kwlist[] = {"path", NULL};

  if (!PyArg_ParseTupleAndKeywords(args, keywds, "s", kwlist, &path)) {
    return NULL;
  }
  sym = sen_sym_open(path);
  if (!sym) {
    return Py_BuildValue("");
  }
  sym_obj = PyCObject_FromVoidPtr((void*)sym, NULL);
  return Py_BuildValue("O", sym_obj);
}


PyObject *
senna_sen_sym_info(PyObject *self, PyObject *args, PyObject *keywds)
{
  sen_rc rc;
  sen_sym *sym;
  PyObject *sym_obj;
  int key_size = 0;
  unsigned flags = 0;
  sen_encoding encoding = sen_enc_default;
  unsigned nrecords = 0;
  unsigned file_size = 0;
  static char *kwlist[] = {"sym", NULL};

  if (!PyArg_ParseTupleAndKeywords(args, keywds, "O", kwlist, &sym_obj)) {
    return NULL;
  }
  sym = (sen_sym*)PyCObject_AsVoidPtr(sym_obj);
  rc = sen_sym_info(sym, &key_size, &flags, &encoding, &nrecords, &file_size);
  printf("%d\n", flags);
  if (rc != sen_success) {
    return NULL;
  } else {
    return Py_BuildValue("(iiiii)", key_size, flags, encoding, nrecords, file_size);
  }
}


PyObject *
senna_sen_sym_close(PyObject *self, PyObject *args, PyObject *keywds)
{
  sen_rc rc;
  sen_sym *sym;
  PyObject *sym_obj;
  static char *kwlist[] = {"sym", NULL};

  if (!PyArg_ParseTupleAndKeywords(args, keywds, "O", kwlist, &sym_obj)) {
    return NULL;
  }
  sym = (sen_sym*)PyCObject_AsVoidPtr(sym_obj);
  rc = sen_sym_close(sym);
  return Py_BuildValue("i", rc);
}


PyObject *
senna_sen_sym_size(PyObject *self, PyObject *args, PyObject *keywds)
{
  unsigned int size;
  sen_sym *sym;
  PyObject *sym_obj;
  static char *kwlist[] = {"sym", NULL};

  if (!PyArg_ParseTupleAndKeywords(args, keywds, "O", kwlist, &sym_obj)) {
    return NULL;
  }
  sym = (sen_sym*)PyCObject_AsVoidPtr(sym_obj);
  size = sen_sym_size(sym);
  return Py_BuildValue("i", size);
}

