]#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# This file is part of Pysilhouette.
#
# Copyright (c) 2009 HDE, Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#

"""
@author: Kei Funagayama <kei.funagayama@hde.co.jp>
"""

import sys
import os
import logging

from pysilhouette.prep import getopts, readconf, chkopts
from pysilhouette.db import Database, reload_mappers
from pysilhouette.db.model import JobGroup, Job

NUM = 10

def main():
    (opts, args) = getopts()
    if chkopts(opts) is True:
        return 1
    
    try:
        opts.config = os.path.abspath(opts.config)
    except AttributeError, e:
        print >>sys.stderr, 'No configuration file path.'
        return 1
    
    cf = readconf(opts.config)
    if cf is None:
        print >>sys.stderr, 'Failed to load the config file.'
        return 1
    
    try:
        db = Database(cf['database.url'],
                      encoding="utf-8",
                      convert_unicode=True,
                      assert_unicode=False, # product
                      #assert_unicode='warn', # dev
                      #echo = opts.verbose,
                      #echo_pool = opts.verbose,
                      echo=True,
                      echo_pool=True
                      )
        
        reload_mappers(db.get_metadata())
        session = db.get_session()
        
    except Exception, e:
        print >>sys.stderr, 'Initializing a database error'
        raise
    
    try:
        jgs = []
        for i in range(NUM):
            jg_name = u'JobGroup-%d' % i
            jg_ukey = unicode(cf['env.uniqkey'], "utf-8") 
            j_name = u'Job-%d' % i
            j_order = i
            j_cmd = u'/bin/echo num=%d' % i
            jg = JobGroup(jg_name, jg_ukey)
            jg.jobs.append(
                Job(j_name, j_order, j_cmd))
            jgs.append(jg)
            
        session.add_all(jgs)
        session.commit()
        session.close()
        print >>sys.stdout, 'Insert JobGroup and Job. num=%d [OK]' % NUM
    except:
        print >>sys.stderr, 'Failed to add JobGroup and Job.'
        raise
            
if __name__ == '__main__':
    sys.exit(main())
    
