%define name pysilhouette
%define version 0.7.0
%define release 1
%define date %(echo `LANG=C date +%%Y%%m%%d%%H%%M%%S`)

%define _prefix /opt

%define __python $(which python)
%define __chkconfig     /sbin/chkconfig
%define __app pysilhouette
%define __prog silhouette
%define __progd %{__prog}d
%define __sysconfdir %{_sysconfdir}/opt/%{__app}
%define __bindir %{_prefix}/%{__app}/bin
%define __datadir %{_var}/opt/%{__app}
%define _defaultdocdir %{_prefix}/%{__app}/share/doc
%define python_sitelib  %{_prefix}/%{__app}/lib/python

%define _user           pysilhouette
%define _group          pysilhouette
%define _uid_min        300
%define _uid_max        350

Summary: A python-based background job manager
Summary(ja): オープンソースバックグラウンドジョブマネージャー
Name: %{name}
Version: %{version}
#Release: %{release}.%{date}
Release: %{release}
Source0: %{name}-%{version}.tar.gz
License: MIT/X11
Group: System Environment/Daemons
Vendor: Karesansui Project
URL: http://sourceforge.jp/projects/pysilhouette/
Packager: Taizo ITO <taizo@karesansui-project.info>
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-buildroot
Prefix: %{_prefix}
BuildArch: noarch

%description
Pysilhouette is a python-based background job manager,
intended to co-work with various python-based web applications.
It makes it available to get job status to programmers,
which was difficult in http-based stateless/interactive session before.
100% Pure Python.

%prep
%setup

%build
python setup.py build

%install
python setup.py install --root=$RPM_BUILD_ROOT --record=INSTALLED_FILES --home=%{_prefix}/%{__app}

mkdir -p $RPM_BUILD_ROOT%{__sysconfdir}
mkdir -p $RPM_BUILD_ROOT%{__bindir}
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
mkdir -p $RPM_BUILD_ROOT/etc/sysconfig
mkdir -p $RPM_BUILD_ROOT/var/log/%{__app}/

install -c -m 644 doc/log.conf.example $RPM_BUILD_ROOT%{__sysconfdir}/log.conf.example
install -c -m 644 doc/log.conf.example $RPM_BUILD_ROOT%{__sysconfdir}/log.conf

install -c -m 644 doc/%{__prog}.conf.example $RPM_BUILD_ROOT%{__sysconfdir}/%{__prog}.conf.example
install -c -m 644 doc/%{__prog}.conf.example $RPM_BUILD_ROOT%{__sysconfdir}/%{__prog}.conf

install -c -m 644 doc/whitelist.conf.example $RPM_BUILD_ROOT%{__sysconfdir}/whitelist.conf.example
install -c -m 644 doc/whitelist.conf.example $RPM_BUILD_ROOT%{__sysconfdir}/whitelist.conf

install -c -m 644 doc/rc.d/init.d/* $RPM_BUILD_ROOT%{_initrddir}/
install -c -m 644 doc/sysconfig/%{__progd} $RPM_BUILD_ROOT/etc/sysconfig/%{__progd}

install -c -m 744 tool/psil-cleandb $RPM_BUILD_ROOT%{__bindir}
install -c -m 744 tool/psil-set $RPM_BUILD_ROOT%{__bindir}

chmod +x %{__app}/%{__prog}.py

%clean
rm -rf $RPM_BUILD_ROOT

%pre
# Add group
getent group | %{__grep} "^%{_group}:" >/dev/null 2>&1
if [ $? -ne 0 ]; then
  __uid=%{_uid_min}
  while test ${__uid} -le %{_uid_max}
  do
    getent group | %{__grep} "^[^:]*:x:${__uid}:" >/dev/null 2>&1
    if [ $? -ne 0 ]; then
      _gid=${__uid}
      break
    fi
    __uid=`expr ${__uid} + 1`
  done
  /usr/sbin/groupadd -g ${_gid} -f %{_group}
fi

# Add user
getent passwd | %{__grep} "^%{_user}:" >/dev/null 2>&1
if [ $? -ne 0 ]; then
  __uid=%{_uid_min}
  while test ${__uid} -le %{_uid_max}
  do
    getent passwd | %{__grep} "^[^:]*:x:${__uid}:" >/dev/null 2>&1
    if [ $? -ne 0 ]; then
      _uid=${__uid}
      break
    fi
    __uid=`expr ${__uid} + 1`
  done
  /usr/sbin/useradd -c "pysilhouette" -u ${_uid} -g %{_group} -s /bin/false -r %{_user} 2> /dev/null || :
fi

%post
#echo "%{__ln_s} %{python_sitelib}/%{__app}/%{__prog}.py %{__bindir}"
%{__ln_s} %{python_sitelib}/%{__app}/%{__prog}.py %{__bindir}
if [ ! -e %{__datadir} ]; then
  mkdir -p %{__datadir} 2> /dev/null
fi
%{__chkconfig} --add silhouetted >/dev/null 2>&1
%{__chkconfig} silhouetted on >/dev/null 2>&1
#%{_initrddir}/silhouetted start >/dev/null 2>&1

%postun
rm -f %{__bindir}/%{__prog}.py
if [ $1 = 0 ]; then
  /usr/sbin/userdel %{_user} 2> /dev/null || :
  /usr/sbin/groupdel %{_group} 2> /dev/null || :
fi
#%{_initrddir}/silhouetted stop >/dev/null 2>&1
#%{__chkconfig} --del silhouetted >/dev/null 2>&1

%files -f INSTALLED_FILES
%defattr(-,root,root)
%doc doc tool MANIFEST.in LICENSE example AUTHORS ChangeLog INSTALL INSTALL.ja README README.ja setup.cfg setup.py debian
%dir %attr(0755, root, root) %{__sysconfdir}
%attr(0755, root, root) %{_initrddir}/*
%attr(0644, root, root) %config(noreplace) %{__sysconfdir}/log.conf
%attr(0644, root, root) %{__sysconfdir}/log.conf.example
%attr(0644, root, root) %config(noreplace) %{__sysconfdir}/%{__prog}.conf
%attr(0644, root, root) %{__sysconfdir}/%{__prog}.conf.example
%attr(0644, root, root) %config(noreplace) %{__sysconfdir}/whitelist.conf
%attr(0644, root, root) %{__sysconfdir}/whitelist.conf.example
%attr(0644, root, root) %config(noreplace) /etc/sysconfig/%{__progd}
#%{__bindir}/%{__prog}.py
%{__bindir}/psil-cleandb
%{__bindir}/psil-set
%dir /var/log/%{__app}

%changelog
* Fri Jul 29 2010 Kei Funagayama <kei.topaz@gmail.com> - 0.7.0-1
- 0.7.0 released.

* Tue Jun 29 2010 Kei Funagayama <kei.topaz@gmail.com> - 0.7.0-1beta3
- 0.7.0 beta3 released.

* Fri Apr 09 2010 Kei Funagayama <kei.topaz@gmail.com> - 0.7.0-1beta2
- 0.7.0 beta2 released.

* Fri Apr 09 2010 Kei Funagayama <kei.topaz@gmail.com> - 0.7.0-1beta1
- 0.7.0 beta1 released.

* Wed Jan 03 2010 Kei Funagayama <kei@karesansui-project.info> - 0.7.0-1alpha1
- 0.7.0 alpha1 released.

* Tue Aug 04 2009 Kei Funagayama <kei@karesansui-project.info> - 0.6.3-1
- Add Command Tools.
- Add Debian packaging.

* Fri Jul 24 2009 Kei Funagayama <kei@karesansui-project.info> - 0.6.2-2
- Add documentation.

* Tue Jun 16 2009 Kei Funagayama <kei@karesansui-project.info> - 0.6.2-1
- Add Database copy command.
- SQLite time to register with the system, had not added the time zone information.

* Tue May 19 2009 Taizo ITO <taizo@karesansui-project.info> - 0.6.1-1
- Update version.

* Tue Feb 4 2009 HDE Package Maintainer <info@hde.co.jp> - 0.1.0-1
- Initial build.
