#!/usr/bin/python
"""pydicfunc.cgi

  Author: tgz <tgz@users.sourceforge.jp>
  Version: 1.0
  Last Modified: 2003/03/29

  This program is based on GPL.

"""
import cgi
from re import compile
from string import replace
from sys import exit
import ndtplib

prog = compile('&lt;(?P<link>[0-9a-zA-Z^>]+:[0-9a-zA-Z^>]+)&gt;')

def initialize(server):
    n = ndtplib.NDTP(server)
    version, dictdict = n.version(), n.listdic()
    n.quit()
    return version, dictdict


def show_header(word = None):
    print 'Content-type: text/html'
    print ''
    print '<html>'
    print '<head>'
    if word != None:
        print '<title>Result of \"%s\"</title>' % word
    print '</head>'

def show_result(server, num, word):
    n = ndtplib.NDTP(server)
    n.setdic(num)
    result = n.ask(word)
    hit = len(result.keys())
    n.quit()
    print '[Query: %s]' % word
    print '[Result: %d hits]' % hit
    if hit >= 5:
        print '<hr>'
        for key in result.keys():
            print '<a href=\"/cgi-bin/pydicfunc.cgi?server=%s&num=%s&\
header=%s\">%s</a><br>' % (server, num, result[key], key)
        print '<hr>'
    else:
        print '<hr>'
        for key in result.keys():
            show_main(server, num, result[key])
            print '<hr>'

def show_main(server, num, addr):
    n = ndtplib.NDTP(server)
    n.setdic(num)
    result = n.getmain(addr)
    n.quit()
    result = replace(result, '<', '&lt;')
    result = replace(result, '>', '&gt;')
    link = prog.search(result)
    while link != None:
        result = replace(result, link.group(), \
'<a href=\"/cgi-bin/pydicfunc.cgi?server=%s&num=%s&header=%s\">%s</a>' % \
(server, num, link.group('link'), '(link)'))
        link = prog.search(result)
    result = replace(result, '\n', '<br>\n')
    print result

def show_footer(version):
    print '%s' % version
    print '</body>'
    print '</html>'

def show_error(message):
    print '<html>'
    print '<head>'
    print '<h2>Error</h2><br>'
    print '%s<br>' % message
    print '</body>'
    print '</html>'

def main():
    try:
        form = cgi.FieldStorage()
        print '<body>'
        if form.has_key('server'):
            server = form['server'].value
            version, dictdict = initialize(server)
        if form.has_key('num'):
            num = int(form['num'].value)
        if form.has_key('word'):
            word = form['word'].value
            show_header(word)
            print '<h1>%s</h1>' % dictdict[num]
            show_result(server, num, word)
        elif form.has_key('header'):
            header = form['header'].value
            show_header()
            print '<h1>%s</h1>\n<hr>' % dictdict[num]
            show_main(server, num, header)
            print '<hr>'
        show_footer(version)
    except Exception, message:
        show_error(message)

if __name__=='__main__':
    main()
