# unicode.pl - Unicode translation library for perl
# Copyright (C) 1998,1999 Masanao Izumo <mo@goice.co.jp>
#
# This program is free software.  You can redistribute it and/or modify
# it without any warranty.  This library convert unicode to/from EUC-jp.
#
# This file contains binary.  Please be careful if you edit this file.
#
# Usage:
# require 'unicode.pl';
#
# @unicodeList = &unicode::e2u($eucString);
# $eucString   = &unicode::u2e(@unicodeList);
#
# $utf8        = &unicode::UTF16toUTF8(@unicodeList);
# @unicodeList = &unicode::UTF8toUTF16($utf8);
#
# ChangeLog:
# 1998-07-09
# * Version 1.1 is released
# * Add binmode(DATA);
#
# 1998-12-07
# * Version 1.0 is released

package unicode;
$version = '1.1';

binmode(DATA);
$table_start = tell(DATA);
$e2u_size = 32768;
$u2e_size = 131072;
$cache = 1;

read(DATA, $e2u_table, $e2u_size);
read(DATA, $u2e_table, $u2e_size);

sub e2u {
    my($str) = @_;
    my($c, $c1, $c2, $i, @u, $x);

    while($str =~ /[\000-\177]|[\200-\377][\200-\377]/g) {
	$c = $&;

	if(exists $e2u{$c}) {
	    push(@u, $e2u{$c});
	    next;
	}

	if(length($c) == 1) {
	    $c1 = 0;
	    ($c2) = unpack('C', $c);
	} else {
	    ($c1, $c2) = unpack('C2', $c);
	}

	$i = (($c1 & 0x7f) << 7) | ($c2 & 0x7f);
	$x = unpack('n', substr($e2u_table, 2*$i, 2));
	$e2u{$c} = $x if $cache;
	push(@u, $x);
    }
    @u;
}

sub u2e {
    join('', map {
	if(exists $u2e{$_}) {
	    $u2e{$_};
	} else {
	    if($cache) {
		$u2e{$_} = substr($u2e_table, 2 * $_, 2);
	    } else {
		substr($u2e_table, 2 * $_, 2);
	    }
	}
    } @_);
}

sub UTF16toUTF8 {
    my($res);

    for(@_) {
	if(($_ & 0xff80) == 0) {
	    $res .= chr($_);
	} elsif(($_ & 0xf800) == 0) {
	    $res .= chr(0xc0 | ($_ >> 6));
	    $res .= chr(0x80 | ($_ & 0x3f));
	} else {
	    $res .= chr(0xe0 | ($_ >> 12));
	    $res .= chr(0x80 | (($_ >> 6) & 0x3f));
	    $res .= chr(0x80 | ($_ & 0x3f));
	}
    }
    $res;
}

sub UTF8toUTF16 {
    my($utf8) = @_;
    my($c1, $c2, $c3, $len, $at);
    my(@u);

    $len = length($utf8);
    $at = 0;
    while($at < $len) {
	$c1 = ord(substr($utf8, $at, 1));
	$at++;

	if(($c1 & 0x80) == 0) { # 0xxxxxxx
	    push(@u, $c1);
	} elsif(($c1 & 0xe0) == 0xc0) { # 110x xxxx   10xx xxxx
	    $c2 = ord(substr($utf8, $at, 1));
	    $at++;
	    push(@u, (($c1 & 0x1f) << 6) | ($c2 & 0x3f));
	} else { # 1110 xxxx  10xx xxxx  10xx xxxx
	    $c2 = ord(substr($utf8, $at, 1));
	    $at++;
	    $c3 = ord(substr($utf8, $at, 1));
	    $at++;
	    push(@u, (($c1 & 0x0f) << 12) |
		     (($c2 & 0x3f) << 6) |
		     (($c3 & 0x3f) << 0));
	}
    }
    @u;
}


#
# Cache control functions
#
sub cache {
    ($cache, $cache = 1)[$[];
}
sub nocache {
    ($cache, $cache = 0)[$[];
}
sub flushcache {
    undef %e2u;
    undef %u2e;
}



## update_table() for deveroppers.
#sub update_table {
#    require 'unicodeDef.pl';
#    local(*F);
#    my($f, $u, $e, $i);
#
#    $f = __FILE__;
#    open(F, "+<$f") || die "$f: $!";
#    seek(F, $table_start, 0);
#    print F "\0" x ($e2u_size + $u2e_size);
#
#    # ascii
#    for(0..127) {
#	seek(F, $table_start + 2*$_, 0);
#	print F pack('n', $_);
#	seek(F, $table_start + $e2u_size + 2*$_, 0);
#	print F pack('n', $_);
#    }
#
#    # Japanese
#    for(@unicodeTable) {
#	$e = $_->[0];
#
#	$i = (($e & 0x7f00)>>1) | ($e & 0x7f);
#	$u = $_->[1];
#
#	printf("## %02x %02x\n", $i, $u);
#
#	seek(F, $table_start + 2*$i, 0);
#	print F pack('n', $u);
#	seek(F, $table_start + $e2u_size + 2*$u, 0);
#	print F pack('n', $e);
#    }
#
#    # for yen sign
#    seek(F, $table_start + $e2u_size + 2*0x00A5, 0);
#    print F pack('n', 0x5C);
#
#    # for overline
#    seek(F, $table_start + $e2u_size + 2*0x203E, 0);
#    print F pack('n', 0x7E);
#
#    truncate F, $table_start + $e2u_size + $u2e_size;
#
#    close(F);
#}

1;
__DATA__
           	 
   
                     ! " # $ % & ' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ? @ A B C D E F G H I J K L M N O P Q R S T U V W X Y Z [ \ ] ^ _ ` a b c d e f g h i j k l m n o p q r s t u v w x y z { | } ~                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   abcdefghijklmnopqrstuvwxyz{|}~                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  0 00000 @ >?00000N0000   \0 \ & %    	00;=[]00	0
000
0000"   "`"f"g""4&B&@  2 3!  
  &&%%%%                                                                    %%%%%%% ;0!!!!0                      """""""*")                "'"( !!" "                      " "#"""a"R"j"k""=""5"+",              !+ 0&o&m&j   !         %                                                                                                                !"#$%&'()*+,-./0123456789:            ABCDEFGHIJKLMNOPQRSTUVWXYZ                                                                            0A0B0C0D0E0F0G0H0I0J0K0L0M0N0O0P0Q0R0S0T0U0V0W0X0Y0Z0[0\0]0^0_0`0a0b0c0d0e0f0g0h0i0j0k0l0m0n0o0p0q0r0s0t0u0v0w0x0y0z0{0|0}0~000000000000000000000                                                                                          00000000000000000000000000000000000000000000000000000000000000000000000000000000000000                                                                                                                                                                                                                                                     !"#$%&'()*+,-./                              012345Q6789:;<=>?@ABCDEFGHIJKLMNO                                                                                              % %%%%%%%,%$%4%<%%%%%%%#%3%+%;%K% %/%(%7%?%%0%%%8%B                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                NUZ?Tac(Y"uzP`cn%efhW'ebq[YІ{}b}b|[^c	fhHǗgONO
OMOPIVY7YZ\	`aapfipuOupy}}ÄcUzS;NNW߀xN Xn8z2(/QASpTTVY_m-                                                                    bpTS[pSo\zNxn&VUk;YSmftܕVBNKOSU[0_qf fhl8lm)t[vzN4[`muvʙ`iSQWX0YD[^`(cclopqqYqs?~vх`[XielZu%QY.Ye__                                                                    bej*k'ksV,\l{Q\KahvraNYOSx`in)zONSNOUO=OOsRSV	YZ[[yfggkLlpksyyz<{ۃwӇfV)NO\brYu;傽řNOVXJX^_`*``babbe9                                                                    AffhmwppuLv}uQRYT[]ahimxˈWrmlWgΒRVT^bdh<h8ksrxzkҍk핣i[f\i}MNc{ j+jh
o_RrU`pbm;nnф[DN9Sij:h*Q\zÄܓV[(h"1                                                                    |RtN~OQ[R
RR]UX*Y[[[^r^y`aacacebghShk>kSlWo"ooEtuvwz{|!}6f̌Qeә(N8T+\]svLw<\TXOOSqUVhWYG[	[\^^~_cg:eeghh                                                                    j_^0kll}uyH[cz } _w̏<NP}Q Y[b/bdk:ruyGpcʗT	TUhTjXpx'guSt[PNNENOST8[_`%eQg=lBlrlpxtzvz{}|}fer[S\E]bbcn Z1ݒoyZNNN                                                                    OOPQGzQqQSTS!SSUX\_7_J`/`P`mceYjKlrrwNWZNQ\-fim\@fiushP|PRWG]&ek#k=t4yy{K}ʂ̈_9ёTN]P6SS:rsw掯ƙșQwa^UzzPv[ӐGN2jۑ\Q\H                                                                    czltazq|h~phQlRT͐SfyAOPRQDUSW-sWYQ_b_`uavagacd:elfohBnufz=|}L}~KkJ͊cfΛRbdohAPk lzoTzt}P@#gNP9P&PeQ|R8RcUWXZ^aabcr                                                                    ij)r}rs.xxo}ywҐcuzUxQCSS^{_&nnss}C7 PNNPST|VY[d]^_'b8eEgnVr|ʈN7ǘgNNO
SHTIT>Z/__`hjtZxwN^NO|OPPQIQlRRRSST                                                                    TUWQWY}[T[][]]]^x^^^_`RaLbbce;ffCfgmh!hil_m*min/nu2vxlz?|}}}^}T*RLaʑuqx?M؝;R[RSTXboj_QKR;TJVz@w`sDo	pu_`ښrۏ                                                                    kdNVWdXZZ`haffh9hmu}:nBNOPSU]o]]gltsxPWP^c+PPQg TX^Y[_ibMch=ksnp}rxx&yme}0܈	RdW(gPjQWB*X:iT]WxO\RJTd>f(ggz{V}"/h\{9SQR7                                                                    [bddg-kvcLvfRN	PS\q`dech_qsu#{~ۑxefkNNO:OR:SSUVXYYY[P\M^^+_`ce/[\eeegkbk{lsEyIy|}}+󉖊^ifǌܖ̘koNO<OQP[W[aHcfB                                                                    k!nlr>tuxy:3ꄔlP_X+z[NSWY1Z[`nou[ {Prg\aJ~Q\chfeqny>}ʐnǐPR\:gSp|r5Lȓ+[_1`N;S[bKg1krsz.kRQSTj[cj9} VSTh                                                                    [\1]Oabm2yy}B~MҁFrt/1KlƑNOOQESA_bglAnsc~&͒SY[my]~.|X~qQSO\f%wzQ_eiokmnodv}]uQRb@ffn^}rfRSYs^_`UdPQ                                                                    RS SGSTUFU1VYhYZ<[\\\\^^^_pbbbccwfff-fvg~hjj5lmn	nXq<q&qguwx]yyeyz{|}9քI]<Tsaޑf~N
NNNWQRpWX4X["^8`dgagVmDruszcr V1W                                                                    bi
kq~Twr߇U\;O8OOUZ [[_aNc/efKhimxmu3uwy^y}3ク:2ݗNNRXuX\u\=N
Ŗcm{%ϘbVST9W^%cl4pwa|pBTt^]]iepgcngIiŘ                                                                    odz[Np,u]f/QR6RY_`'be?etffthhkcnrruv|VXːRYez^-`befgwzM|M~>
d_xRbcdBb-z{}vINQHSCS`[\\]b&bGdhh4lmEmgo\qNq}ez{}                                                                    ~Jz9n΍xwRMUo8q6Qhy~U|VLXQ\cffiZruuyyVy|} }D4;a PRuSSP	UXYOr=[\dS``c\cc?cdef]iioqNuvz|}}aIXlōpmPXa                                                                    Ӆ5 OPtRGSs`ocIg_n,O\^e}SRQvc[X[k\
d
gQ\NYY*lpQU>XY`bSg5iU@Ě(OSX[\^/_` aKb4flnހ΁Ԉ .ۛNSY'{,Lnp'SSUD[bXbblot"8o8QS                                                                    SOFTYj1]zꏿhڌ7rHj=N9SXVWfbcekNmn[pwz{}=Ɔˊ[VX_>efjku7P$wW0_`efzl`uznE{u\z{QĐyz6Zw@N-N[_bf<glkw;Njp&s*WNQFQU[                                                                    ^^3^__5_k_acfgonrRu:w:t9xv܍󒚕wRcWvgls͌Ósm%XiȉuېXZhciOCo,g؏&}Ti?opWjX[,},r*T
㝴NONP\PuRCTHX$[^^^^_`bc:chl@xyz}GD                                                                    -؟ldXdeunv{inT_dMDQxXkY)\U^m~u[pOkou0QNTX5XWY\`_eg\n!v{ߌMx%x:R^WYt`PQZQQR UXTXXYW[\]`bd-gqhChhvmnompoq_Suyw{I{T{R|}qR0                                                                    ciFv-0PRTX\admwzS\S?__mrywcy{kr슭hjaQzi4\J[őIpVx\o`eflZATQfǒ
YHQNMQꅙpXczKib~uwSWi`ߖl]N\<_Sрy^eNsQe                                                                    Y\?NY_͊oyyb[qs+q^t_c{dq|NC^NKWV`o}
3]bdgwlm>t6x4ZFuO^bceWgovrL̀)MP
WZhisqdrXjyw)O/ReSZbglv}{|6fo r~                                                                    Q{xr{{Hj^auQu`QkbnvzOpb{OVzXY䖼O4R$SJSS^d,egl>lNrHrsuT~A,錩{đqic=fiujvxЅCS*SQT&Y^_|`bIbybekluvxy}w^j|8P\>_gkt5w	                                                                    ;gzS9u_f_<_ub{F<hgYZ}v~,O_jjl7otyhhUy^cuy҂ד(򄜆-T_lem\pӘ;eOtN
NWY+Zf[Q^^`bvewefnmnr6{&P\tDOdkfaj\iSzWORo_^Eg
                                                                    yym_bUlNriRT;VtXabnqYn||}e^NOuQuX@^c^s_
gN&=[|sPXvVxR%w{POY	rG{}菺ԐMORZ)_O݂WcUkiu+܏zBRXaUb
fk|?P#OSTFX1YI[\\])^bcge>eg                                                                    llpx2~+ނ*JҘlNONPRVWJY^=__b?fgghQ}! ~2T ,SPS\Xdg4rgwfzFRlkX ^LYTg,QvdixTWYf'gkTi^UggRh]NOSbg+lO~mNabn                                                                    o+Tsg*E]{\[ƇnJzY|lw RY"q!r_wۗ'aiZZQT
T}fvߏYr]nQMh}}bdxj!Y[_ksv}Q2g(vgbR\$b;|~UO`}SN_QYr:6_%wS_y}3Vg󅮔Sa	alvR                                                                    8U/OQQ*RS[^}`acg	gngms6s7u1yPՊJćYNOYN?P^|Y[^ccdfiJimnqu(z Iɉ!
e}
a~bk2lmtmge<m}a=jNqSu]Pko͆-R)T\egNhtt                                                                    uψ̖x_sz˄NcueRmAnt	uYxk|zܟOaneņ\NNPN!Q[ehmsvBwz|oҐ|ϖuR}P+Sgmqt3*Wt`XAm}/^NO6OQR]`sy<Ӓ4
bfktRRpȈ^`Kao#qI|>}o                                                                    #,TBojp2RZA^_gi|imjorbr{~KQmy2P-Tqkjā`gNNkhi n~xU                                                                                                                                                          _NNN*N1N6N<N?NBNVNXNNkN_
NNNNNNNNNNNNNNNNNNO	OZO0O[O]OWOGOvOOOO{OiOpOOoOOQOOOOOOOOOOPP(PP*P%POOP!P)P,OOPPPCPGgPUPPPHPZPVPlPxPPPPP                                                                    PPPPPPPPPPPPQ	QQQQQQQ!Q:Q7Q<Q;Q?Q@QRQLQTQbzQiQjQnQQVQQQQQQQQQQQQQQQQQQQQQQQUQQQQQRRRRR'R*R.R3R9RORDRKRLR^RTRjRtRiRsRR}RRRRqRR                                                                    RRRRRRRRRRRRRRRSSu8S
SSSSS#S/S1S3S8S@SFSENSISMQS^SiSnYS{SwSSSSSSSSS|SfqSSSSTT=T@T,T-T<T.T6T)TTNTTuTT_TqTwTpTT{TTvTTTTTTTTTTT                                                                    TTTTTTTTUUTTTTTU9U@UcULU.U\UEUVUWU8U3U]UUTUUU{U~UUUU|UUUUUUUUUUUVUVUUVUVNVPqV4V6V2V8VkVdV/VlVjVVVVVVVVVVVVVVVVVVVVVVW VWW	                                                                    WWW
WWWUWW&W7W8WNW;W@WOWiWWWaWWWWWWWWWWWWWX
WWXXXXrX!XbXKXpkXRX=XyXXXXXXXXXXXXXXXXXXXXXXXXXYY
YYhY%Y,Y-Y2Y8Y>zYUYPYNYZYXYbY`YgYlYi                                                                    YxYYO^OYYYYYYYYZ%ZZZZ	ZZ@ZlZIZ5Z6ZbZjZZZZZZZZZZZZZ[[[[2Z[*[6[>[C[E[@[Q[U[Z[[[e[i[p[s[u[xe[z[[[[[[[[[[[[[[[[[[\\\\
\\ \"\(\8\9\A\F\N\S                                                                    \P\O[q\l\nNb\v\y\\\Y\\\\\\\\\\\\\]\]]]]\]]]]]"]]]]L]R]N]K]l]s]v]]]]]]]]]]]]]]]]]]]]^^^^^^6^7^D^C^@^N^W^T^_^b^d^G^u^v^z^^^^^^^                                                                    ^^^^^^^^^^^^^^^^__	_]_\____)_-_8_A_H_L_N_/_Q_V_W_Y_a_m_s_w____________________`_`!`````)``1```+`&``:`Z`A`j`w`_`J`F`M`c`C`d`B`l`k`Y`````                                                                    ````````````_````aMaa``a ``aa!``a
aaGa>a(a'aJa?a<a,a4a=aBaDasawaXaYaZakataoaeaqa_a]aSauaaaaaaaaaaaaaaaaaaayaaaaaaaaaab bb	b
bbb                                                                    bb!b*b.b0b2b3bAbNb^bcb[b`bhb|bbb~bbbbbbbbbbbbdbbbbbbbbcbbc'ccbbcPc>cMdcOcccccvcccccckcicccccccccdd4ddd&d6edd(ddgdodvdNe*dddddd                                                                    ddddddddd	ddbdde,dddde deeee$e#e+e4e5e7e6e8uKeHeVeUeMeXe^e]erexeeeeeeeeeeeeeeeeegrf
fegsf5f6f4ffOfDfIfAf^f]fdfgfhf_fbfpffffffffffff                                                                    ffffff?fffffgggg&g'8g.g?g6gAg8g7gFg^g`gYgcgdggpgg|gjgggggggggggggggggggggjhhFh)h@hMh2hNhh+hYhchwhhhhhhhhjhhthhhihh~ihihi"i&hih                                                                    hhhi6iihhi%hhhi(i*ii#i!hiyiwi\ixikiTi~ini9iti=iYi0iai^i]iijiiiiiiii[iiiiij.iiiiiiijjik
iiijijijij
jjj#jjDjjrj6jxjGjbjYjfjHj8j"jjjjjj                                                                    jjjjjjjjjjjjjjkjkk1kk8k7vk9kGkCkIkPkYkTk[k_kakxkykkkkkkkkkkkkkkkkkkkkkkkkklllll$l#l^lUlbljllllll~lhlsllllllllllll                                                                    lllllmMm6m+m=m8mm5m3mmmcmmdmZmymYmmommnn
mmmmmmmmmmmmmmmmmn-nnn.nnrn_n>n#nkn+nvnMnnCn:nNn$nnn8nnnnnnnnnnnnnnnnoAopLnnno?no1no2n                                                                    o>onoozoxooooo[oomoo|oXoooofooooooooooooooop	popppoppotpppp0p>p2pQpcppppppppppppq	pqqqeqUqqfqbqLqVqlqqqqqqqqqqqqqqqqqq                                                                    qqr
rrr(r-r,r0r2r;r<r?r@rFrKrXrtr~rrrrrrrrrrrrrrrrrrrPss
ssss4s/s)s%s>sNsOsWsjshspsxsus{szsssssssstttot%st2t:tUt?t_tYtAt\titptctjtvt~tttttts                                                                    ttttttttttuuuuuu
uuuu&u,u<uDuMuJuIu[uFuZuiudugukumuxuvuuutuuuuuuuuuuuuuuuuuuuuuuuuuvuuuuvv
v	vv'v v!v"v$v4v0v;vGvHvFv\vXvavbvhvivjvgvlvp                                                                    vrvvvxv|vvvvvvvvvvvvvvvvvvvvvvv/vwwww)w$ww%w&ww7w8wGwZwhwkw[weww~wywwwwwwwwwwwwwwwwwwwwxxy&x y*xExxtxx|xxxxxxxxxxxxxxx                                                                    xxxxyyyyy,y+y@y`yWy_yZyUySyzyyyyKyyyyyyyyyyyzz
zzz zyz1z;z>z7zCzWzIzazbzizpzyz}zzzzzzzzzzzzzzzzzzzzzzzzzz{{{
{{3{{{{5{({6{P                                                                    {z{{M{{L{E{u{e{t{g{p{q{l{n{{{{{{{{{{]{{{{{{{{{||{{|`| ||{{||
{|#|'|*||7|+|=|L|C|T|O|@|P|X|_|d|V|e|l|u|||||||||||||||||||||;|||||}                                                                    }}}}
}E}K}.}2}?}5}F}s}V}N}r}h}n}O}c}}}[}}}}}}}}}}}~=}}}}}}}}}}}}}~~
~#~!~~1~~	~~"~F~f~;~5~9~C~7~2~:~g~]~V~^~Y~Z~y~j~i~|~{~}~}~~~~~~~~~~~~8:                                                                    ELMNPQUTX_`higxq܀!(?;JFRXZ_bhsrpvy}Qۀـ݀Āڀց	)#/K                                                                    F>SQqneft_Ɂ́сف؁ȁځ߁

)+83@YX]Z_dbhjk.qwx~߂҂ރ܃	                                                                    5421@9PE/+#|su΃؄
" 8m*<ZwkniF,oy5ʄbل̈́ڄЄƄք!,@cXH                                                                    AKUmꅇw~ɅυЅՅ݅܅
"0?MNUT_gqĆƆɈ#Ԇކ߆ۆ 	

4?7;%)`_xLNtWhnY                                                                    ScjˇЖևćǇƇ
҈"!169';DBRY^bk~u}rÈĈԈ؈و݈
C%*+AD;68L`^                                                                    fdmjotw~ډ܉݉%6A[RFH|mlbĊ͊ڊފۋ 3&+>(ALONIV[Zk                                                                    _lot}:A?HLNPUblxz|bȌڌ

N͍gmqsύڍ֍̍ۍˍߍ	B504J                                                                    GILPHYd`*cUvr|ƎŎȎˎێ
&3;9EB>LIFNW\bcdڏ!
'659                                                                    OPQRI>VX^hovr}bHۑ20JVXceisrɑˑБ֑ߑۑ,^WEIdH?KPZϒD.                                                                    "#:5;\`|nV֓דؓÓݓГȓ6+5!:ARD[`b^j)puw}Z|~oÕ͕̕Օԕ֕ܕ!(./BLOKw\^                                                                    ]_frlΖ˖ɖ͉Mܗ
Ֆ$*09=>DFHBI\`dfhRҗkqy|z×Ɨȗ˗ܗOzߗ8$!7=FOKkop                                                                    qtsĘØƘ	!$ ,.=>BIEPKQRLUߙۙݙؙљ+7EB@C>UM[W_bedikjϚњӚԚޚߚ                                                                    "#%'()*./2DCOMNQXtʛƛϛћқԛ:	
.%$!0G2F>Z`gvx	*&#DA?>FH                                                                    ]^dQPYrozĝƝϝٝӝuy}a̞ΞϞОԞܞޞݞv!,>JRTc_`afgljwrv                                                                    X/iǐYtdQq                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             	 
   
                     ! " # $ % & ' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ? @ A B C D E F G H I J K L M N O P Q R S T U V W X Y Z [ ] ^ _ ` a b c d e f g h i j k l m n o p q r s t u v w x y z { | } ~                                                                        \                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ¦æĦŦƦǦȦɦʦ˦̦ͦΦϦЦ  ҦӦԦզ֦צ                                                                                                                                          ѧҧӧԧէ֧ا٧ڧۧܧݧާߧ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ơ    ȡ          š                                       ~                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ߢ      ࢺ                                                ʢˢ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ҡӡԡա֡סء١ڡ̡ۢ                                                                                    ¤äĤŤƤǤȤɤʤˤ̤ͤΤϤФѤҤӤԤդ֤פؤ٤ڤۤܤݤޤߤ                  ¥åĥťƥǥȥɥʥ˥̥ͥΥϥХѥҥӥԥե֥ץإ٥ڥۥܥݥޥߥ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  滰岼  Ϳ  Т    Уµʺ            ξ              Ф          Х      Ц  ð  Ч    Ш    Щǵ            Ƿ  ˳          ЪЫ          ֦                                                      Ь    Эλ  ͽЯ  в      ް        где˴ж        μ  з    и    й                о  м  н      лкʩ        ƻ¾п                                          Ǥ                        İ    Ȳ                                                          ȼ                      â          㽻ͤ        ;Ǻդ                                    ʻ        ϸ                                                                ե            η                    ¥                          ¯                                  ɶ                                                                                                                                                                      ¦                                    ˵                                                            ѣ                    Ѥ          ѡѢ    Ư          ѥ      ν      Ѧ        ѩ  ѧ            ѨѪ            Ѭ      ѫ          Ѯѯ          ѭ                  ѲѱѰ    ѳ          Ѵ                ͥ                      Ѷ    ѵѸѷ    ѹѺ    Ѽ    ѻ  ѽ                      Ѿ        Ȭϻ          ʼ¶ŵ                      Ǻ  ƺ    ̾                  ̽        Ӻ                      ٽ      ο                                              ೮      ᶧ  ̱    ȡ        ʬڴ                                        Ƚ                    ɹ                  §                ˶                                                              έ                                              عҢң          ϫҥ          Ҥ      Ҧ    ļ  ͦ        ҧ            ư  Ҩ̳      ҩҭ  Ҫ  ҫ                    Ү  ү    Ұұ            Ҳ  ҳ        ҵ  ҷҶ        Ҹ  ҹ          Һ                    һ  Ҽ  ҽ        Ҿɤ      ƿҿ    Ⱦ          ´    ñ                              ȱ  ¨  ˲                                                                        ߱                                            ͧȿ                        ѸŶ    áڲ漸˱                    ɳ      ߱Ʊ̾Ǹ                                                      ۿ  ʭ߸    Ϥ                                                                          ̣        ̿                                                        ӣ        ӡ    Ӿ    鳱              ӥӤ  Ӣ                                  Ӧ                ӯ    ӧӨ        ӭӬ      ů              Ӯ    ӫ                            ө      Ӫ                                                Ӵͣ    Ӻ        ӹӰ          ӱ      Ӷ          ӳ              ӷӸ        ӵӻ          Ӳ                                                  ӽ          ӿ                        Ӽ                ӵʶ                                          ԧ                                                                                                        ò                          Ծ                                                                                                                                                  ʮ        ȸ                                                                ǹ                                                                                                                  Ͽ                          ԡ  Ԣ  ԣ      Ԥ    Ԧ  ԥ      Ԩ                ԩ                        Ԫԫ    ԭ        Ԯ              ˷      Ԭԯ                              Գ      ó    ԰                                        Դ              ԲԵ                Զ                        Է  Թ          Ժ          Ի    Ը                        Ա    Լ    Խ                  ԿԾ            Ǹ                                              ݴ          Ʋ                                                                                        ʽ                                ȹ                          Ŷ                                                                                                                  ʯ                                                                    ο                                                ͼ  ɽ¿          ̴        ŷ                                                                      å    ʳ              ա              բǡ          ǥ    ի                  ̯  ֬  գ          զ      ˸                է                                ը                        լխ  ժ                  թ  ɱ                                                ղ              հ            ̼  ճ  ձ    կ        ծ                          շո                մϬ            ն                                              չ            պ  յ                                    ̻                                                  ջɲ                                                                ռս    տ              վ                                                                                                                                                                                                                              ¸  ֻڹ        ׳      ¹        ֣                              ״              갸      뼼ͨ                    㾬                ̩                            뻡    ǫͿ                        м    º  Ƴ                                                            ܿǢ          ϲ  ֢֡    Ÿ                °  ˼                ֤  ֥          ֧    ֨                                    ֩      ֪    ֫                                      ̨֭              ֱ֯    ְ֮  ֳ            ֲ  ִ                                  ֵ            ƽ            ֶֻ    ֹ                  ָ  ַ                        ּ            ֽ־                                                                                                                ֿ                                                                            ֺ                                                                                                                                                    ̦          ç                                  ġ                                  ӵ    Ģ            ˹                                                Ȩʾ                          ʿǯ  ͩ  ģ                            Ź                      ٺ                      ý                        ϭ                ס      פץ  ף  קצע        רש    ת      ׭׫  ׬׮  ׯ  Ƕ  װ    ױϮ        ײ׵Сб  ׶  Ĥ׷ʦ                    ︹  ׸      ׹  ׿        ĥ  ׺      ɫ      ׻            ׼    ׽  ׾                ״׳      ķ      ɧ    ɷĦ                      ʱȷ    Χ      ̽                Ҹ                        ħ        Ű    յ            ɬ            Ǧ                ֻ˺˻                                  ح      ǰ                                                                                                                                              ©                              ء          ا        إ    أؤ    آ      ͪ        ئ  Ǻ              جذ  ة      خ              د                    ث        ر        تب                      ؽ  ظ  صض  عؼ        ط  غ    ش        ؾؿ          س                ػ                                                        ֹز                            ų        θӰ  ٷ                  ͫ                                                ʰ    ƴ                                          꺩                                                                  Ĩ                                      ١  ٢              ٣      ٤٥  ٦٧                ˼٨              ٩          ʧ        ٬    ٪  ٭    ٫        ٮ          ʱ                    ٯ  ٲ  ٰٷ        ٱ            ٳٴٸٵ    ȴ                          ڭ                      ٻ            ôپ    ټٺٶ    ٹ                          翡      ϻ            ٽ          Ͱ            ĩ                                      ˰                                                    ª                Ľ                                              پ    Ǳ                                                Ϋõ    ص                                ·                        ͬ      ȴ                                                                                  »                                                                                                                      Ŧ                                                                                                            ǲ      Ƶ          ű          Ż                  ڥ        ڧ    ڣ  ڤ                  ڢ  ٿ      ڦ  ڡ          ګڬŧڮ    ک            گ  ڨڳ  ڲ  ڱ      ڴ    ڶ  ڵ        ڹ                                    ڷ      ڸ          ڻں          ڼڰ            ڽھڿ                                      Ƕ                                    Ũ                          ʸ                      ϼ                  ѻ  ۿ                          ι            ²                        ܴ    ö    ܰ                                                                                                                ۦ                                                                                                              Ȱ                Ī                            ˽      ۢ              ۡ                              ۣ    ۤ      ۥ          ۧ    ۨ            ۩  ʱȹ۪  ۫    غ            ͭ      ۬        Ŀۭϯ      ˾  īۮ            ۯ۰  ̤ܻ۲          ۴۷۶        ۳  ۵        ۸            ɺ¼          ۻ      ۹«ۺۼ۽              ۿ                            ۾                        ̻    ƿ                                                      ɢ      ˿          ͮ                            ƺ                  ʱ                                                            ۳                    ˺    ʺ    ܷ                ͷ                            ɰ                                                                                                                            ܲ                ܡܣ  ܧ  ê        ܫ  ܨ      ܢ            ܬ                ܪ              ܦ        ̺    ܥ            ܯ        ܱܰ  ܩ  ܭ  ܮ          ܿ        ܤ    ܻ      ܽ                                      ܸ      ܾ  ܵ                ܷ  ܺ      ܼ  ܴܶܳ    ϰܹ    ó                            ϱ                                                                            ι                                                                                                    ɸ                                        î                                                                                                                                              ݡ                            ݬ  ݨ          ݧ        ݦ    ݣ          ݥݤ                          ݪ  Ϧ            ݭ    ݩݫ                ȧ  ݮ                              ݲݯ                ݰ                      ݳ      ݴ              ݶ缡                                    ݸݷݺ    ִ        ݽ      ݼ  ݾ      ÷  ݿ                      Ļ                                            ޼                Ϳ                                        ղ                                                                                                                                        ̱                                                            ɹ                                                      繾                                                                                                                      ʨޡ                            ˡ    ޤ  ޢ        ˢȵ  ť      ޥ        ޣ                                                ް          ޯ          ެ      ƶަ                ̹ީ            ޮ  ޭި  ޫ      ު    ή                                          ޶޴              ޱ޳      ϲ                  ޵                      ޺          Ͱ  ޷        ޲  ޸                                                    ޾                        ޿                                  ø          Ͱ          ʥ    ޻ź                    Ѿ޽                ޼      ҽ    ۵  ߰      ¬ѹ                                            ̫                        ù                    ͯ                                  Ѽ                    Ȯ    ︻                  ί                                        Ů                                                                                  ũ    ߣ            ɺ                    ϳ    ߢ                                    ̡                            ߡ                                          ߯    ߪ              ߳            ߬Ĭߩ            ߦ  ߥ  ߮      ߨߧ߭    ߤ              ߰    ߱                            ߶  ߵ߷          ߺ              ߴ          ߸            ߲ǻ    ߹                          ߾߼    ߿          ߻Ǩ    ޹            ߽      ߫                                                                                                                                                                                                                      ޺                      ϧ                                                            ú                                                                                                                            ˣ                                                        ʲ          ̵                                                                                                                                                                                                                                      Ǯ                              ǳ                                              绸                                                                                                                            ּ                        ĭ          ౲      ̶  ϴ          ʪ                                                                                                                                                                                                  ȶ                  ì    ϵ                                                                      ǭ              ͱͲ            ѱ                                                                                                                Ψ                                                                                                                                                                                                                ΰ                                                                            ֶ                                                                                                                                                                                                                                                                                      ɻ                                                                      ż                      ͳÿ      Ҵ  Į                    ³    Ȫ            α    ȫ  ɭ  ά                                      ɥ                                                              տ    Լ                                            Ρ                                                                                                                                                                                                                        ȯɴ      Ū                                                                                                                      ݹ                          ľ                            Ǹ                                ÿ̲                                      į                                                                                                                                                                                                  Ʒ                                                          ̷                      û䶺                                                                                          ֵֺ                    ˤ                                                                                                      β        ȣ                                                                                                                                                                                                                                                                                                                      㫷                      ʹ              ˿  Ǫ        ɼ                                      ɶ    Ͻ            ʡ                                                      ǩ                  ٲŽ                                                                                                                          ̭    ɣ                                    ʰ              ˲Է̹ƹ                ѱϲ                              Ҿ                                ֶ                                                                  ݷ                                        Ω                  ε    Ƹ      è      ü            ѿݼ                                          ū                                                              ɮ  Ȧ    ȵ                                                                              ϲ                ̧                        ý          Ȣ          Ȥ                                                                          ϶                                                                                                                                                                                                                        η          ʴ    ̰      γ      Ǵ              崡                                                                        ʵ                                                      Ǽ    ɳ        ӹɻʶ      º                  ߺ  娿        Һ                    妷  岷                                                                                                          ³                      ǹ        þ  忰                          н                        Դ                                                                                            ˥                                                                                                                      Ż                                                                                                                                                                                                                                                                                                                                                                                                    歺      ȳ                                                                溷                                                                                                                                Ϸ  μ        ϼ                                                                        ÿ                                                  ʹ                          İ  㿦        ϸ        ȥ    Ͼȩ                  ɪ          Ի                ϰ                                                              ˦                                ƹ            ǽ            ̮                                                                  æ  Ǿ          ı                                      礹                                                    Ĳʢ                                              ɨ                                          ǿ                        ¡                                                  ˱            жڪ  Ҽ    а      ޴                        չ                                                                                            忧                                                                                              ˧        ݶ                                                                                              س                                                                                                                                                                                                                                                                                                                                                      ڸɩ                        ƺ          ˨̰                                                                                                    Ϊ                                ơ            Ǭ                                                                                                                                㳸      ̬                                              ˩  ϡ                                                            ̢                                              ¢                            ּ                                            Ƣ                                                                                        骻ŷ                                                                                      ƣ                                                                      ݱݢ                                                                                              ȸ                  κ                                                                                                                                                                        ׼      ֳ                                Ⱥ                                      ˪                              ̪                                                                              Ϲ                                                        ĳ                                      ͻ                                                                                                                                                                                                                                                                                                        ާ        ʽ                Ͱ        ɽ                              ж                                µ                                                                            ΢        ͵            Σ                                                    ʣ              ˫                                                                                                                                                                          ʤ  뫸                                        믿          보                                                                                                                                              Ƥ                                  ˬ                                                      ɾ                  η            ó                                    ǧ              Ͷ            ظ            ï                      Ĵ                                  ĵ                ͡                      űڰ  ƥ                                              ɵ                                                                                                  죵                                                                                                                                                                                                                                                                                                                                                                            ë                      Ʀ    ˭                                                Ю                      ɿ                                                          ϲŴ  ȵ      Ž  ǲϨ      ±                      ϻ                                          ҹ              £  մ                                                                                                                                                                                                                Ķ                                                                                  ­                                                                                      ϩ      ķ                                          Ƨ                                                                                                                                                                                                                                                                                    µ                                  ž                                          ŷ                                    ϵ                                        ͢                    Ų                                                                                                                                                        ҡ        ä            Թ    é                                                                ų                      ƨ            Ʃ        ®¤Ϣ                                ɯ      ۿ        ͷ  ײƻã      ½            Ŭ                                    ͸                                      ˮ                        š                                      Ϻ                                                                ͹                                                                                                    Ţ                                                  Ľ                                                                                                    Ȱ                                                                    кӼ  Τڶ          ţ    ޳          ն                                                                  ߳                                                                                        Ŵ                                        ȭ                                                        Ƽ                              ĸ                                                                                                  ˯                                                                                                                                        ϣ      Ͽ                                                                                                                                                                                                                                                                ŭ                                                                                                                  ƪ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      Ĺ                          ۳                            سչȶ                                                                    Ʈ                                                                                                                                                                                                                              ؽ                  ƫΦ                    δ      𦳬            ݾ                                  Ȼ          ͺ                              Υ          㼶        ʷ                                                                  ̸                Ϫ          ۱                                                          Գ                                                                                                                                                                                                        ǣ                        ĺ              ´                                      Ƭ                                            ۳        鸲        ſ                                                                                                                                                                                                                                                      Ҭݻ                    ˰                                                                                                                                                                                                                                                  Ź                                                                  ̱ض                ζ                                                                                                                                              ƭ                                                                                                                                                                                                                                                                                                            ȱ  ɦ                                                                                                ݵ                        ̥                                                                    ϥ                                                            ʫ                                                                                                                                                                          ճ                                            ۰              ͱ                  í                                                                                                                                                                                                                                                                                                          Ļ    ȷ            ˱                              ƾ                                                򼲲                                                                            ̹                  ˲                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ϼ                                                      й                        Ե                                                                                Ť                                                                              ɡ                                                                                                                            ζ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ʡˡܡ  䡩£ãģţƣǣȣɣʣˣ̣ͣΣϣУѣңӣԣգ֣ףأ٣ڡ  ϡСá      ÎĎŎƎǎȎɎʎˎ͎̎ΎώЎюҎӎԎՎ֎׎؎َڎێ܎ݎގ                                                                                                                                                                                            
