######################################################################
# bookmark.inc.pl - This is PyukiWiki, yet another Wiki clone.
# $Id: bookmark.inc.pl,v 1.27 2006/03/06 11:01:57 papu Exp $
#
# "bookmark plugin" version 1.0 $$
# Author: Nanami http://lineage.netgamers.jp/
# Copyright (C) 2004-2006 by Nekyo.
# http://nekyo.hp.infoseek.co.jp/
# Copyright (C) 2005-2006 PyukiWiki Developers Team
# http://pyukiwiki.sourceforge.jp/
# Based on YukiWiki http://www.hyuki.com/yukiwiki/
# Powerd by PukiWiki http://pukiwiki.sourceforge.jp/
# License: GPL2 and/or Artistic or each later version
#
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
# Return:LF Code=EUC-JP 1TAB=4Spaces
######################################################################
#
# ֥åޡ󥯤롣
#
# Usage: &bookmark(text,url,pagename,[start],[text2]);
#
# WindowsInternet ExplorerΤߤưޤ
# ʳξϲʸϤޤ
#
#  text     : 󥯥ƥȡʾάԲġ
#  url      : ֥åޡоݤURLʾάwikiTOPڡ
#  pagename : ڡ̾ʾά$::wiki_titleޤFrontPage1)
#  start    : startʸȡȥڡʥ֥饦ư
#             ΥڡˤϿޤWindowsIE5ʹߤΤ
#  text2    : IE4.xʲλˤϥȥڡϿǤʤΤ
#             ʸꤷޤ
#
# Example
#  &bookmark(֥åޡ,ʤʤߤΤڤ,http://hogehoge/);
#  &bookmark(ȥڡϿ,,,start,֥åޡϿ)
#  &bookmark(ȥڡϿ,,http://hogehoge/,start);
#
######################################################################
use strict;
my $body;

my $js_bookmark=<<EOM;
<script type="text/javascript"><!--
function setbookmark(u,t) {
	if (document.all){ 
		window.external.AddFavorite(u,t);
	}
}
//--></script>
EOM

my $js_reghome=<<EOM;
<script type="text/javascript"><!--
function sethomepage(u,t) {
	var ua = navigator.userAgent;
	var ie = ua.indexOf("MSIE");
	var iever = parseInt(ua.substring(ie+5,ie+6,ie+7,ie+8,ie+9));
	var os = ua.indexOf("Windows");
	if (document.all){ 
		if(ie > 0 && iever >= 5 && os > 0){
			document.body.style.behavior = "url('#default#homepage')";
			document.body.setHomePage(u);
		}else{
			window.external.AddFavorite(u,t);
		}
	}
}
//--></script>
EOM

sub plugin_bookmark_convert {
	return &plugin_bookmark_inline(@_);
}

sub plugin_bookmark_inline {
	my ($arg)=@_;
	my ($title,$url,$pagename,$mode,$title2)=split(/,/,$arg);
#	my $body;

	my $agent=$ENV{HTTP_USER_AGENT};
	return ' 'unless($agent=~/MSIE/ && $agent!~/Opera/);

	my $iever;
	if($agent=~/MSIE\s(.*?);/) {
		$iever=$1 + 0;
	}
	return if($url ne &javascriptspecialchars($url));
	$pagename=&javascriptspecialchars($pagename);

	if(&plugin_bookmark_pyukiver) {
		$url=$::basehref if($url eq '');
	} else {
		$url=&getbasehref if($url eq '');
	}
	if($pagename eq '') {
		if($::wiki_title ne '') {
			$pagename=$::wiki_title;
		} else {
			$pagename=$::form{mypage};
		}
	}
	if($url!~/^http/ && $title eq '') {
		$body=<<EOM;
<br>
<strong>bookmark plugin</strong><br>
Usage: #bookmark(text,[url],[pagename],[start]);<br>
EOM
	} else {
		if($mode=~/([Hh][Oo][Mm][Ee])|([Ss][Tt][Aa][Rr][Tt])/
			&& $agent=~/Windows/ && $iever>=5) {
			$body=<<EOM;
<a href="javascript:void(0);" onclick="sethomepage('$url','$pagename');">$title</a>
EOM
			$::IN_HEAD.=$js_reghome if($::IN_HEAD!~/function\ sethomepage/);
		} else {
			$title=$title2
				if($iever<5 && $mode=~/([Hh][Oo][Mm][Ee])|([Ss][Tt][Aa][Rr][Tt])/
					&& $title2 ne '');
			$body=<<EOM;
<a href="javascript:void(0);" onclick="setbookmark('$url','$pagename');">$title</a>
EOM
			$::IN_HEAD.=$js_bookmark if($::IN_HEAD!~/function\ setbookmark/);

		}
	}
	return $body if(&plugin_bookmark_pyukiver);
	if($::IN_HEAD=~/function\ set(homepage|bookmark)/) {
		$body=$::IN_HEAD . $body;
		$::IN_HEAD="<!-- function sethomepage, function setbookmark -->";
	}
	return $body;
}

sub javascriptspecialchars {
	my ($s) = @_;
	$s =~ s|\r\n|\n|g;
	$s =~ s|\&|&amp;|g;
	$s =~ s|<|&lt;|g;
	$s =~ s|>|&gt;|g if($s=~/</);
	$s =~ s|"|&quot;|g;
	$s =~ s|'|&apos;|g;
	return $s;
}

sub plugin_bookmark_pyukiver {
	my ($v,$s)=split(/\-/,$::version);
	$v=~s/\.//g;
	return 1 if($v+0>=16);
	return 0;
}

sub getbasehref {
	# Thanks moriyoshi koizumi.
	my $basehref = "$ENV{'HTTP_HOST'}";
	if (($ENV{'https'} =~ /on/i) || ($ENV{'SERVER_PORT'} eq '443')) {
		$basehref = 'https://' . $basehref;
	} else {
		$basehref = 'http://' . $basehref;
		$basehref .= ":$ENV{'SERVER_PORT'}" if ($ENV{'SERVER_PORT'} ne '80');
	}
	$basehref .= $ENV{'SCRIPT_NAME'};
}

1;
__END__

=head1 NAME

bookmark.inc.pl - PyukiWiki Plugin

=head1 SYNOPSIS

 &bookmark(Bookmark This Page);
 &bookmark(Regist Start Page,http://pyukiwiki.sourceforge.jp,start,Bookmark This Page);

=head1 DESCRIPTION

Make Bookmark link for Windows Internet Explorer

=head1 USAGE

 &bookmark(text, [url], [page name], [start], [substitution text]);

=over 4

=item text (Indispensable)

It writes hear, link text.

=item url

Link to url

When omits, $::basehref url is displayed.

=item page name

Bookmark to page title.

When omits, $::wiki_title value or FrontPage title is displayed.

=item start

Create link for registering start page.

The link automatically registered into a bookmark is created to the browser which cannot be registered into a start page.

=item substitution text

It is an alternative text for registering with the bookmark to the browser which cannot be registered into a start page.

=back

=head1 SEE ALSO

=over 4

=item PyukiWiki/Plugin/Nanami/bookmark

L<http://pyukiwiki.sourceforge.jp/PyukiWiki/Plugin/Nanami/bookmark/>

=item PyukiWiki CVS

L<http://cvs.sourceforge.jp/cgi-bin/viewcvs.cgi/pyukiwiki/PyukiWiki-Devel/plugin/bookmark.inc.pl>

=back

=head1 AUTHOR

=over 4

=item Nanami

L<http://lineage.netgamers.jp/> etc...

=item PyukiWiki Developers Team

L<http://pyukiwiki.sourceforge.jp/>

=back

=head1 LICENSE

Copyright (C) 2005-2006 by Nanami.

Copyright (C) 2005-2006 by PyukiWiki Developers Team

License is GNU GENERAL PUBLIC LICENSE 2 and/or Artistic 1 or each later version.

This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=cut
