######################################################################
# qreki.pl - This is PyukiWiki, yet another Wiki clone.
# Q-reki math library
#
# $Id: exdate-qreki.pl,v 1.12 2010/11/27 02:33:38 papu Exp $
#
# "exdate.inc.cgi" version 1.03 $$
# Copyright (C) 2010 by Nanami.
# Copyright (C) 2010 PyukiWiki Developers Team
# License: GPL v2 or (at your option) any later version
# http://nekyo.qp.land.to/
# http://pyukiwiki.sourceforge.jp/
#
# Based on YukiWiki http://www.hyuki.com/yukiwiki/
# Powerd by PukiWiki http://pukiwiki.sourceforge.jp/
#
# This is Q-reki math library.
# Arranged for Perl Script by N.Ueno
# http://www3.biwako.ne.jp/~nobuaki/qreki/
# Based on QRSAMP by H.Takano
# http://www.vector.co.jp/soft/dos/personal/se016093.html
#
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
# Return Code:LF
# 1TAB=4Spaces Japanese Code=EUC
######################################################################

package qreki;

#-----------------------------------------------------------------------
# ߼Ψȡʳ٤Ρ٤饸Ѵ뷸
#-----------------------------------------------------------------------
$PI=3.141592653589793238462;
$k=$PI/180.0;

#-----------------------------------------------------------------------
# ۤβ٤ꥦ
#-----------------------------------------------------------------------
sub sun2jd {
	my($year,$tk) = @_;
	my $t= ($year - 1975) * .999978626 + $tk * .0027777184 + .016566868;
	my $tm1;
	my $tm2;
	my $tm;

	$tm1  = &sunjd_sub(-.7754 * $t + 4.21) * .0003;
	$tm1 += &sunjd_sub(18.849 * $t + 6.102) * .0003;
	$tm1 -= &sunjd_sub(12.5667 * $t + 3.457) * .0004;
	$tm1 += &sunjd_sub(5.2238 * $t + 4.081) * .0004;
	$tm1 += &sunjd_sub(5.5076 * $t + 4.622) * .0004;
	$tm1 += &sunjd_sub(-.3981 * $t + 1.73) * .0005;
	$tm1 += sin(-.0262 * $t + .176) * .0005;
	$tm1 += &sunjd_sub(5.8849 * $t + 4.173) * .0006;
	$tm1 += &sunjd_sub(-.5297 * $t + .211) * .0007;
	$tm1 += &sunjd_sub(1.5774 * $t + .934) * .0007;
	$tm1 += &sunjd_sub(11.5068 * $t + 3.63) * .0008;
	$tm1 += &sunjd_sub(3.9301 * $t + 3.684) * .0013;
	$tm1 += &sunjd_sub(7.8604 * $t + 4.231) * .0015;
	$tm1 += sin(-.0035 * $t + 5.126) * .0018;
	$tm1 += &sunjd_sub(-77.7138 * $t + 5.833) * .0018;
	$tm1 += &sunjd_sub(5.7533 * $t + 4.974) * .002;
	$tm1 -= &sunjd_sub(-.33756 * $t + 4.3396) * .0048;
	$tm1 += &sunjd_sub(12.566 * $t + 6.1621) * .02;
	$tm1 += &sunjd_sub(6.28302 * $t + 6.22264) * (1.9159 - .000048 * $t);

	$tm2  = &sunjd_sub(12.566 * $t + 1.44971) * .000688;
	$tm2 += &sunjd_sub(6.28302 * $t + 1.51025) * (.032957 - 8.3E-07 * $t);
	$tm2 += .985648;

	$tm  = ($t * 365.25 - $tm1/$tm2 + 42412.0008347) / 1.0000000317;
	$tm += 2400000;
	$tm += 9/24;
	return($tm);
}

#-----------------------------------------------------------------------
# sun2jd sub
#-----------------------------------------------------------------------
sub sunjd_sub {
	my($a) = @_;
	return sin($a - int($a / (2*$PI)) * 2 * $PI);
}


#=========================================================================
# ׻ץץ  $Revision: 1.12 $
# Coded by H.Takano 1993,1994
#
# Arranged for Perl Script by N.Ueno
# 
# 
# ꥸʥΥץȤϹAWKǤǤޤ
# http://www.vector.co.jp/soft/dos/personal/se016093.html
#
#
#========================================================================

#=========================================================================
# б롢롣
#
# ƤӽФ˥åȤѿ
# year : ׻
#         mon
#         day
#
# ͡kyureki : γǼ򤫤
#           kyureki[0] : ǯ
#           kyureki[1] : ʿ flag .... ʿ:0 :1
#           kyureki[2] : 
#           kyureki[3] : 
#
#=========================================================================
sub calc_kyureki
{
	local($year,$mon,$day) = @_;
	local(@kyureki,$tm,@saku,$lap,@a,$i,@m);

	$tm0 = &YMDT2JD($year,$mon,$day);

#-----------------------------------------------------------------------
# ׻оݤľˤʬλ
# chu[0,0]:ʬλ  chu[0,1]:λ۲
#-----------------------------------------------------------------------
	($chu[0][0],$chu[0][1]) = &before_nibun($tm0);

#-----------------------------------------------------------------------
# 浤λ׻ʣ׻
# chu[i,0]:浤λ  chu[i,1]:۲
#-----------------------------------------------------------------------
	for($i=1;$i<4;$i++){
		($chu[$i][0],$chu[$i][1]) = calc_chu($chu[$i-1][0]+32.0);
	}

#-----------------------------------------------------------------------
#  ׻оݤľˤʬľκλ
#-----------------------------------------------------------------------
	$saku[0] = &calc_saku($chu[0][0]);


#-----------------------------------------------------------------------
# λ
#-----------------------------------------------------------------------
	for($i=1;$i<5;$i++){
		$tm=$saku[$i-1];
		$tm += 30.0;
		$saku[$i]=&calc_saku($tm);

# Ʊ׻ξԤκ26ˤˤϡͤ
# +33ˤƺƼ¹Ԥ롣
		if( abs( int($saku[$i-1])-int($saku[$i]) ) <= 26.0 ){
			$saku[$i]=&calc_saku($saku[$i-1]+35.0);
		}
	}

#-----------------------------------------------------------------------
# saku[1]ʬλˤʤäƤޤäˤϡ򤵤Τܤ᤮
# ȹͤơλ򷫤겼ƽ롣
# κݡ׻saku[4]ˤˤʤäƤʬ䤦ᡢλ׻
# 롣ʶ̲ζդǺ󤬤ȵ褦...
#-----------------------------------------------------------------------
	if( int($saku[1]) <= int($chu[0][0]) ){
		for($i=0;$i<5;$i++){
			$saku[$i]=$saku[$i+1];
		}
		$saku[4] = &calc_saku($saku[3]+35.0);
	}

#-----------------------------------------------------------------------
# saku[0]ʬλʸˤʤäƤޤäˤϡ򤵤Τܤ­
# ʤȸơλ򷫤夲ƽ롣
# κݡ׻saku[0]ˤˤʤäƤʬ䤦ᡢλ׻
# 롣ʽʬζդǺ󤬤ȵ褦...
#-----------------------------------------------------------------------
	elsif( int($saku[0]) > int($chu[0][0]) ){
		for($i=4;$i>0;$i--){
			$saku[$i] = $saku[$i-1];
		}
		$saku[0] = &calc_saku($saku[0]-27.0);
	}

#-----------------------------------------------------------------------
# ƣ祻å
# ǣδ֤˺󤬣󤢤ȡǽ롣
# lap=0:ʿ  lap=1:
#-----------------------------------------------------------------------
	if(int($saku[4]) <= int($chu[3][0]) ){
		$lap=1;
	}else{
		$lap=0;
	}

#-----------------------------------------------------------------------
# κ
# m[i,0] ... ̾1: 2: 3: ....
# m[i,1] ... ե饰0:ʿ 1:
# m[i,2] ... jd
#-----------------------------------------------------------------------
	$m[0][0]=int($chu[0][1]/30.0) + 2;
	if( $m[0][1] > 12 ){
		$m[0][0]-=12;
	}
	$m[0][2]=int($saku[0]);
	$m[0][1]=0;

	for($i=1;$i<5;$i++){
		if($lap == 1 && $i !=1 ){
			if( int($chu[$i-1][0]) <= int($saku[$i-1]) || int($chu[$i-1][0]) >= int($saku[$i]) ){
				$m[$i-1][0] = $m[$i-2][0];
				$m[$i-1][1] = 1;
				$m[$i-1][2] = int($saku[$i-1]);
				$lap=0;
			}
		}
		$m[$i][0] = $m[$i-1][0]+1;
		if( $m[$i][0] > 12 ){
			$m[$i][0]-=12;
		}
		$m[$i][2]=int($saku[$i]);
		$m[$i][1]=0;
	}

#-----------------------------------------------------------------------
# 󤫤롣
#-----------------------------------------------------------------------
	$state=0;
	for($i=0;$i<5;$i++){
		if(int($tm0) < int($m[$i][2])){
			$state=1;
			last;
		}elsif(int($tm0) == int($m[$i][2])){
			$state=2;
			last;
		}
	}
	if($state==0||$state==1){
		$i--;
	}

	$kyureki[1]=$m[$i][1];
	$kyureki[2]=$m[$i][0];
	$kyureki[3]=int($tm0)-int($m[$i][2])+1;

#-----------------------------------------------------------------------
# ǯη׻
# ʵ10ʾǤĿ礭ˤϡ
#   ޤǯۤƤʤϤ...
#-----------------------------------------------------------------------

	@a = &JD2YMDT($tm0);
	$kyureki[0] = $a[0];
	if($kyureki[2] > 9 && $kyureki[2] > $a[1]){
		$kyureki[0]--;
	}

	return($kyureki[0],$kyureki[1],$kyureki[2],$kyureki[3]);

}

#=========================================================================
# 浤λ
# 
# ƤӽФ˥åȤѿ
# tm ........ ׻оݤȤʤʥꥦ
# chu ....... ͤǼΥݥ󥿡
# i ......... ͤǼֹ
#  .... 浤λλβФϤ
#
#=========================================================================
sub calc_chu
{
	local($tm) = @_;
	local($tm1,$tm2,$t,$rm_sun0,$rm_sun,$delta_t1,$delta_t2,$delta_rm);
	local(@temp);
#-----------------------------------------------------------------------
#ʬ򤹤
#-----------------------------------------------------------------------
	$tm1 = int( $tm );
	$tm2 = $tm - $tm1;

#-----------------------------------------------------------------------
# JST ==> DT =0.0sec ȲꤷƷ׻
#-----------------------------------------------------------------------
	$tm2-=9.0/24.0;

#-----------------------------------------------------------------------
# 浤β sun0 
#-----------------------------------------------------------------------
	$t=($tm2+0.5) / 36525.0;
	$t=$t + ($tm1-2451545.0) / 36525.0;
	$rm_sun = &LONGITUDE_SUN( $t );

	$rm_sun0 = 30.0*int($rm_sun/30.0);

#-----------------------------------------------------------------------
# ֤׻ˤä浤λ׻
# ʸ1.0 secˤʤäǤڤ롣
#-----------------------------------------------------------------------
	for( $delta_t2 = 1.0 ; abs( $delta_t1 + $delta_t2 ) > ( 1.0 / 86400.0 ) ; ){

#-----------------------------------------------------------------------
# sun ׻
#-----------------------------------------------------------------------
		$t =($tm2+0.5) / 36525.0;
		$t =$t + ($tm1-2451545.0) / 36525.0;
		$rm_sun=&LONGITUDE_SUN( $t );

#-----------------------------------------------------------------------
# к ˡsun ݦsun0
#-----------------------------------------------------------------------
		$delta_rm = $rm_sun - $rm_sun0 ;

#-----------------------------------------------------------------------
# ˤΰϰϡʡ180ˤæˤϡԤ
#-----------------------------------------------------------------------
		if( $delta_rm > 180.0 ){
			$delta_rm-=360.0;
		}elsif( $delta_rm < -180.0 ){
			$delta_rm+=360.0;
		}

#-----------------------------------------------------------------------
#  t
# delta_t = delta_rm * 365.2 / 360.0;
#-----------------------------------------------------------------------
		$delta_t1 = int($delta_rm * 365.2 / 360.0);
		$delta_t2 = $delta_rm * 365.2 / 360.0;
		$delta_t2 -= $delta_t1;

#-----------------------------------------------------------------------
# 
# tm -= delta_t;
#-----------------------------------------------------------------------
		$tm1 = $tm1 - $delta_t1;
		$tm2 = $tm2 - $delta_t2;
		if($tm2 < 0){
			$tm2+=1.0;$tm1-=1.0;
		}
	}

#-----------------------------------------------------------------------
# ͤκ
# chu[i,0]:ΤȡDT ==> JST ѴԤͤȤ
# =0.0sec ȲꤷƷ׻
# chu[i,1]:
#-----------------------------------------------------------------------
	$temp[0] = $tm2+9.0/24.0;
	$temp[0] += $tm1;
	$temp[1] = $rm_sun0;

	return(@temp);
}

#=========================================================================
# ľʬλ
#
# ƤӽФ˥åȤѿ
# tm ........ ׻оݤȤʤʥꥦ
# nibun ..... ͤǼΥݥ󥿡
#  .... ʬλλβФϤ
# ͤϤäȵˤʤޤ䡣
#=========================================================================
sub before_nibun
{
	local($tm) = @_;
	local(@nibun,$tm1,$tm2,$t,$rm_sun0,$rm_sun,$delta_t1,$delta_t2,$delta_rm);

#-----------------------------------------------------------------------
#ʬ򤹤
#-----------------------------------------------------------------------
	$tm1 = int( $tm );
	$tm2 = $tm - $tm1;

#-----------------------------------------------------------------------
# JST ==> DT =0.0sec ȲꤷƷ׻
#-----------------------------------------------------------------------
	$tm2-=9.0/24.0;

#-----------------------------------------------------------------------
# ľʬβ sun0 
#-----------------------------------------------------------------------
	$t=($tm2+0.5) / 36525.0;
	$t=$t + ($tm1-2451545.0) / 36525.0;
	$rm_sun=&LONGITUDE_SUN( $t );
	$rm_sun0=90*int($rm_sun/90.0);

#-----------------------------------------------------------------------
# ֤׻ˤäľʬλ׻
# ʸ1.0 secˤʤäǤڤ롣
#-----------------------------------------------------------------------
	for( $delta_t2 = 1.0 ; abs( $delta_t1+$delta_t2 ) > ( 1.0 / 86400.0 ) ; ){

#-----------------------------------------------------------------------
# sun ׻
#-----------------------------------------------------------------------
		$t=($tm2+0.5) / 36525.0;
		$t=$t + ($tm1-2451545.0) / 36525.0;
		$rm_sun=&LONGITUDE_SUN( $t );

#-----------------------------------------------------------------------
# к ˡsun ݦsun0
#-----------------------------------------------------------------------
		$delta_rm = $rm_sun - $rm_sun0 ;

#-----------------------------------------------------------------------
# ˤΰϰϡʡ180ˤæˤϡԤ
#-----------------------------------------------------------------------
		if( $delta_rm > 180.0 ){
			$delta_rm-=360.0;
		}elsif( $delta_rm < -180.0){
			$delta_rm+=360.0;
		}

#-----------------------------------------------------------------------
#  t
# delta_t = delta_rm * 365.2 / 360.0;
#-----------------------------------------------------------------------
		$delta_t1 = int($delta_rm * 365.2 / 360.0);
		$delta_t2 = $delta_rm * 365.2 / 360.0;
		$delta_t2 -= $delta_t1;

#-----------------------------------------------------------------------
# 
# tm -= delta_t;
#-----------------------------------------------------------------------
		$tm1 = $tm1 - $delta_t1;
		$tm2 = $tm2 - $delta_t2;
		if($tm2 < 0){
			$tm2+=1.0;$tm1-=1.0;
		}

	}

#-----------------------------------------------------------------------
# ͤκ
# nibun[0,0]:ΤȡDT ==> JST ѴԤͤȤ
# =0.0sec ȲꤷƷ׻
# nibun[0,1]:
#-----------------------------------------------------------------------
	$nibun[0] = $tm2+9.0/24.0;
	$nibun[0] += $tm1;
	$nibun[1] = $rm_sun0;

	return(@nibun);

}

#=========================================================================
# η׻
# Ϳ줿ľκλJSTˤ
#
# ƤӽФ˥åȤѿ
# tm ........ ׻оݤȤʤʥꥦ
#  .... λ
#
#  ͤȤꥦɽʬäξɽ
#
#=========================================================================
sub calc_saku
{
	local($tm) = @_;
	local($lc,$t,$tm1,$tm2,$rm_sun,$rm_moon,$delta_rm,$delta_t1,$delta_t2);

#-----------------------------------------------------------------------
# 롼ץ󥿤Υå
#-----------------------------------------------------------------------
	$lc=1;

#-----------------------------------------------------------------------
#ʬ򤹤
#-----------------------------------------------------------------------
	$tm1 = int( $tm );
	$tm2 = $tm - $tm1;

#-----------------------------------------------------------------------
# JST ==> DT =0.0sec ȲꤷƷ׻
#-----------------------------------------------------------------------
	$tm2-=9.0/24.0;

#-----------------------------------------------------------------------
# ֤׻ˤäƺλ׻
# ʸ1.0 secˤʤäǤڤ롣
#-----------------------------------------------------------------------
	for( $delta_t2 = 1.0 ; abs( $delta_t1+$delta_t2 ) > ( 1.0 / 86400.0 ) ; $lc++){

#-----------------------------------------------------------------------
# ۤβЦsun ,βЦmoon ׻
# t = (tm - 2451548.0 + 0.5)/36525.0;
#-----------------------------------------------------------------------
		$t=($tm2+0.5) / 36525.0;
		$t=$t + ($tm1-2451545.0) / 36525.0;
		$rm_sun=&LONGITUDE_SUN( $t );
		$rm_moon=&LONGITUDE_MOON( $t );

#-----------------------------------------------------------------------
# ۤβк
# ˡmoonݦsun
#-----------------------------------------------------------------------
		$delta_rm = $rm_moon - $rm_sun ;

#-----------------------------------------------------------------------
# 롼פΣܡlc=1ˤ delta_rm < 0.0 ξˤϰϰϤ
# 褦
#-----------------------------------------------------------------------
		if( $lc==1 && $delta_rm < 0.0 ){
			$delta_rm = &NORMALIZATION_ANGLE( $delta_rm );
		}
#-----------------------------------------------------------------------
#   ʬζ᤯Ǻ󤬤0 sun 20ˤǡβЦmoon300 
#   ˤϡˡ 360.0   ȷ׻
#-----------------------------------------------------------------------
		elsif( $rm_sun >= 0 && $rm_sun <= 20 && $rm_moon >= 300 ){
			$delta_rm = &NORMALIZATION_ANGLE( $delta_rm );
			$delta_rm = 360.0 - $delta_rm;
		}
#-----------------------------------------------------------------------
# ˤΰϰϡʡ40ˤæˤϡԤ
#-----------------------------------------------------------------------
		elsif( abs( $delta_rm ) > 40.0 ) {
			$delta_rm = &NORMALIZATION_ANGLE( $delta_rm );
		}

#-----------------------------------------------------------------------
#  t
# delta_t = delta_rm * 29.530589 / 360.0;
#-----------------------------------------------------------------------
		$delta_t1 = int($delta_rm * 29.530589 / 360.0);
		$delta_t2 = $delta_rm * 29.530589 / 360.0;
		$delta_t2 -= $delta_t1;

#-----------------------------------------------------------------------
# 
# tm -= delta_t;
#-----------------------------------------------------------------------
		$tm1 = $tm1 - $delta_t1;
		$tm2 = $tm2 - $delta_t2;
		if($tm2 < 0.0){
			$tm2+=1.0;$tm1-=1.0;
		}

#-----------------------------------------------------------------------
# 롼ײ15ˤʤä顢 tm  tm-26 Ȥ롣
#-----------------------------------------------------------------------
		if($lc == 15 && abs( $delta_t1+$delta_t2 ) > ( 1.0 / 86400.0 ) ){
			$tm1 = int( $tm-26 );
			$tm2 = 0;
		}

#-----------------------------------------------------------------------
# ͤˤؤ餺ư³ˤϽͤȤ
# ֤ƶŪ˥롼פȴФư۾ｪλ롣
#-----------------------------------------------------------------------
		elsif( $lc > 30 && abs( $delta_t1+$delta_t2 ) > ( 1.0 / 86400.0 ) ){
			$tm1=$tm;$tm2=0;
			last;
		}
	}

#-----------------------------------------------------------------------
# ΤȡDT ==> JST ѴԤͤȤ
# =0.0sec ȲꤷƷ׻
#-----------------------------------------------------------------------

	return($tm2+$tm1+9.0/24.0);
}

#=========================================================================
#  ٤ԤʤϰϤ ȡ㣳 ˤ롣
#=========================================================================
sub NORMALIZATION_ANGLE
{
	local($angle) = @_;
	local($angle1,$angle2);

	if( $angle < 0.0 ){
		$angle1 = -$angle;
		$angle2 = int( $angle1 / 360.0 );
		$angle1 -= 360.0 * $angle2;
		$angle1 = 360.0 - $angle1;
	}else{
		$angle1 = int( $angle / 360.0 );
		$angle1 = $angle - 360.0 * $angle1;
	}

	return($angle1);
}

#=========================================================================
# ۤβ sun ׻
#=========================================================================
sub LONGITUDE_SUN
{
	local($t) = @_;
	local($th,$ang);

#-----------------------------------------------------------------------
# ưη׻
#-----------------------------------------------------------------------
	$ang = &NORMALIZATION_ANGLE(  31557.0 * $t + 161.0 );
	$th =       .0004 * cos( $k*$ang );
	$ang = &NORMALIZATION_ANGLE(  29930.0 * $t +  48.0 );
	$th = $th +  .0004 * cos( $k*$ang );
	$ang = &NORMALIZATION_ANGLE(   2281.0 * $t + 221.0 );
	$th = $th +  .0005 * cos( $k*$ang );
	$ang = &NORMALIZATION_ANGLE(    155.0 * $t + 118.0 );
	$th = $th +  .0005 * cos( $k*$ang );
	$ang = &NORMALIZATION_ANGLE(  33718.0 * $t + 316.0 );
	$th = $th +  .0006 * cos( $k*$ang );
	$ang = &NORMALIZATION_ANGLE(   9038.0 * $t +  64.0 );
	$th = $th +  .0007 * cos( $k*$ang );
	$ang = &NORMALIZATION_ANGLE(   3035.0 * $t + 110.0 );
	$th = $th +  .0007 * cos( $k*$ang );
	$ang = &NORMALIZATION_ANGLE(  65929.0 * $t +  45.0 );
	$th = $th +  .0007 * cos( $k*$ang );
	$ang = &NORMALIZATION_ANGLE(  22519.0 * $t + 352.0 );
	$th = $th +  .0013 * cos( $k*$ang );
	$ang = &NORMALIZATION_ANGLE(  45038.0 * $t + 254.0 );
	$th = $th +  .0015 * cos( $k*$ang );
	$ang = &NORMALIZATION_ANGLE( 445267.0 * $t + 208.0 );
	$th = $th +  .0018 * cos( $k*$ang );
	$ang = &NORMALIZATION_ANGLE(     19.0 * $t + 159.0 );
	$th = $th +  .0018 * cos( $k*$ang );
	$ang = &NORMALIZATION_ANGLE(  32964.0 * $t + 158.0 );
	$th = $th +  .0020 * cos( $k*$ang );
	$ang = &NORMALIZATION_ANGLE(  71998.1 * $t + 265.1 );
	$th = $th +  .0200 * cos( $k*$ang );
	$ang = &NORMALIZATION_ANGLE(  35999.05 * $t + 267.52 );
	$th = $th - 0.0048 * $t * cos( $k*$ang ) ;
	$th = $th + 1.9147     * cos( $k*$ang ) ;

#-----------------------------------------------------------------------
# η׻
#-----------------------------------------------------------------------
	$ang = &NORMALIZATION_ANGLE( 36000.7695 * $t );
	$ang = &NORMALIZATION_ANGLE( $ang + 280.4659 );
	$th  = &NORMALIZATION_ANGLE( $th + $ang );

	return($th);
}

#=========================================================================
# β moon ׻
#=========================================================================
sub LONGITUDE_MOON
{
	local($t) = @_;
	local($th,$ang);

#-----------------------------------------------------------------------
# ưη׻
#-----------------------------------------------------------------------
  $ang = &NORMALIZATION_ANGLE( 2322131.0  * $t + 191.0  );
   $th =      .0003 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(    4067.0  * $t +  70.0  );
   $th = $th + .0003 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(  549197.0  * $t + 220.0  );
   $th = $th + .0003 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE( 1808933.0  * $t +  58.0  );
   $th = $th + .0003 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(  349472.0  * $t + 337.0  );
   $th = $th + .0003 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(  381404.0  * $t + 354.0  );
   $th = $th + .0003 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(  958465.0  * $t + 340.0  );
   $th = $th + .0003 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(   12006.0  * $t + 187.0  );
   $th = $th + .0004 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(   39871.0  * $t + 223.0  );
   $th = $th + .0004 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(  509131.0  * $t + 242.0  );
   $th = $th + .0005 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE( 1745069.0  * $t +  24.0  );
   $th = $th + .0005 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE( 1908795.0  * $t +  90.0  );
   $th = $th + .0005 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE( 2258267.0  * $t + 156.0  );
   $th = $th + .0006 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(  111869.0  * $t +  38.0  );
   $th = $th + .0006 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(   27864.0  * $t + 127.0  );
   $th = $th + .0007 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(  485333.0  * $t + 186.0  );
   $th = $th + .0007 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(  405201.0  * $t +  50.0  );
   $th = $th + .0007 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(  790672.0  * $t + 114.0  );
   $th = $th + .0007 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE( 1403732.0  * $t +  98.0  );
   $th = $th + .0008 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(  858602.0  * $t + 129.0  );
   $th = $th + .0009 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE( 1920802.0  * $t + 186.0  );
   $th = $th + .0011 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE( 1267871.0  * $t + 249.0  );
   $th = $th + .0012 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE( 1856938.0  * $t + 152.0  );
   $th = $th + .0016 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(  401329.0  * $t + 274.0  );
   $th = $th + .0018 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(  341337.0  * $t +  16.0  );
   $th = $th + .0021 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(   71998.0  * $t +  85.0  );
   $th = $th + .0021 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(  990397.0  * $t + 357.0  );
   $th = $th + .0021 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(  818536.0  * $t + 151.0  );
   $th = $th + .0022 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(  922466.0  * $t + 163.0  );
   $th = $th + .0023 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(   99863.0  * $t + 122.0  );
   $th = $th + .0024 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE( 1379739.0  * $t +  17.0  );
   $th = $th + .0026 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(  918399.0  * $t + 182.0  );
   $th = $th + .0027 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(    1934.0  * $t + 145.0  );
   $th = $th + .0028 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(  541062.0  * $t + 259.0  );
   $th = $th + .0037 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE( 1781068.0  * $t +  21.0  );
   $th = $th + .0038 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(     133.0  * $t +  29.0  );
   $th = $th + .0040 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE( 1844932.0  * $t +  56.0  );
   $th = $th + .0040 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE( 1331734.0  * $t + 283.0  );
   $th = $th + .0040 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(  481266.0  * $t + 205.0  );
   $th = $th + .0050 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(   31932.0  * $t + 107.0  );
   $th = $th + .0052 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(  926533.0  * $t + 323.0  );
   $th = $th + .0068 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(  449334.0  * $t + 188.0  );
   $th = $th + .0079 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(  826671.0  * $t + 111.0  );
   $th = $th + .0085 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE( 1431597.0  * $t + 315.0  );
   $th = $th + .0100 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE( 1303870.0  * $t + 246.0  );
   $th = $th + .0107 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(  489205.0  * $t + 142.0  );
   $th = $th + .0110 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE( 1443603.0  * $t +  52.0  );
   $th = $th + .0125 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(   75870.0  * $t +  41.0  );
   $th = $th + .0154 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(  513197.9  * $t + 222.5  );
   $th = $th + .0304 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(  445267.1  * $t +  27.9  );
   $th = $th + .0347 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(  441199.8  * $t +  47.4  );
   $th = $th + .0409 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(  854535.2  * $t + 148.2  );
   $th = $th + .0458 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE( 1367733.1  * $t + 280.7  );
   $th = $th + .0533 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(  377336.3  * $t +  13.2  );
   $th = $th + .0571 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(   63863.5  * $t + 124.2  );
   $th = $th + .0588 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(  966404.0  * $t + 276.5  );
   $th = $th + .1144 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(   35999.05 * $t +  87.53 );
   $th = $th + .1851 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(  954397.74 * $t + 179.93 );
   $th = $th + .2136 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(  890534.22 * $t + 145.7  );
   $th = $th + .6583 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE(  413335.35 * $t +  10.74 );
   $th = $th + 1.2740 * cos( $k*$ang );
  $ang = &NORMALIZATION_ANGLE( 477198.868 * $t + 44.963 ); 
   $th = $th + 6.2888 * cos( $k*$ang );

#-----------------------------------------------------------------------
# η׻
#-----------------------------------------------------------------------
  $ang = &NORMALIZATION_ANGLE(  481267.8809 * $t );
  $ang = &NORMALIZATION_ANGLE(  $ang + 218.3162 );
  $th  = &NORMALIZATION_ANGLE(  $th  +  $ang );

  return($th);
}

#=========================================================================
# ǯʬáˤꥦJDˤ׻
#
#  δؿǤϡ쥴ꥪˡˤǯΤǤ롣
#    ʥꥦˡˤǯˤϻѤǤʤ
#=========================================================================
sub YMDT2JD
{
	local($year,$month,$day,$hour,$min,$sec) = @_;
	local($jd,$t);

	if( $month < 3.0 ){
		$year -= 1.0;
		$month += 12.0;
	}

	$jd  = int( 365.25 * $year );
	$jd += int( $year / 400.0 );
	$jd -= int( $year / 100.0 );
	$jd += int( 30.59 * ( $month-2.0 ) );
	$jd += 1721088;
	$jd += $day;

	$t  = $sec / 3600.0;
	$t += $min /60.0;
	$t += $hour;
	$t  = $t / 24.0;

	$jd += $t;

	return( $jd );

}

#=========================================================================
# ꥦJDˤǯʬáˤ׻
#
# ͤTIME[]
# TIME[0] ... ǯ  TIME[1] ...   TIME[2] ... 
# TIME[3] ...   TIME[4] ... ʬ  TIME[5] ... 
#
#  δؿǵ᤿ǯϡ쥴ꥪˡˤäɽƤ롣
#
#=========================================================================
sub JD2YMDT
{

	local($JD) = @_;
	local(@TIME,$x0,$x1,$x2,$x3,$x4,$x5,$x6,$tm);

	$x0 = int( $JD+68570.0);
	$x1 = int( $x0/36524.25 );
	$x2 = $x0 - int( 36524.25*$x1 + 0.75 );
	$x3 = int( ( $x2+1 )/365.2425 );
	$x4 = $x2 - int( 365.25*$x3 )+31.0;
	$x5 = int( int($x4) / 30.59 );
	$x6 = int( int($x5) / 11.0 );

	$TIME[2] = $x4 - int( 30.59*$x5 );
	$TIME[1] = $x5 - 12*$x6 + 2;
	$TIME[0] = 100*( $x1-49 ) + $x3 + $x6;

# 230
	if($TIME[1]==2 && $TIME[2] > 28){
		if($TIME[0] % 100 == 0 && $TIME[0] % 400 == 0){
			$TIME[2]=29;
		}elsif($TIME[0] % 4 ==0){
			$TIME[2]=29;
		}else{
			$TIME[2]=28;
		}
	}

	$tm=86400.0*( $JD - int( $JD ) );
	$TIME[3] = int( $tm/3600.0 );
	$TIME[4] = int( ($tm - 3600.0*$TIME[3])/60.0 );
	$TIME[5] = int( $tm - 3600.0*$TIME[3] - 60*$TIME[4] );

	return(@TIME);
}

#=========================================================================
# ᵤɤĴ٤
# 
#  .... ׻оݤȤʤǯ$year $mon $day
#
#  .... ᵤ̾
#             changed none : -1 / 0-23 allow
#=========================================================================
sub check_24sekki
{
	local($year,$mon,$day) = @_;
	local($tm1,$tm2,$t,$rm_sun_today,$rm_sun_today0,$rm_sun_tommorow,$rm_sun_tommorow0);

#-----------------------------------------------------------------------
# ᵤ
#-----------------------------------------------------------------------

	$tm = &YMDT2JD($year,$mon,$day,0,0,0);

#-----------------------------------------------------------------------
#ʬ򤹤
#-----------------------------------------------------------------------
	$tm1 = int( $tm );
	$tm2 = $tm - $tm1;
	$tm2-=9.0/24.0;
	$t=($tm2+0.5) / 36525.0;
	$t=$t + ($tm1-2451545.0) / 36525.0;

	#ۤβ
	$rm_sun_today = &LONGITUDE_SUN( $t );

	$tm++;
	$tm1 = int($tm);
	$tm2 = $tm - $tm1;
	$tm2-=9.0/24.0;
	$t=($tm2+0.5) / 36525.0;
	$t=$t + ($tm1-2451545.0) / 36525.0;

	#ۤβ
	$rm_sun_tommorow = &LONGITUDE_SUN($t);

	#
	$rm_sun_today0   = 15.0 * int($rm_sun_today / 15.0);
	$rm_sun_tommorow0 = 15.0 * int($rm_sun_tommorow / 15.0);

	if($rm_sun_today0 != $rm_sun_tommorow0){
		return($rm_sun_tommorow0 / 15);
	}else{
		return(-1);
	}
}

1;
__END__
