#!/usr/bin/perl
BEGIN {
	push @INC, 'lib';
	unshift @INC, 'lib';
}

use CGI qw(:standard);
use CGI::Carp qw(fatalsToBrowser);

require "pyukiwiki.ini.cgi";
require $::setup_file if (-r $::setup_file);	# for feature
require "plugin/counter.inc.pl";
require "plugin/playvideo.inc.pl";
$::counter_ext = '.count';
$::info_dir="./info";
use Nana::Cache;
use Jcode;
use Image::ExifTool;
#use LWP::UserAgent;

$::zip_cmds=$::playvideo_plugin_zipcmds;
$::zip_opts=$::playvideo_plugin_zipflags;
$::zip_tmp=$::playvideo_plugin_ziptmp;

&main;

sub main {
	$query=new CGI;

	foreach my $i (0x00 .. 0xFF) {
		$::_urlescape{chr($i)} = sprintf('%%%02x', $i);
		$::_dbmname_encode{chr($i)} = sprintf('%02X', $i);
	}

	$ENV{PATH_INFO}=~s/^\///g;
	$file=$ENV{PATH_INFO};
	$file=~s/\..*//g;
	$ext=$ENV{PATH_INFO};
	$ext=~s/.*\.//g;
	$wmv="wmv";
	$flv="flv";

	$videopath=$::playvideo_plugin_videopath;
	$videourl=$::playvideo_plugin_videourl;

	my $exifTool = new Image::ExifTool;
	my $info = $exifTool->ImageInfo("$videopath/$file.$wmv");

	$title=&Jcode::convert($$info{Title}, 'sjis', 'utf8');
	$author=&Jcode::convert($$info{Author}, 'sjis', 'utf8');
	$copyright=&Jcode::convert($$info{Copyright}, 'sjis', 'utf8');

	if($ext eq "asx" || $ext eq "wmx" || $ext eq "wvx") {
		&plugin_counter_do("playvideo_$file","w");
		print <<EOM;
Content-Type: video/x-ms-wvx

<asx version="3.0">
<entry>
<title>$$info{Title}</title>
<author>$$info{Author}</author>
<copyright>$$info{Copyright}</copyright>
<ref href="$videourl/$file.$wmv" />
</entry>
</asx>
EOM
	} elsif($ext eq "zip" && $::playvideo_plugin_usedownload eq 1) {
		&plugin_counter_do("playvideo_$file","w");
		foreach $cmd (split(/\n/,$::zip_cmds)) {
			if (-x $cmd) {
				$fname="$zip_tmp/$file.$wmv-$ENV{REMOTE_ADDR}.zip";
				# ʰץå
				do {
					sleep 1;
				} if (-r $fname);

				chdir($videopath);
				if(open(PIPE,"$cmd $zip_opts $fname $file.$wmv |")) {
					@TMP=<PIPE>;
					close(PIPE);
					$size = -s $fname;
					if(open(R, $fname)) {
						my $downloadfile="$file.zip";
						if($::playvideo_plugin_downloadfilename_inwmv) {
							my $in_author;
							
							if($::playvideo_plugin_downloadfilename_inwmv_withauthor) {
								$in_author=" ($author)" if($author ne '');
							}
							if($title ne '') {
								$downloadfile="$title$in_author.zip";
							}
						}
						$::defaultcode='sjis';
						# Windows MSIE & Opera & Chrome

						my $charset;
						if($downloadfile=~/[\x81-\xfe]/) {
							if($ENV{HTTP_USER_AGENT} =~/Chrome/) {
								$downloadfile=&code_convert(\$downloadfile,"utf8",$::defaultcode);
								$downloadfile=qq(filename="$downloadfile");
					#			$downloadfile="filename*=ISO-2022-JP" . qq{''} . &encode($downloadfile) . qq{"};
								$downloadfile=~s/%2e/\./g;
								$charset="utf-8";
					#		} elsif($ENV{HTTP_USER_AGENT}=~/Opera/) {
					#			$downloadfile=&code_convert(\$downloadfile,"utf8",$::defaultcode);
					#			$downloadfile=qq(filename="$downloadfile");
					#			$charset="utf-8";
							} elsif($ENV{HTTP_USER_AGENT}=~/MSIE/) {
								$downloadfile=qq{filename="} . &code_convert(\$downloadfile,"sjis") . qq{"};
								$charset="Shift-JIS";
							} else {
					#			$downloadfile=&code_convert(\$downloadfile,$::kanjicode);
								$downloadfile=&code_convert(\$downloadfile,"utf8");
								$downloadfile=qq(filename="$downloadfile");
					#			$downloadfile=qq{filename="} . $::charset . qq{''} . &encode($downloadfile) . qq{"};
					#			$downloadfile=~s/%2e/\./g;
								$charset="utf-8";
							}
						} else {
							$downloadfile=qq(filename="$downloadfile");
						}

						print $query->header(
							-type=>"application/zip; charset=$charset",
							-Content_disposition=>"attachment; $downloadfile",
							-Content_length=>$size,
							-expires=>"now",
							-P3P=>""
						);


						binmode	R;						binmode STDOUT;
						print <R>;
						close(R);
						unlink($fname);
						exit;
					} else {
						unlink($fname);
						&err("Can't create zip file. sorry.");
						exit;
					}
				} else {
					unlink($fname);
					&err("Can't create pipe. sorry.");#
					exit;
				}
				exit;
			}
		}
		&err("Not found zip command.");
		exit;
	} elsif($ext eq "flv") {
		&plugin_counter_do("playvideo_$file","w");
		$title=&Jcode::convert($$info{Title}, 'euc');
		$author=&Jcode::convert($$info{Author}, 'euc');
		$copyright=&Jcode::convert($$info{Copyright}, 'euc');
		$title=$file if($title eq '');
		$width=$$info{ImageWidth} . "px";
		$height=$$info{ImageHeight}+20;
		$height.="px";
		&getbasehref if($::skin_url!~/^https?\:\/\//);
		my $iecompatible;
		if(-r "$::explugin_dir/iecompatiblehack.inc.cgi") {
			require "$::explugin_dir/iecompatiblehack.inc.cgi";
			my %ret=&plugin_iecompatiblehack_init;
			if($ret{'http_header'} ne '') {
				$iecompatible=$ret{'http_header'};
				$iecompatible=~s/\n//g;
				$iecompatible="\n$iecompatible";
			}
		}
		print <<EOM;
Content-Type: text/html$iecompatible

<?xml version="1.0" encoding="EUC-JP" ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja">
<head>
<meta http-equiv="Content-Script-Type" content="text/javascript" />
<title>$title</title>
<script type="text/javascript" src="$basehref$::skin_url/flowplayer-3.2.6.min.js"></script>
<style type="text/css"><!--
*,img{
	background-color: #000000;
	color:#ffffff;
	margin: 0px;
	padding: 0px;
}
//--></style>
<title>$title</title>
</head><body>
<div id="page">
<div style="width:$width;height:$height" id="player"></div>
<script><!--
 window.focus();
	flowplayer("player", "$basehref$::skin_url/flowplayer-3.2.7.swf",
		{
			clip: {
				url: '$videourl/$file.$flv',
				autoPlay: true,
				autoBuffering: true,
				scaling: 'fit'
			},
			canvas: {
				backgroundColor: '#000000',
				backgroundGradient: 'none'
		},
		plugins: {
			controls: {
				height: 24,
				play:true,
				stop:true,
				volume:true,
				mute:true,
				time:true,
				fullscreen:true,
				volumeSliderColor: '#000000',
				tooltipColor: '#5F747C',
				progressColor: '#112233',
				bufferColor: '#445566',
				buttonColor: '#5F747C',
				sliderColor: '#000000',
				backgroundGradient: 'high',
				durationColor: '#ffffff',
				backgroundColor: '#222222',
				progressGradient: 'medium',
				borderRadius: '0',
				buttonOverColor: '#728B94',
				bufferGradient: 'none',
				timeBgColor: '#555555',
				sliderGradient: 'none',
				volumeSliderGradient: 'none',
				tooltipTextColor: '#ffffff',
				timeColor: '#01DAFF'
			 }
		}
	}
);
//--></script>
EOM
		if($author ne '' && $copyright ne '') {
			print <<EOM;
<table width="100%"><tr><td>ԡ$author&nbsp;$copyright</td>
<td align="right"><form action="#"><input type="button" value="Ĥ" onclick="self.close();"></form></td></tr></table>
EOM
		} elsif($author ne '' && $copyright eq '') {
			print <<EOM;
<table width="100%"><tr><td>ԡ$author</td>
<td align="right"><form action="#"><input type="button" value="Ĥ" onclick="self.close();"></form></td></tr></table>
EOM
		} elsif($author eq '' && $copyright ne '') {
			print <<EOM;
<table width="100%"><tr><td>$copyright</td>
<td align="right"><form action="#"><input type="button" value="Ĥ" onclick="self.close();"></form></td></tr></table>
EOM
		} else {
			print <<EOM;
<p align="right"><form action="#"><input type="button" value="Ĥ" onclick="self.close();"></form></p>
EOM
		}
		print <<EOM;
</div></body></html>
EOM
	} elsif($ext=~/^sm(\d+)/) {
		&plugin_counter_do("playvideo_$file","w");
		print <<EOM;
Location: http://www.nicovideo.jp/watch/$ext

EOM
	} else {
		&plugin_counter_do("playvideo_$file","w");
		print <<EOM;
Location: http://www.youtube.com/watch?v=$ext

EOM
	}
}

sub is_exist_page {
	return 1;
}

sub encode {
	my ($encoded) = @_;
	$encoded =~ s/(\W)/$::_urlescape{$1}/g;
	return $encoded;
}

sub dbmname {
	my ($name) = @_;
	$name =~ s/(.)/$::_dbmname_encode{$1}/g;
	return $name;
}

my $_tz='';
sub gettz {
	if($_tz eq '') {
		$_tz=(localtime(time))[2]+(localtime(time))[3]*24+(localtime(time))[4]*24
			+(localtime(time))[5]*24-(gmtime(time))[2]-(gmtime(time))[3]*24
			-(gmtime(time))[4]*24-(gmtime(time))[5]*24;
	}
	return $_tz;
}

sub code_convert {
	my ($contentref, $kanjicode, $icode) = @_;
	if($$contentref ne '') {
		if ($::lang eq 'ja') {
			&Jcode::convert($contentref, $kanjicode, $icode);
		}
	}
	return $$contentref;
}

sub err {
	($msg)=@_;
	print <<EOM;
Content-type: text/plain

$msg
EOM
}

sub getbasehref {
	# Thanks moriyoshi koizumi.
	return if($::basehref ne '');
	$::basehost = "$ENV{'HTTP_HOST'}";

	# SSLξ
	if (($ENV{'https'} =~ /on/i) || ($ENV{'SERVER_PORT'} eq '443')) {
		$::basehost = 'https://' . $::basehost;
	# httpξ
	} else {
		$::basehost = 'http://' . $::basehost;
		# Special Thanks to gyo
		$::basehost .= ":$ENV{'SERVER_PORT'}"
			if ($ENV{'SERVER_PORT'} ne '80' && $::basehost !~ /:\d/);
	}

	# URL
	my $uri=$ENV{REQUEST_URI};
	$uri=~s/v\.cgi.*//g;
	$::basehref=$::basehost . $uri;
	$::basepath=$uri;
	$::basepath=~s/\/[^\/]*$//g;
	$::basepath="/" if($::basepath eq '');
	$::script=$uri if($::script eq '');
}
