######################################################################
# clipcopy.inc.pl - This is PyukiWiki, yet another Wiki clone.
# $Id: clipcopy.pl,v 1.2 2011/09/01 12:24:25 papu Exp $
#
# "clipcopy plugin" version 1.1 $$
# Author: Nanami http://nanakochi.daiba.cx/
# Copyright (C) 2004-2011 by Nekyo.
# http://nekyo.qp.land.to/
# Copyright (C) 2005-2011 PyukiWiki Developers Team
# http://pyukiwiki.sourceforge.jp/
# Based on YukiWiki http://www.hyuki.com/yukiwiki/
# Powerd by PukiWiki http://pukiwiki.sourceforge.jp/
# License: GPL2 and/or Artistic or each later version
#
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
# Return:LF Code=UTF-8 1TAB=4Spaces
######################################################################
# clipcopy プラグイン
# IE専用のプラグインで、右クリックしてショートカットをコピーするものを
# ワンクリックでできるようにするものです。
# IE以外では、何も出力しません。
#
# usage : &clipcopy(url, text);
######################################################################

use strict;
package clipcopy;

sub plugin_inline {
	my ($arg)=@_;
	my ($linkurl,$text,$copiedtext)=split(/,/,$arg);

	my $body;

	$text=&javascriptspecialchars($text);
	$linkurl=&javascriptspecialchars($linkurl);

	if($ENV{HTTP_USER_AGENT}=~/MSIE/ && $ENV{HTTP_USER_AGENT}!~/Opera/) {
#		return " " if($linkurl!~/$::isurl/);
		if($copiedtext eq '') {
			$copiedtext="$linkurl copied to clipboard";
		} else {
			$copiedtext=&javascriptspecialchars($copiedtext);
		}
		$body=<<EOM;
(<a href="javascript:void(0);" title="$linkurl" onclick="clipboardData.setData('Text', '$linkurl');alert('$copiedtext')">$text</a>)
EOM
		return $body;
	}
	return " ";
}

sub javascriptspecialchars {
	my ($s) = @_;
	$s =~ s|\r\n|\n|g;
	$s =~ s|\&|&amp;|g;
	$s =~ s|<|&lt;|g;
	$s =~ s|>|&gt;|g if($s=~/</);
	$s =~ s|"|&quot;|g;
	$s =~ s|'|&apos;|g;
	return $s;
}

sub plugin_clipcopy_pyukiver {
	my ($v,$s)=split(/\-/,$::version);
	$v=~s/\.//g;
	return 1 if($v+0>=16);
	return 0;
}

1;
__END__

=head1 NAME

clipcopy.pl - PyukiWiki / YukiWiki Plugin

=head1 SYNOPSIS

 &clipcopy(linkurl, text, [copiedtext]);
 &clipcopy(http://pyukiwiki.sourceforge.jp?rss
  ,RSS Link Copy,http://pyukiwiki.sourceforge.jp?rss Copied to clipboard);

=head1 DESCRIPTION

Specified URL is copied to a clipboard. Any character strings other than URL cannot be specified.

Only Internet Explorer.
Nothing is returned in the other browser.

This plugin is compatible with YukiWiki.

=head1 SEE ALSO

=over 4

=item PyukiWiki/Plugin/Nanami/clipcopy

L<http://pyukiwiki.sourceforge.jp/PyukiWiki/Plugin/Nanami/clipcopy/>

=item PyukiWiki CVS

L<http://sourceforge.jp/cvs/view/pyukiwiki/PyukiWiki-Devel/plugin/clipcopy.inc.pl?view=log>

=back

=head1 AUTHOR

=over 4

=item Nanami

L<http://nanakochi.daiba.cx/> etc...

=item PyukiWiki Developers Team

L<http://pyukiwiki.sourceforge.jp/>

=back

=head1 LICENSE

Copyright (C) 2005-2011 by Nanami.

Copyright (C) 2005-2011 by PyukiWiki Developers Team

License is GNU GENERAL PUBLIC LICENSE 2 and/or Artistic 1 or each later version.

This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=cut
