######################################################################
# star.pl - This is PyukiWiki, yet another Wiki clone.
# $Id: star.pl,v 1.37 2012/08/16 01:24:29 papu Exp $
# Build on 2012-08-16 02:02:24
#
# "PyukiWiki" ver 0.2.1-beta1 $$
# Author: Nanami http://nanakochi.daiba.cx/
# Copyright (C) 2004-2007 Nekyo
# Copyright (C) 2005-2012 PyukiWiki Developers Team
# http://pyukiwiki.info/
# Based on YukiWiki http://www.hyuki.com/yukiwiki/
# Powerd by PukiWiki http://pukiwiki.sfjp.jp/
# License: GPL3 and/or Artistic or each later version
#
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
# Return:CRLF Code=EUC-JP 1TAB=4Spaces
######################################################################

use strict;

$STAR::STRING=qq(<img src="$::image_url/vps/good.gif" />)
	if(!defined($STAR::STRING));
$STAR::STRING1=qq(<span class="star1">$STAR::STRING</span>)
	if(!defined($STAR::STRING1));
$STAR::STRING2=""
	if(!defined($STAR::STRING2));

package star;

sub plugin_inline {
	my @args = split(/,/, shift);
	my $max=5;
	my $now=0;

	if(@args >= 2) {
		if($args[1]+0 > 0) {
			$max=$args[1];
		}
	}
	if($args[0]+0 > 0) {
		$now=$args[0];
	}

	my $out;
	for (my $i=1; $i <= $max; $i++) {
		if($i <= $now) {
			$out.=$STAR::STRING1;
		} else {
			$out.=$STAR::STRING2;
		}
	}
	return $out;
}

1;
__END__

=head1 NAME

star.pl - PyukiWiki / YukiWiki Plugin

=head1 SYNOPSIS

 &star(4);
 &star(3,10);

=head1 DESCRIPTION

Display rank of star.

This plugin is compatible with YukiWiki.

=back

=head1 SEE ALSO

=over 4

=item PyukiWiki/Plugin/Standard/star

L<http://pyukiwiki.info/PyukiWiki/Plugin/Standard/star/>

=item PyukiWiki CVS

L<http://sfjp.jp/cvs/view/pyukiwiki/PyukiWiki-Devel/plugin/star.pl?view=log>

L<http://sfjp.jp/cvs/view/pyukiwiki/PyukiWiki-Devel-UTF8/plugin/star.pl?view=log>

L<http://cvs.pyukiwiki.info/cgi-bin/cvsweb.cgi/PyukiWiki-Devel/plugin/star.pl?view=log>

L<http://cvs.pyukiwiki.info/cgi-bin/cvsweb.cgi/PyukiWiki-Devel-UTF8/plugin/star.pl?view=log>

=back

=head1 AUTHOR

=over 4

=item Nanami

L<http://nanakochi.daiba.cx/> etc...

=item PyukiWiki Developers Team

L<http://pyukiwiki.info/>

=back

=head1 LICENSE

Copyright (C) 2005-2012 by Nanami.

Copyright (C) 2005-2012 by PyukiWiki Developers Team

License is GNU GENERAL PUBLIC LICENSE 3 and/or Artistic 1 or each later version.

This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=cut
