######################################################################
# RemoteHost.pm - This is PyukiWiki, yet another Wiki clone.
# $Id: RemoteHost.pm,v 1.44 2012/08/16 01:24:28 papu Exp $
# Build on 2012-08-16 02:01:52
#
# "Nana::RemoteHost" ver 0.1 $$
# Author: Nanami
# http://nanakochi.daiba.cx/
# Copyright (C) 2004-2007 Nekyo
# Copyright (C) 2005-2012 PyukiWiki Developers Team
# http://pyukiwiki.info/
# Based on YukiWiki http://www.hyuki.com/yukiwiki/
# Powerd by PukiWiki http://pukiwiki.sfjp.jp/
# License: GPL3 and/or Artistic or each later version
#
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
# Return:CRLF Code=Shift-JIS 1TAB=4Spaces
######################################################################
package	Nana::RemoteHost;
use 5.005;
use strict;
use vars qw($VERSION);
$VERSION = '0.1';
######################################################################
$Nana::RemoteHost::Execed=0;
sub get {
	return if($Nana::RemoteHost::Execed eq 1);
	$Nana::RemoteHost::Execed=1;
	# from http://www.alib.jp/perl/resolv.html#nocompact	# comment
	# and  http://www2u.biglobe.ne.jp/MAS/perl/waza/dns.html#nocompact	# comment
	if($ENV{REMOTE_HOST} eq '' || $ENV{REMOTE_ADDR} eq $ENV{REMOTE_HOST}) {
		my $addr=$ENV{REMOTE_ADDR};
		my $ipv4addr;
		my $ipv6addr;
		if($addr=~/^(?:::(?:f{4}:)?)?((?:0*(?:2[0-4]\d|25[0-5]|[01]?\d\d|\d)\.){3}0*(?:2[0-4]\d|25[0-5]|[01]?\d\d|\d)|(?:\d+))$/) {
			$ipv4addr=$1;
			$ENV{REMOTE_ADDR}="$ipv4addr";
		} elsif($addr=~/:/) {
			$ipv6addr=$addr;
			$ENV{REMOTE_ADDR}="$ipv6addr";
		} else {
			$ipv4addr=$addr;
			$ENV{REMOTE_ADDR}="$ipv4addr";
		}
		if($ipv4addr ne '') {
			my $host
			 = gethostbyaddr(pack("C4", split(/\./, $ENV{REMOTE_ADDR})), 2);
			if($host eq '') {
				$host=$ENV{REMOTE_ADDR};
			}
			$ENV{REMOTE_HOST}=$host;
		} elsif($ipv6addr ne '') {
			my $funcp = $::functions{"load_module"};
			if(&$funcp("Net::DNS")) {
				# IPV6AhXWJB#nocompact	# comment
				my @address;
				if ($ipv6addr =~ /::/) {
			        my ($adr_a, $adr_b) = split /::/, $ipv6addr;
			        my @adr_a = split /:/, $adr_a;
			        my @adr_b = split /:/, $adr_b;
   					for (scalar @adr_a .. 7 - scalar @adr_b) {
						push @adr_a, 0
					}
					@address = (@adr_a, @adr_b);
				} else {
					@address = split /:/, $ipv6addr;
				}
				$ipv6addr =  (join ":", @address);
				# IPV6AhX#nocompact	# comment
				my $resolver = new Net::DNS::Resolver;
			    my $ans = $resolver->query($ipv6addr, 'PTR', 'IN');
				if($ans) {
			        foreach my $rr ($ans->answer) {
			                next if $rr->type ne "PTR";
			                $ENV{REMOTE_HOST}=$rr->ptrdname;
			        }
				} else {
					$ENV{REMOTE_HOST}="$ipv6addr";
				}
			} else {
				$ENV{REMOTE_HOST}="$ipv6addr";
			}
		}
	}
	# vNVIPAhX𔲂 #nocompact #comment
	my $proxy;
	if($ENV{REMOTE_HOST_ORG} eq '') {
		$ENV{REMOTE_HOST_ORG}=$ENV{REMOTE_HOST};
	} else {
		$ENV{REMOTE_HOST}=$ENV{REMOTE_HOST_ORG};
	}
	if($ENV{HTTP_CLIENT_IP}=~/($::ipv4address_regex)/) {
		$proxy=$1;
	} elsif($ENV{HTTP_CLIENT_IP}=~/($::ipv6address_regex)/) {
		$proxy=$1;
	} elsif($ENV{HTTP_FORWARDED}=~/($::ipv4address_regex)/) {
		$proxy=$1;
	} elsif($ENV{HTTP_FORWARDED}=~/($::ipv6address_regex)/) {
		$proxy=$1;
	} elsif($ENV{HTTP_X_FORWARDED_FOR}=~/($::ipv4address_regex)/) {
		$proxy=$1;
	} elsif($ENV{HTTP_X_FORWARDED_FOR}=~/($::ipv6address_regex)/) {
		$proxy=$1;
	} elsif($ENV{HTTP_VIA}=~/($::ipv4address_regex)/) {
		$proxy=$1;
	} elsif($ENV{HTTP_VIA}=~/($::ipv6address_regex)/) {
		$proxy=$1;
	}
	if($proxy ne '') {
		$ENV{REMOTE_HOST}.= " ($proxy)";
	}
}
__END__
