######################################################################
# multicomment.inc.pl - This is PyukiWiki, yet another Wiki clone.
# $Id: multicomment.inc.pl,v 1.36 2012/08/16 01:24:29 papu Exp $
#
# "PyukiWiki" ver 0.2.1-alpha1-dev2 $$
# Author: Nekyo http://nekyo.qp.land.to/
# Copyright (C) 2004-2012 Nekyo
# http://nekyo.qp.land.to/
# Copyright (C) 2005-2012 PyukiWiki Developers Team
# http://pyukiwiki.info/
# Based on YukiWiki http://www.hyuki.com/yukiwiki/
# Powerd by PukiWiki http://pukiwiki.sfjp.jp/
# License: GPL3 and/or Artistic or each later version
#
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
# Return:LF Code=UTF-8 1TAB=4Spaces
######################################################################
use strict;
# Υեޥå
$multicomment::format = "\x08MSG\x08 -- \x08NAME\x08 \x08NOW\x08"
	if(!defined($multicomment::format));
# ƥȥꥢΥ
$multicomment::cols = 70
	if(!defined($multicomment::cols));
#
# ƥȥꥢιԿ
$multicomment::rows = 5
	if(!defined($multicomment::rows));
#
# ̾URL᡼륢ɥ쥹ƥȥꥢΥ
$multicomment::name_cols = 24
	if(!defined($multicomment::name_cols));
#
# ¾̾ƥȥꥢΥ
$multicomment::text_cols = 60
	if(!defined($multicomment::text_cols));
#
# ̾եޥå
$multicomment::name_format = "\'\'[[\$1>$::resource{profile_page}/\$1]]\'\'"
	if(!defined($multicomment::name_format));
#
# դեޥå (&new ǧǤ뤳)
$multicomment::date_format= "Y-m-d(lL) H:i:s"
	if(!defined($multicomment::date_format));
#
# URLեޥå (&new ǧǤ뤳)
$multicomment::url_format= '[[HOME>$1]]'
	if(!defined($multicomment::url_format));
#
# ᡼եޥå (&new ǧǤ뤳)
$multicomment::mail_format= '[[MAIL>$1]]'
	if(!defined($multicomment::mail_format));
#
#  1: 0:θ
$multicomment::ins = 1
	if(!defined($multicomment::ins));
#
# ߲˰ԥȤ 1: 0:ʤ
$multicomment::comment = 1
	if(!defined($multicomment::comment));
#
# ԤưŪѴ 1: 0:ʤ
$multicomment::auto_br = 1
	if(!defined($multicomment::auto_br));
#
# ̾ʤǽʤ
$multicomment::noname = 1
	if(!defined($multicomment::noname));
######################################################################
$multicomment::no = 0;
my $_no_name = "";
sub plugin_multicomment_action {
	my $name_form;
	my $textarea_form;
	my $url_form;
	my $mail_form;
	foreach(keys %::form) {
		if(/^\_ext\_(name|text|textarea)/) {
			&::spam_filter($::form{$_}, 2, $::chk_multicomment_uri_count, $::chk_multicomment_mail_count);
		}
		if(/^\_ext\_(name|textarea)/) {
			if($::form{$_}=~/^\s*$/) {
				return('msg'=>"$::form{mypage}\t\t$::resource{multicomment_plugin_err}",'body'=>&text_to_html($::database{$::form{mypage}}),'ispage'=>1);
			}
		}
		$::form{$_}=&code_convert(\$::form{$_}, $::defaultcode);
		$name_form=$_ if(/^\_ext\_name\_/);
		$textarea_form=$_ if(/^\_ext\_textarea\_/);
		$url_form=$_ if(/^\_ext\_url\_/);
		$mail_form=$_ if(/^\_ext\_mail\_/);
		if(/^\_ext\_textarea\_/) {
			$::form{$_}=~s/\x0D\x0A|\x0D|\x0A/\n/g;
			$::form{$_}=~s/^(\s|\n)//g while($::form{$_}=~/^(\s|\n)/);
			$::form{$_}=~s/(\s|\n)$//g while($::form{$_}=~/(\s|\n)$/);
			$::form{$_}=~s/\n/\~\n/g if($multicomment::auto_br);
		}
	}
	my ($url, $mail, $myurl, $mymail, $myname);
	my $name = $_no_name;
	if ($::form{$name_form} ne '') {
		$name = $multicomment::name_format;
		$name =~ s/\$1/$::form{$name_form}/g;
		$myname=$::form{$name_form};
	}
	my $msg=$::form{$textarea_form};
	if($::form{$url_form}=~/$::isurl/g && $::form{$url_form} ne "") {
		if($::form{$url_form}=~/$multicomment::ignoreurl/i) {
			return('msg'=>"$::form{mypage}\t\t$::resource{multicomment_plugin_err}",'body'=>&text_to_html($::database{$::form{mypage}}),'ispage'=>1);
		}
		$myurl=$::form{$url_form};
		$url=$multicomment::url_format;
		$url=~ s/\$1/$myurl/g;
	}
	if($::form{$mail_form}=~/$::ismail/g && $::form{$mail_form} ne "") {
		$mymail=$::form{$mail_form};
		$mail=$multicomment::mail_format;
		$mail=~ s/\$1/$mymail/g;
	}
	my $now="&new{@{[&date($multicomment::date_format)]}};";
	my $comment = $multicomment::format;
	$comment =~ s/\x08MSG\x08/$msg/;
	$comment =~ s/\x08NAME\x08/$name $url $mail/;
	$comment =~ s/\x08NOW\x08/$now/;
	$comment = "-" . $comment;
	if($::setting_cookie{savename}+0>0 && $myname ne '') {
		eval {
			&plugin_setting_savename($myname, $myurl, $mymail);
		};
	}
	my $postdata = '';
	my @postdata_old = split(/\r?\n/, $::database{$::form{'mypage'}});
	my $_multicomment_no = 0;
	foreach (@postdata_old) {
		$postdata .= $_ . "\n" if (!$multicomment::ins);
		if (/^#multicomment/ && (++$_multicomment_no == $::form{multicomment_no})) {
			$postdata .= "$comment\n";
		}
		$postdata .= $_ . "\n" if ($multicomment::ins);
	}
	$::form{mymsg} = $postdata;
	$::form{mytouch} = 'on';
	&do_write("FrozenWrite");
	&close_db;
	exit;
}
sub plugin_multicomment_convert {
	my(@args)=split(/,/,&htmlspecialchars(shift));
	return ' '
		if($::writefrozenplugin eq 0 && &get_info($::form{mypage}, $::info_IsFrozen) eq 1);
	$multicomment::no++;
	my $conflictchecker = &get_info($::form{mypage}, $::info_ConflictChecker);
	my $captcha_form;
	eval {
		$captcha_form=&plugin_captcha_form;
	};
	my $form="<table>";
	my $formname=0;
	foreach my $arg(@args) {
		$formname++;
		my($type, $text, $opt)=split(/=/,$arg);
		if($type=~/^(comment)/) {
			$form.=<<EOM;
<input type="hidden" name="_ext\_$type\_$formname" value="$text" />
EOM
		}
		if($type=~/^(label)$/) {
			$form.=<<EOM;
<tr><td colspan="2" class="big">$text</td></tr>
EOM
		}
		if($type=~/^(text|name|url|mail|subject)$/) {
			my $value=$opt;
			$value=$::name_cookie{myname}
				if($type eq "name" && $::name_cookie{myname} ne "");
			$value=$::name_cookie{myurl}
				if($type eq "url" && $::name_cookie{myurl} ne "");
			$value=$::name_cookie{mymail}
				if($type eq "mail" && $::name_cookie{mymail} ne "");
			$form.=<<EOM;
<input type="hidden" name="_ext_hidden_$formname" value="$text" />
<tr><td>$text : </td><td><input type="text" name="_ext\_$type\_$formname" size="@{[$type=~/text/ ? $multicomment::text_cols : $type=~/name|url|mail/ ? $multicomment::name_cols : $multicomment::subject_cols]}" value="$value" /></td></tr>
EOM
		}
		if($type eq "textarea") {
			$form.=<<EOM;
<input type="hidden" name="_ext_hidden_$formname" value="$text" />
<tr><td>$text : </td><td>
<textarea name="_ext_textarea_$formname" rows="$multicomment::rows" cols="$multicomment::cols"></textarea></td></tr>
EOM
		}
	}
	$form.=<<EOM;
<tr><td>&nbsp;</td><td>
$captcha_form
<input type="submit" value="$::resource{multicomment_plugin_btn}" />
<input type="reset" value="$::resource{multicomment_plugin_clear}" />
</td></tr>
</table>
EOM
	return <<"EOD";
<form action="$::script" method="post">
<div>
<input type="hidden" name="multicomment_no" value="$multicomment::no" />
<input type="hidden" name="cmd" value="multicomment" />
<input type="hidden" name="mypage" value="$::form{'mypage'}" />
<input type="hidden" name="myConflictChecker" value="$conflictchecker" />
<input type="hidden" name="mytouch" value="on" />
$form
</div>
</form>
EOD
}
1;
__END__
