######################################################################
# GDBM.pm - This is PyukiWiki, yet another Wiki clone.
# $Id: GDBM.pm,v 1.2 2012/09/11 00:43:00 papu Exp $
# Build on 2012-09-11 08:19:34
#
# "Nana::GDBM" ver 0.1 $$
# Author: Nanami
# http://nanakochi.daiba.cx/
# Copyright (C) 2004-2007 Nekyo
# Copyright (C) 2005-2012 PyukiWiki Developers Team
# http://pyukiwiki.info/
# Based on YukiWiki http://www.hyuki.com/yukiwiki/
# Powerd by PukiWiki http://pukiwiki.sfjp.jp/
# License: GPL3 and/or Artistic or each later version
#
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
# Return:CRLF Code=EUC-JP 1TAB=4Spaces
######################################################################

package Nana::GDBM;
$VERSION="0.1";
use strict;
use Fcntl;
use GDBM_File;

# Constructor
sub new {
	return shift->TIEHASH(@_);
}

# error
sub die {
	$::debug.="GDBM:$_[0]\n";
	return undef;
}

# tying												# comment
sub TIEHASH {
	my ($class, $dbname) = @_;
	my $self = {
		dir => $dbname,
		name => $dbname,
		keys => [],
		db => {},
	};
	if (not -d $self->{dir}) {
		if (!mkdir($self->{dir}, 0777)) {
			return &die("mkdir $self->{dir} fail");
			return undef;
		}
	}

	my $filename="$self->{dir}/$self->{name}.gdbm";
	if(-r $filename) {
		tie %{$self->{db}}, 'GDBM_File' , $filename, O_RDWR, 0666;
	} else {
		tie %{$self->{db}}, 'GDBM_File' , $filename, O_RDWR|O_CREAT, 0666;
	}
	return bless($self, $class);
}

# Store												# comment
sub STORE {
	my ($self, $key, $value) = @_;
	my ($mode, $filename) = &make_filename($self, $key);
	$self->{db}->{$filename}=$value;
	$self->{db}->{"__update__$filename"}=time;
}

# Fetch												# comment
sub FETCH {
	my ($self, $key) = @_;
	return $self->{db}->{$key};
}

# Exists											# comment
sub EXISTS {
	my ($self, $key) = @_;
	return -e($self->{db}->{$key});
}

# Delete											# comment
sub DELETE {
	my ($self, $key) = @_;
	my ($mode, $filename) = &make_filename($self, $key);
	delete $self->{db}->{$filename};
	delete $self->{db}->{"__update__$filename"};
}

sub FIRSTKEY {
	my ($self) = @_;
	@{$self->{keys}} = keys %{$self->{db}};
	my $key=shift @{$self->{keys}};
	my ($mode, $filename) = &make_filename($self, $key);
	return  $filename;
}

sub NEXTKEY {
	my ($self) = @_;
	do {
		my $key=shift @{$self->{keys}};
		my ($mode, $filename) = &make_filename($self, $key);
		return $filename if($mode ne "update");
	} while(1);
}

sub make_filename {
	my ($self, $key) = @_;
	my $mode="";
	if($key=~/^\_\_(.+?)\_\_(.+?)$/) {
		$mode=$1;
		$key=$2;
	}
	return ($mode, $key);
}
1;
