# release file makefile for pyukiwiki
# $Id: build.mk,v 1.404 2012/09/11 00:43:22 papu Exp $

ARCHIVEDIR=./archive
BUILDDIR=./build
TEMP=./temp
RELEASE=./release

SH?=/usr/local/bin/bash
#SH?=/bin/sh
PERL=perl

TAR=tar cvf
#ZIP=zip -9 -r
#GZIP=gzip -9
#BZIP=bzip2 -9
#XZ=xz -9

# vv use this...
GZIP_7Z=7za a -tgzip -mx9 -mpass=10 -mfb=256
BZIP2_7Z=7za a -tbzip2 -mx9 -mpass=10 -md=100m
XZ_7Z=7za a -txz -mx9 -m0=BCJ2 -m1=LZMA:d23
ZIP_7Z=7za a -tzip -mx9 -mpass=10 -mfb=256
7Z_7Z=7za a -t7z -m1=LZMA:d25:fb255 -m2=LZMA:d19 -m3=LZMA:d19 -mb0:1 -mb0s1:2 -mb0s2:3 -mx

#GZIP_JC=gzip -9 >
GZIP_JC=7za a -tgzip -mx9 -si

POD2HTML=pod2html
HTML2TEXT=w3m

PKGNAME=pyukiwiki

######################################################
export ARCHIVEDIR
export BUILDDIR
export TEMP
export RELEASE
export SH
export PERL
export TAR
export ZIP
export GZIP
export BZIP
export XZ
export GZIP_7Z
export BZIP2_7Z
export XZ_7Z
export ZIP_7Z
export 7Z_7Z
export GZIP_JC
export PKGNAME

VERSION= `perl -e 'if(-f "./build/getversion.pl"){ require "./build/getversion.pl" }elsif(-f "../../build/getversion.pl"){ require "../../build/getversion.pl";}'`
export VERSION

all:
	@echo "PyukiWIki ${VERSION} Release Builder"
	@echo "Usage: ${MAKE} [build|builddoc|prof|release|buildrelease|buildreleaseutf8|builddevel|builddevelutf8|buildcompact|buildcompactutf8|pkg|clean|realclean|cvsclean|ftp]"

version:
	@echo "PyukiWIki ${VERSION}"

BUILDMAKER=${BUILDDIR}/makesampleini.pl \
			${BUILDDIR}/Jcode-convert.pl \
			${BUILDDIR}/lang.pl \
			${BUILDDIR}/getversion.pl \
			${BUILDDIR}/build.mk \
			${BUILDDIR}/build.pl \
			${BUILDDIR}/compactmagic.pl \
			${BUILDDIR}/compressfile.pl \
			${BUILDDIR}/text.pl \
			${BUILDDIR}/makeinstaller.sh \
			${BUILDDIR}/installer.sh \
			${BUILDDIR}/installer2.sh \
			${BUILDDIR}/installer_sub.sh \
			${BUILDDIR}/b64decode.pl \
			${BUILDDIR}/base64.pl \
			${BUILDDIR}/class.JavaScriptPacker.php \
			${BUILDDIR}/example-file.php \
			${BUILDDIR}/makewikisub.pl \
			${BUILDDIR}/list_hiragana.pl \
			${BUILDDIR}/list_hiragana.txt \
			Makefile

#BUILDMAKER=

BUILDFILES=lib/wiki_sub.cgi \
			sample/pyukiwiki.ini.cgi \
			skin/loader.js skin/loader.js.gz \
			skin/bookmark.js skin/bookmark.js.gz \
			skin/captcha.js skin/captcha.js.gz \
			skin/instag.js skin/instag.js.gz \
			skin/instag.css skin/instag.css.gz \
			skin/common.en.js skin/common.en.js.gz \
			skin/common.ja.js skin/common.ja.js.gz \
			skin/common.sjis.ja.js skin/common.sjis.ja.js.gz \
			skin/common.utf8.ja.js skin/common.utf8.ja.js.gz \
			skin/common.unicode.ja.js skin/common.unicode.ja.js.gz \
			skin/edit.js skin/edit.js.gz \
			skin/setting.js skin/setting.js.gz \
			skin/passwd.js skin/passwd.js.gz \
			skin/twitter.js skin/twitter.js.gz \
			skin/twitstat.js skin/twitstat.js.gz \
			skin/smedia.js skin/smedia.js.gz \
			skin/smedia.css skin/smedia.css.gz \
			lib/File/magic.txt lib/File/magic_compact.txt \
			skin/pyukiwiki.default.css skin/pyukiwiki.default.css.gz \
			skin/pyukiwiki.print.css skin/pyukiwiki.print.css.gz \
			skin/pyukiwikigreen.default.css skin/pyukiwikigreen.default.css.gz \
			skin/pyukiwikigreen.print.css skin/pyukiwikigreen.print.css.gz \
			skin/tdiary.default.css skin/tdiary.default.css.gz \
			skin/tdiary.print.css skin/tdiary.print.css.gz \
			skin/pyukiwikigreen.skin.cgi \
			skin/logs_viewer.css \
			sample/mikachan.default.css sample/mikachan.print.css \
			sample/mikachan.default.css.org sample/mikachan.print.css.org \
			sample/mikachan.skin.cgi \
			skin/blosxom.css \
			skin/debugscript.js skin/debugscript.js.gz \
			skin/video.js skin/video.js.gz \
			skin/audio.js skin/audio.js.gz \
			skin/flowplayer-3.2.6.min.js skin/flowplayer-3.2.6.min.js.gz \
			skin/jquery.js skin/jquery.js.gz \
			skin/video-js.css skin/video-js.css.gz \
			skin/tube.css skin/tube.css.gz \
			skin/ad.css skin/ad.css.gz \
			skin/syntaxhighlighter/shAutoloader.js skin/syntaxhighlighter/shAutoloader.js.gz \
			skin/syntaxhighlighter/shBrushAS3.js skin/syntaxhighlighter/shBrushAS3.js.gz \
			skin/syntaxhighlighter/shBrushAppleScript.js skin/syntaxhighlighter/shBrushAppleScript.js.gz \
			skin/syntaxhighlighter/shBrushBash.js skin/syntaxhighlighter/shBrushBash.js.gz \
			skin/syntaxhighlighter/shBrushCSharp.js skin/syntaxhighlighter/shBrushCSharp.js.gz \
			skin/syntaxhighlighter/shBrushColdFusion.js skin/syntaxhighlighter/shBrushColdFusion.js.gz \
			skin/syntaxhighlighter/shBrushCpp.js skin/syntaxhighlighter/shBrushCpp.js.gz \
			skin/syntaxhighlighter/shBrushCss.js skin/syntaxhighlighter/shBrushCss.js.gz \
			skin/syntaxhighlighter/shBrushDelphi.js skin/syntaxhighlighter/shBrushDelphi.js.gz \
			skin/syntaxhighlighter/shBrushDiff.js skin/syntaxhighlighter/shBrushDiff.js.gz \
			skin/syntaxhighlighter/shBrushErlang.js skin/syntaxhighlighter/shBrushErlang.js.gz \
			skin/syntaxhighlighter/shBrushGroovy.js skin/syntaxhighlighter/shBrushGroovy.js.gz \
			skin/syntaxhighlighter/shBrushJScript.js skin/syntaxhighlighter/shBrushJScript.js.gz \
			skin/syntaxhighlighter/shBrushJava.js skin/syntaxhighlighter/shBrushJava.js.gz \
			skin/syntaxhighlighter/shBrushJavaFX.js skin/syntaxhighlighter/shBrushJavaFX.js.gz \
			skin/syntaxhighlighter/shBrushPerl.js skin/syntaxhighlighter/shBrushPerl.js.gz \
			skin/syntaxhighlighter/shBrushPhp.js skin/syntaxhighlighter/shBrushPhp.js.gz \
			skin/syntaxhighlighter/shBrushPlain.js skin/syntaxhighlighter/shBrushPlain.js.gz \
			skin/syntaxhighlighter/shBrushPowerShell.js skin/syntaxhighlighter/shBrushPowerShell.js.gz \
			skin/syntaxhighlighter/shBrushPython.js skin/syntaxhighlighter/shBrushPython.js.gz \
			skin/syntaxhighlighter/shBrushRuby.js skin/syntaxhighlighter/shBrushRuby.js.gz \
			skin/syntaxhighlighter/shBrushSass.js skin/syntaxhighlighter/shBrushSass.js.gz \
			skin/syntaxhighlighter/shBrushScala.js skin/syntaxhighlighter/shBrushScala.js.gz \
			skin/syntaxhighlighter/shBrushSql.js skin/syntaxhighlighter/shBrushSql.js.gz \
			skin/syntaxhighlighter/shBrushVb.js skin/syntaxhighlighter/shBrushVb.js.gz \
			skin/syntaxhighlighter/shBrushXml.js skin/syntaxhighlighter/shBrushXml.js.gz \
			skin/syntaxhighlighter/shCore.css skin/syntaxhighlighter/shCore.css.gz \
			skin/syntaxhighlighter/shCore.js skin/syntaxhighlighter/shCore.js.gz \
			skin/syntaxhighlighter/XRegExp.js skin/syntaxhighlighter/XRegExp.js.gz \
			skin/syntaxhighlighter/shThemeDefault.css skin/syntaxhighlighter/shThemeDefault.css.gz \
			skin/syntaxhighlighter/shThemeDjango.css skin/syntaxhighlighter/shThemeDjango.css.gz \
			skin/syntaxhighlighter/shThemeEclipse.css skin/syntaxhighlighter/shThemeEclipse.css.gz \
			skin/syntaxhighlighter/shThemeEmacs.css skin/syntaxhighlighter/shThemeEmacs.css.gz \
			skin/syntaxhighlighter/shThemeFadeToGrey.css skin/syntaxhighlighter/shThemeFadeToGrey.css.gz \
			skin/syntaxhighlighter/shThemeMDUltra.css skin/syntaxhighlighter/shThemeMDUltra.css.gz \
			skin/syntaxhighlighter/shThemeMidnight.css skin/syntaxhighlighter/shThemeMidnight.css.gz \
			skin/syntaxhighlighter/shThemeRDark.css skin/syntaxhighlighter/shThemeRDark.css.gz \
			build/list_hiragana_euc.txt

BUILDDOCS=\
			README.txt \
			./build/CGI_INSTALLER.ja.txt \
			DEVEL.txt \
			document/sample.txt \
			document/htaccess-sample.txt \
			document/specification.txt \
			document/specification_wikicgi.txt \
			README.html \
			document/README.html \
			document/menu.html \
			./build/CGI_INSTALLER.ja.html \
			document/DEVEL.html \
			document/sample.html \
			document/htaccess-sample.html \
			document/specification.html \
			document/specification_wikicgi.html \
			document/plugin_admin.txt \
			document/plugin_explugin.txt \
			document/plugin_all.txt \
			document/plugin_admin.html \
			document/plugin_explugin.html \
			document/plugin_plugin_ah.html \
			document/plugin_plugin_ip.html \
			document/plugin_plugin_rz.html \
			doc/plugin_admin.wiki \
			doc/plugin_explugin.wiki \
			doc/plugin_plugin_ah.wiki \
			doc/plugin_plugin_ip.wiki \
			doc/plugin_plugin_rz.wiki \
			build/license_art_en.html \
			build/license_art_ja.html \
			build/license_gpl_en.html \
			build/license_gpl_ja.html


pkg:FORCE
	@${MAKE} -f ${BUILDDIR}/build.mk cvsclean
	@${MAKE} -f ${BUILDDIR}/build.mk tempclean
	@${MAKE} -f ${BUILDDIR}/build.mk pkgtgz PKGTYPE=release PKGPREFIX="-full" CODE="euc" CRLF="lf"	# euc
	@${MAKE} -f ${BUILDDIR}/build.mk pkgtgz PKGTYPE=update PKGPREFIX="-update-full"	 CODE="euc" CRLF="lf"	# euc
	@${MAKE} -f ${BUILDDIR}/build.mk pkgtgz PKGTYPE=compact PKGPREFIX="-compact" CODE="euc" CRLF="lf"	# euc
	@${MAKE} -f ${BUILDDIR}/build.mk pkgtgz PKGTYPE=updatecompact PKGPREFIX="-update-compact" CODE="euc" CRLF="lf"	# euc
	@${MAKE} -f ${BUILDDIR}/build.mk pkgtgz PKGTYPE=devel PKGPREFIX="-devel" CODE="euc" CRLF="lf"	# euc
	@${MAKE} -f ${BUILDDIR}/build.mk pkgtgz PKGTYPE=updatedevel PKGPREFIX="-update-devel" CODE="euc" CRLF="lf"	# euc
	@${MAKE} -f ${BUILDDIR}/build.mk pkgtgz PKGTYPE=release PKGPREFIX="-full-utf8" CODE="utf8" CRLF="lf"	# utf8
	@${MAKE} -f ${BUILDDIR}/build.mk pkgtgz PKGTYPE=update PKGPREFIX="-update-full-utf8" CODE="utf8" CRLF="lf"	# utf8
	@${MAKE} -f ${BUILDDIR}/build.mk pkgtgz PKGTYPE=compact PKGPREFIX="-compact-utf8" CODE="utf8" CRLF="lf"	# utf8
	@${MAKE} -f ${BUILDDIR}/build.mk pkgtgz PKGTYPE=updatecompact PKGPREFIX="-update-compact-utf8" CODE="utf8" CRLF="lf"	# utf8
	@${MAKE} -f ${BUILDDIR}/build.mk pkgtgz PKGTYPE=devel PKGPREFIX="-devel-utf8" CODE="utf8" CRLF="lf"	# utf8
	@${MAKE} -f ${BUILDDIR}/build.mk pkgtgz PKGTYPE=updatedevel PKGPREFIX="-update-devel-utf8" CODE="utf8" CRLF="lf"	# utf8

release:FORCE
	@${MAKE} -f ${BUILDDIR}/build.mk cvsclean
	@${MAKE} -f ${BUILDDIR}/build.mk tempclean
	@${MAKE} -f ${BUILDDIR}/build.mk mk  PKGTYPE="release" PKGPREFIX="-full" CODE="euc" CRLF="lf"	# euc
	@${MAKE} -f ${BUILDDIR}/build.mk mk  PKGTYPE="compact" PKGPREFIX="-compact" CODE="euc" CRLF="lf"	# euc
	@${MAKE} -f ${BUILDDIR}/build.mk mk  PKGTYPE="update" PKGPREFIX="-update" CODE="euc" CRLF="lf"	# euc
	@${MAKE} -f ${BUILDDIR}/build.mk mk  PKGTYPE="updatecompact" PKGPREFIX="-update-compact" CODE="euc" CRLF="lf"	# euc
	@${MAKE} -f ${BUILDDIR}/build.mk mk  PKGTYPE="devel" PKGPREFIX="-devel" CODE="euc" CRLF="lf"	# euc
	@${MAKE} -f ${BUILDDIR}/build.mk mk  PKGTYPE="updatedevel" PKGPREFIX="-update-devel" CODE="euc" CRLF="lf"	# euc
	@${MAKE} -f ${BUILDDIR}/build.mk mk  PKGTYPE="release" PKGPREFIX="-full-utf8" CODE="utf8" CRLF="lf"	# utf8
	@${MAKE} -f ${BUILDDIR}/build.mk mk  PKGTYPE="compact" PKGPREFIX="-compact-utf8" CODE="utf8" CRLF="lf"	# utf8
	@${MAKE} -f ${BUILDDIR}/build.mk mk  PKGTYPE="update" PKGPREFIX="-update-utf8" CODE="utf8" CRLF="lf"	# utf8
	@${MAKE} -f ${BUILDDIR}/build.mk mk  PKGTYPE="updatecompact" PKGPREFIX="-update-compact-utf8" CODE="utf8" CRLF="lf"	# utf8
	@${MAKE} -f ${BUILDDIR}/build.mk mk  PKGTYPE="devel" PKGPREFIX="-devel-utf8" CODE="utf8" CRLF="lf"	# utf8
	@${MAKE} -f ${BUILDDIR}/build.mk mk  PKGTYPE="updatedevel" PKGPREFIX="-update-deve-utf8" CODE="utf8" CRLF="lf"	# utf8

releasedevel:FORCE
	@${MAKE} -f ${BUILDDIR}/build.mk mk  PKGTYPE="devel" PKGPREFIX="-devel" CODE="euc" CRLF="lf"	# euc
	@${MAKE} -f ${BUILDDIR}/build.mk mk  PKGTYPE="devel" PKGPREFIX="-devel-utf8" CODE="utf8" CRLF="lf"	# utf8

buildall:FORCE
	@${MAKE} -f ${BUILDDIR}/build.mk mk  PKGTYPE="devel" PKGPREFIX="-devel" CODE="euc" CRLF="lf" ALL="all"	# euc

buildallutf8:FORCE
	@${MAKE} -f ${BUILDDIR}/build.mk mk  PKGTYPE="devel" PKGPREFIX="-devel-utf8" CODE="utf8" CRLF="lf" ALL="all"	# euc

builddevel:FORCE
	@${MAKE} -f ${BUILDDIR}/build.mk mk  PKGTYPE="devel" PKGPREFIX="-devel" CODE="euc" CRLF="lf"	# euc

builddevelutf8:FORCE
	@${MAKE} -f ${BUILDDIR}/build.mk mk  PKGTYPE="devel" PKGPREFIX="-devel-utf8" CODE="utf8" CRLF="lf"	# utf8

buildcompact:FORCE
	@${MAKE} -f ${BUILDDIR}/build.mk mk  PKGTYPE="compact" PKGPREFIX="-compact" CODE="euc" CRLF="lf"	# euc

buildcompactutf8:FORCE
	@${MAKE} -f ${BUILDDIR}/build.mk mk  PKGTYPE="compact" PKGPREFIX="-compact-utf8" CODE="utf8" CRLF="lf"	# utf8

buildrelease:FORCE
	@${MAKE} -f ${BUILDDIR}/build.mk mk  PKGTYPE="release" PKGPREFIX="-full" CODE="euc" CRLF="lf"	# euc

buildreleaseutf8:FORCE
	@${MAKE} -f ${BUILDDIR}/build.mk mk  PKGTYPE="release" PKGPREFIX="-full-utf8" CODE="utf8" CRLF="lf"	# utf8

mk:FORCE
	@echo "=========================================================="
	@echo " Building ${PKGNAME}-${VERSION}${PKGPREFIX}"
	@echo "=========================================================="
	mkdir -p ${TEMP}
	mkdir -p ${RELEASE}
	mkdir -p "${RELEASE}/${CODE}-${CRLF}/${PKGNAME}-${VERSION}${PKGPREFIX}"
	${PERL} ${BUILDDIR}/build.pl mk ${TEMP} ${RELEASE}/${CODE}-${CRLF}/${PKGNAME}-${VERSION}${PKGPREFIX} ${TEMP}/${CODE}-${CRLF}-${PKGNAME}-${VERSION}${PKGPREFIX}.mk ${PKGTYPE} ${CRLF} ${CODE} ${ALL}
	${MAKE} -f ${TEMP}/${CODE}-${CRLF}-${PKGNAME}-${VERSION}${PKGPREFIX}.mk

pkgtgz:FORCE
#	@echo "Building ${PKGNAME}-${VERSION}${PKGPREFIX}"
	mkdir -p ${RELEASE} 2>/dev/null
	@${MAKE} -f ${BUILDDIR}/build.mk mk  PKGTYPE=${PKGTYPE} PKGPREFIX=${PKGPREFIX} CODE=${CODE} CRLF=${CRLF} ALL=${ALL}
	@${MAKE} -f ${BUILDDIR}/build.mk tgz  PKGTYPE=${PKGTYPE} PKGPREFIX=${PKGPREFIX} CODE=${CODE} CRLF=${CRLF} ALL=${ALL}

tgz:
	mkdir -p ${ARCHIVEDIR}/${PKGNAME}-${VERSION} 2>/dev/null
	@echo "=========================================================="
	@echo " Compress ${PKGNAME}-${VERSION}${PKGPREFIX}.tar.gz"
	@echo "=========================================================="
	cd ${RELEASE}/${CODE}-${CRLF} && ${TAR} ${PKGNAME}-${VERSION}${PKGPREFIX}.tar ${PKGNAME}-${VERSION}${PKGPREFIX} >/dev/null 2>/dev/null
#	@echo "=========================================================="
#	@echo " Compress ${PKGNAME}-${VERSION}${PKGPREFIX}.tar.gz"
#	@echo "=========================================================="
	cd ${RELEASE}/${CODE}-${CRLF} && ${GZIP_7Z} ${PKGNAME}-${VERSION}${PKGPREFIX}.tar.gz ${PKGNAME}-${VERSION}${PKGPREFIX}.tar >/dev/null 2>/dev/null
#	@echo "Compress ${PKGNAME}-${VERSION}${PKGPREFIX}.tar.bz2"
#	@cd ${RELEASE}/${CODE}-${CRLF} && ${BZIP2_7Z} ${PKGNAME}-${VERSION}${PKGPREFIX}.tar.bz2 ${PKGNAME}-${VERSION}${PKGPREFIX}.tar >/dev/null 2>/dev/null
#	@echo "Compress ${PKGNAME}-${VERSION}${PKGPREFIX}.tar.xz"
#	@cd ${RELEASE}/${CODE}-${CRLF} && ${XZ_7Z} ${PKGNAME}-${VERSION}${PKGPREFIX}.tar.xz ${PKGNAME}-${VERSION}${PKGPREFIX}.tar >/dev/null 2>/dev/null
	@rm ${RELEASE}/${CODE}-${CRLF}/${PKGNAME}-${VERSION}${PKGPREFIX}.tar
	@cp ${RELEASE}/${CODE}-${CRLF}/${PKGNAME}-${VERSION}${PKGPREFIX}.tar.gz ${ARCHIVEDIR}/${PKGNAME}-${VERSION}
#	@cp ${RELEASE}/${CODE}-${CRLF}/${PKGNAME}-${VERSION}${PKGPREFIX}.tar.bz2 ${ARCHIVEDIR}/${PKGNAME}-${VERSION}
#	@cp ${RELEASE}/${CODE}-${CRLF}/${PKGNAME}-${VERSION}${PKGPREFIX}.tar.xz ${ARCHIVEDIR}/${PKGNAME}-${VERSION}
	@rm ${RELEASE}/${CODE}-${CRLF}/${PKGNAME}-${VERSION}${PKGPREFIX}.tar.gz
#	@rm ${RELEASE}/${CODE}-${CRLF}/${PKGNAME}-${VERSION}${PKGPREFIX}.tar.bz2
#	@rm ${RELEASE}/${CODE}-${CRLF}/${PKGNAME}-${VERSION}${PKGPREFIX}.tar.xz
	@echo "=========================================================="
	@echo " Make installer ${PKGNAME}-${VERSION}${PKGPREFIX}"
	@echo "=========================================================="
	${SH} ${BUILDDIR}/makeinstaller.sh "${ZIP_7Z}" "${7Z_7Z}" ${ARCHIVEDIR}/${PKGNAME}-${VERSION}/${PKGNAME}-${VERSION}${PKGPREFIX}.tar.gz ${ARCHIVEDIR}/${PKGNAME}-${VERSION}/${PKGNAME}-${VERSION}${PKGPREFIX}_installer ${VERSION} ${PKGPREFIX} gz shar ${CODE}
#	@${SH} ${BUILDDIR}/makeinstaller.sh "${ZIP_7Z}" "${7Z_7Z}" ${ARCHIVEDIR}/${PKGNAME}-${VERSION}/${PKGNAME}-${VERSION}${PKGPREFIX}.tar.gz ${ARCHIVEDIR}/${PKGNAME}-${VERSION}/${PKGNAME}-${VERSION}${PKGPREFIX}_installer_gz_uu ${VERSION} ${PKGPREFIX} gz uu ${CODE}
#	@${SH} ${BUILDDIR}/makeinstaller.sh "${ZIP_7Z}" "${7Z_7Z}" ${ARCHIVEDIR}/${PKGNAME}-${VERSION}/${PKGNAME}-${VERSION}${PKGPREFIX}.tar.bz2 ${ARCHIVEDIR}/${PKGNAME}-${VERSION}/${PKGNAME}-${VERSION}${PKGPREFIX}_installer_bz2_b64 ${VERSION} ${PKGPREFIX} bz2 b64 ${CODE}
#	@${SH} ${BUILDDIR}/makeinstaller.sh "${ZIP_7Z}" "${7Z_7Z}" ${ARCHIVEDIR}/${PKGNAME}-${VERSION}/${PKGNAME}-${VERSION}${PKGPREFIX}.tar.xz ${ARCHIVEDIR}/${PKGNAME}-${VERSION}/${PKGNAME}-${VERSION}${PKGPREFIX}_installer_xz_b64 ${VERSION} ${PKGPREFIX} xz b64 ${CODE}

pkgzip:
#	@echo "Building ${PKGNAME}-${VERSION}${PKGPREFIX}"
	@mkdir ${RELEASE} 2>/dev/null
	@mkdir ${RELEASE}/${PKGNAME}-${VERSION}${PKGPREFIX} 2>/dev/null
	@${MAKE} -f ${BUILDDIR}/build.mk mk  PKGTYPE=${PKGTYPE} PKGPREFIX=${PKGPREFIX} CODE=${CODE} CRLF=${CRLF} ALL=${ALL}
	@${MAKE} -f ${BUILDDIR}/build.pl zip PKGTYPE=${PKGTYPE} PKGPREFIX=${PKGPREFIX} CODE=${CODE} CRLF=${CRLF} ALL=${ALL}

zip:
	@mkdir ${ARCHIVEDIR} 2>/dev/null
	@mkdir ${ARCHIVEDIR}/${PKGNAME}-${VERSION} 2>/dev/null
	@echo "=========================================================="
	@echo " Compress ${PKGNAME}-${VERSION}${PKGPREFIX}.zip"
	@echo "=========================================================="
	@cd ${RELEASE} && ${ZIP_7Z} zip.zip ${PKGNAME}-${VERSION}${PKGPREFIX}/* ${PKGNAME}-${VERSION}${PKGPREFIX}/.htaccess >/dev/null 2>/dev/null
	@cp ${RELEASE}/zip.zip ${ARCHIVEDIR}/${PKGNAME}-${VERSION}/${PKGNAME}-${VERSION}${PKGPREFIX}.zip
	@rm ${RELEASE}/zip.zip

pkgzipupdate:
#	@echo "Building ${PKGNAME}-${VERSION}${PKGPREFIX}"
	@mkdir ${RELEASE} 2>/dev/null
	@mkdir ${RELEASE}/${PKGNAME}-${VERSION}${PKGPREFIX} 2>/dev/null
	@${MAKE} -f ${BUILDDIR}/build.mk mk  PKGTYPE=${PKGTYPE} PKGPREFIX=${PKGPREFIX} CODE=${CODE} CRLF=${CRLF} ALL=${ALL}
	@${MAKE} -f ${BUILDDIR}/build.pl zipupdate PKGTYPE=${PKGTYPE} PKGPREFIX=${PKGPREFIX} CODE=${CODE} CRLF=${CRLF} ALL=${ALL}

zipupdate:
	@mkdir ${ARCHIVEDIR} 2>/dev/null
	@mkdir ${ARCHIVEDIR}/${PKGNAME}-${VERSION} 2>/dev/null
	@echo "=========================================================="
	@echo " Compress ${PKGNAME}-${VERSION}${PKGPREFIX}.zip"
	@echo "=========================================================="
	@cd ${RELEASE} && ${ZIP_7Z} zip.zip ${PKGNAME}-${VERSION}${PKGPREFIX}/*  >/dev/null 2>/dev/null
	@cp ${RELEASE}/zip.zip ${ARCHIVEDIR}/${PKGNAME}-${VERSION}/${PKGNAME}-${VERSION}${PKGPREFIX}.zip
	@rm ${RELEASE}/zip.zip

clean:
	@echo "Cleaning work directorys"
	@rm -rf ${TEMP} ${RELEASE}

tempclean:
	@rm -rf ${TEMP}

pkgclean:
	@echo "Cleaning Archive directorys"
	@rm -rf ${TEMP} ${RELEASE} ${ARCHIVEDIR}

realclean:
	@echo "Cleaning all build files"
	@rm -rf ${TEMP} ${RELEASE} ${ARCHIVEDIR}
	@rm -rf ${BUILDFILES}

cvsclean:
	@echo "Cleaning CVS tags"
	@for p in `find .|grep CVS`; do rm -rf $${p}; done

touch:FORCE
	@echo "Update time stamp for build files"
	@touch ${BUILDFILES}

prof:FORCE
	@${PERL} -d:DProf index.cgi >/dev/null 2>/dev/null
	@dprofpp -O 30
	@rm -f tmon.out

build:FORCE ${BUILDFILES} ${BUILDMAKER}

builddoc:FORCE ${BUILDDOCS} ${BUILDMAKER}

lib/File/magic.txt: lib/File/magic.txt.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compactmagic.pl lib/File/magic.txt.src>lib/File/magic.txt

lib/File/magic_compact.txt: lib/File/magic.txt.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compactmagic.pl lib/File/magic.txt.src compact>lib/File/magic_compact.txt

skin/common.sjis.ja.js: skin/common.ja.js ${BUILDMAKER}
	${PERL} ${BUILDDIR}/Jcode-convert.pl sjis skin/common.sjis.ja.js skin/common.ja.js

skin/common.unicode.ja.js: skin/common.ja.js ${BUILDMAKER}
	${PERL} ${BUILDDIR}/Jcode-convert.pl utf8 skin/common.unicode.ja.js.tmp skin/common.ja.js.src
	${PERL} ${BUILDDIR}/utf16.pl skin/common.unicode.ja.js.tmp skin/common.unicode.ja.js.tmp2
	${PERL} ${BUILDDIR}/compressfile.pl js3 skin/common.unicode.ja.js skin/common.unicode.ja.js.tmp2
	rm -f skin/common.unicode.ja.js.tmp skin/common.unicode.ja.js.tmp2

skin/common.utf8.ja.js: skin/common.ja.js ${BUILDMAKER}
	${PERL} ${BUILDDIR}/Jcode-convert.pl utf8 skin/common.utf8.ja.js skin/common.ja.js

skin/edit.js: skin/edit.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/Jcode-convert.pl utf8 skin/edit.js.tmp skin/edit.js.src
	${PERL} ${BUILDDIR}/utf16.pl skin/edit.js.tmp skin/edit.js.tmp2
	${PERL} ${BUILDDIR}/compressfile.pl js3 skin/edit.js skin/edit.js.tmp2
	rm -f skin/edit.js.tmp skin/edit.js.tmp2

skin/setting.js: skin/setting.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/Jcode-convert.pl utf8 skin/setting.js.tmp skin/setting.js.src
	${PERL} ${BUILDDIR}/utf16.pl skin/setting.js.tmp skin/setting.js.tmp2
	${PERL} ${BUILDDIR}/compressfile.pl js3 skin/setting.js skin/setting.js.tmp2
	rm -f skin/setting.js.tmp skin/setting.js.tmp2

sample/pyukiwiki.ini.cgi: pyukiwiki.ini.cgi ${BUILDMAKER}
	${PERL} ${BUILDDIR}/makesampleini.pl > sample/pyukiwiki.ini.cgi

skin/instag.js: skin/instag.js.src skin/jqModal.js.src ${BUILDMAKER}
	cat skin/jqModal.js.src skin/farbtastic.js.src skin/instag.js.src > skin/instag.cated.js.src
	${PERL} ${BUILDDIR}/Jcode-convert.pl utf8 skin/instag.js.2 skin/instag.cated.js.src
	${PERL} ${BUILDDIR}/utf16.pl skin/instag.js.2 skin/instag.js.3
	${PERL} ${BUILDDIR}/compressfile.pl js3 skin/instag.js skin/instag.js.3
	rm -f skin/instag.js.2 skin/instag.js.3

skin/loader.js: skin/loader.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js2 skin/loader.js skin/loader.js.src

skin/bookmark.js: skin/bookmark.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js2 skin/bookmark.js skin/bookmark.js.src

skin/captcha.js: skin/captcha.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js2 skin/captcha.js skin/captcha.js.src

skin/instag.css: skin/instag.css.src skin/jqModal.css.src skin/farbtastic.css.src ${BUILDMAKER}
	cat skin/instag.css.src skin/jqModal.css.src skin/farbtastic.css.src > tmpcss
	${PERL} ${BUILDDIR}/compressfile.pl css skin/instag.css tmpcss
	rm -f tmpcss

skin/passwd.js: skin/passwd.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js3 skin/passwd.js skin/passwd.js.src

skin/twitter.js: skin/twitter.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/Jcode-convert.pl utf8 skin/twitter.js.tmp skin/twitter.js.src
	${PERL} ${BUILDDIR}/utf16.pl skin/twitter.js.tmp skin/twitter.js.tmp2
	${PERL} ${BUILDDIR}/compressfile.pl js2 skin/twitter.js skin/twitter.js.tmp2
	rm -f skin/twitter.js.tmp2 skin/twitter.js.tmp

skin/twitstat.js: skin/twitstat.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js skin/twitstat.js skin/twitstat.js.src
skin/smedia.js: skin/smedia.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/Jcode-convert.pl utf8 skin/smedia.js.tmp skin/smedia.js.src
	${PERL} ${BUILDDIR}/utf16.pl skin/smedia.js.tmp skin/smedia.js.t2
	${PERL} ${BUILDDIR}/compressfile.pl js3 skin/smedia.js skin/smedia.js.t2
	rm -f skin/smedia.js.tmp skin/smedia.js.t2

skin/common.en.js: skin/common.en.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js3 skin/common.en.js skin/common.en.js.src

skin/common.ja.js: skin/common.ja.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js3 skin/common.ja.js skin/common.ja.js.src

skin/common.en.js.src: skin/common.lang.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/lang.pl en skin/common.lang.js.src

skin/common.ja.js.src: skin/common.lang.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/lang.pl ja skin/common.lang.js.src

skin/pyukiwiki.default.css: skin/pyukiwiki.default.css.org ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl css skin/pyukiwiki.default.css skin/pyukiwiki.default.css.org

skin/tdiary.default.css: skin/tdiary.default.css.org ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl css skin/tdiary.default.css skin/tdiary.default.css.org

skin/tdiary.print.css: skin/tdiary.print.css.org ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl css skin/tdiary.print.css skin/tdiary.print.css.org

skin/pyukiwiki.default.css.org: skin/pyukiwiki.default.css.src skin/pyukiwiki.table.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/csscolorbuilder.pl skin/pyukiwiki.default.css.src skin/pyukiwiki.table.src > skin/pyukiwiki.default.css.org

sample/mikachan.default.css.org: skin/pyukiwiki.default.css.org
	cp skin/pyukiwiki.default.css.org sample/mikachan.default.css.org

sample/mikachan.print.css.org: skin/pyukiwiki.print.css.org
	cp skin/pyukiwiki.print.css.org sample/mikachan.print.css.org

skin/pyukiwiki.print.css: skin/pyukiwiki.print.css.org ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl css skin/pyukiwiki.print.css skin/pyukiwiki.print.css.org

skin/pyukiwikigreen.default.css: skin/pyukiwikigreen.default.css.org ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl css skin/pyukiwikigreen.default.css skin/pyukiwikigreen.default.css.org

skin/pyukiwikigreen.default.css.org: skin/pyukiwiki.default.css.src skin/pyukiwikigreen.table.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/csscolorbuilder.pl skin/pyukiwiki.default.css.src skin/pyukiwikigreen.table.src > skin/pyukiwikigreen.default.css.org

skin/pyukiwikigreen.print.css: skin/pyukiwiki.print.css ${BUILDMAKER}
	cp skin/pyukiwiki.print.css skin/pyukiwikigreen.print.css

skin/pyukiwikigreen.skin.cgi: skin/pyukiwiki.skin.cgi ${BUILDMAKER}
	cp skin/pyukiwiki.skin.cgi skin/pyukiwikigreen.skin.cgi

skin/blosxom.css: skin/blosxom.css.org ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl css skin/blosxom.css skin/blosxom.css.org

skin/logs_viewer.css: skin/logs_viewer.css.org ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl css skin/logs_viewer.css skin/logs_viewer.css.org

skin/video-js.css: skin/video-js.css.org ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl css skin/video-js.css skin/video-js.css.org

skin/tube.css: skin/tube.css.org ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl css skin/tube.css skin/tube.css.org

skin/videoresize.js: skin/videoresize.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js2 skin/videoresize.js skin/videoresize.js.src

skin/video.js: skin/video.js.src skin/videoresize.js.src ${BUILDMAKER}
	cat skin/videoresize.js.src skin/video.js.src > tmpjsvideojs
	${PERL} ${BUILDDIR}/compressfile.pl js3 skin/video.js tmpjsvideojs
	rm -f tmpjsvideojs

skin/audio.js: skin/audio.js.src skin/swfobject-2.js.src ${BUILDMAKER}
	cat skin/swfobject-2.js.src skin/audio.js.src > tmpjsaudiojs
	${PERL} ${BUILDDIR}/Jcode-convert.pl utf8 tmpjsaudiojs2 tmpjsaudiojs
	${PERL} ${BUILDDIR}/utf16.pl tmpjsaudiojs2 tmpjsaudiojs3
	${PERL} ${BUILDDIR}/compressfile.pl js3 skin/audio.js tmpjsaudiojs3
	rm -f tmpjsaudiojs tmpjsaudiojs2 tmpjsaudiojs3

skin/debugscript.js: skin/debugscript.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js2 skin/debugscript.js skin/debugscript.js.src
	rm -f tmpjsvideojs

skin/flowplayer-3.2.6.min.js: skin/flowplayer-3.2.6.min.js.src skin/videoresize.js.src ${BUILDMAKER}
	cat skin/videoresize.js.src skin/flowplayer-3.2.6.min.js.src > tmpjsflowplayer
	${PERL} ${BUILDDIR}/compressfile.pl js2 skin/flowplayer-3.2.6.min.js tmpjsflowplayer
	rm -f tmpjsflowplayer

skin/jquery.js: skin/jquery.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js3 skin/jquery.js skin/jquery.js.src

skin/smedia.css: skin/smedia.css.org ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl css skin/smedia.css skin/smedia.css.org

skin/ad.css: skin/ad.css.org ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl css skin/ad.css skin/ad.css.org

sample/mikachan.default.css: sample/mikachan.default.css.org ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl css sample/mikachan.default.css sample/mikachan.default.css.org

sample/mikachan.print.css: sample/mikachan.print.css.org ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl css sample/mikachan.print.css sample/mikachan.print.css.org

sample/mikachan.skin.cgi: skin/pyukiwiki.skin.cgi ${BUILDMAKER}
	cp skin/pyukiwiki.skin.cgi sample/mikachan.skin.cgi

skin/syntaxhighlighter/shCore.js: skin/syntaxhighlighter/shCore.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js2 skin/syntaxhighlighter/shCore.js skin/syntaxhighlighter/shCore.js.src

skin/syntaxhighlighter/XRegExp.js: skin/syntaxhighlighter/XRegExp.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js2 skin/syntaxhighlighter/XRegExp.js skin/syntaxhighlighter/XRegExp.js.src

skin/syntaxhighlighter/shAutoloader.js: skin/syntaxhighlighter/shAutoloader.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js2 skin/syntaxhighlighter/shAutoloader.js skin/syntaxhighlighter/shAutoloader.js.src

skin/syntaxhighlighter/shBrushAS3.js: skin/syntaxhighlighter/shBrushAS3.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js2 skin/syntaxhighlighter/shBrushAS3.js skin/syntaxhighlighter/shBrushAS3.js.src

skin/syntaxhighlighter/shBrushAppleScript.js: skin/syntaxhighlighter/shBrushAppleScript.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js2 skin/syntaxhighlighter/shBrushAppleScript.js skin/syntaxhighlighter/shBrushAppleScript.js.src

skin/syntaxhighlighter/shBrushBash.js: skin/syntaxhighlighter/shBrushBash.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js2 skin/syntaxhighlighter/shBrushBash.js skin/syntaxhighlighter/shBrushBash.js.src

skin/syntaxhighlighter/shBrushCSharp.js: skin/syntaxhighlighter/shBrushCSharp.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js2 skin/syntaxhighlighter/shBrushCSharp.js skin/syntaxhighlighter/shBrushCSharp.js.src

skin/syntaxhighlighter/shBrushColdFusion.js: skin/syntaxhighlighter/shBrushColdFusion.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js2 skin/syntaxhighlighter/shBrushColdFusion.js skin/syntaxhighlighter/shBrushColdFusion.js.src

skin/syntaxhighlighter/shBrushCpp.js: skin/syntaxhighlighter/shBrushCpp.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js2 skin/syntaxhighlighter/shBrushCpp.js skin/syntaxhighlighter/shBrushCpp.js.src

skin/syntaxhighlighter/shBrushCss.js: skin/syntaxhighlighter/shBrushCss.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js2 skin/syntaxhighlighter/shBrushCss.js skin/syntaxhighlighter/shBrushCss.js.src

skin/syntaxhighlighter/shBrushDelphi.js: skin/syntaxhighlighter/shBrushDelphi.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js2 skin/syntaxhighlighter/shBrushDelphi.js skin/syntaxhighlighter/shBrushDelphi.js.src

skin/syntaxhighlighter/shBrushDiff.js: skin/syntaxhighlighter/shBrushDiff.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js2 skin/syntaxhighlighter/shBrushDiff.js skin/syntaxhighlighter/shBrushDiff.js.src

skin/syntaxhighlighter/shBrushErlang.js: skin/syntaxhighlighter/shBrushErlang.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js2 skin/syntaxhighlighter/shBrushErlang.js skin/syntaxhighlighter/shBrushErlang.js.src

skin/syntaxhighlighter/shBrushGroovy.js: skin/syntaxhighlighter/shBrushGroovy.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js2 skin/syntaxhighlighter/shBrushGroovy.js skin/syntaxhighlighter/shBrushGroovy.js.src

skin/syntaxhighlighter/shBrushJScript.js: skin/syntaxhighlighter/shBrushJScript.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js2 skin/syntaxhighlighter/shBrushJScript.js skin/syntaxhighlighter/shBrushJScript.js.src

skin/syntaxhighlighter/shBrushJava.js: skin/syntaxhighlighter/shBrushJava.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js2 skin/syntaxhighlighter/shBrushJava.js skin/syntaxhighlighter/shBrushJava.js.src

skin/syntaxhighlighter/shBrushJavaFX.js: skin/syntaxhighlighter/shBrushJavaFX.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js2 skin/syntaxhighlighter/shBrushJavaFX.js skin/syntaxhighlighter/shBrushJavaFX.js.src

skin/syntaxhighlighter/shBrushPerl.js: skin/syntaxhighlighter/shBrushPerl.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js2 skin/syntaxhighlighter/shBrushPerl.js skin/syntaxhighlighter/shBrushPerl.js.src

skin/syntaxhighlighter/shBrushPhp.js: skin/syntaxhighlighter/shBrushPhp.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js2 skin/syntaxhighlighter/shBrushPhp.js skin/syntaxhighlighter/shBrushPhp.js.src

skin/syntaxhighlighter/shBrushPlain.js: skin/syntaxhighlighter/shBrushPlain.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js2 skin/syntaxhighlighter/shBrushPlain.js skin/syntaxhighlighter/shBrushPlain.js.src

skin/syntaxhighlighter/shBrushPowerShell.js: skin/syntaxhighlighter/shBrushPowerShell.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js2 skin/syntaxhighlighter/shBrushPowerShell.js skin/syntaxhighlighter/shBrushPowerShell.js.src

skin/syntaxhighlighter/shBrushPython.js: skin/syntaxhighlighter/shBrushPython.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js2 skin/syntaxhighlighter/shBrushPython.js skin/syntaxhighlighter/shBrushPython.js.src

skin/syntaxhighlighter/shBrushRuby.js: skin/syntaxhighlighter/shBrushRuby.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js2 skin/syntaxhighlighter/shBrushRuby.js skin/syntaxhighlighter/shBrushRuby.js.src

skin/syntaxhighlighter/shBrushSass.js: skin/syntaxhighlighter/shBrushSass.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js2 skin/syntaxhighlighter/shBrushSass.js skin/syntaxhighlighter/shBrushSass.js.src

skin/syntaxhighlighter/shBrushScala.js: skin/syntaxhighlighter/shBrushScala.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js2 skin/syntaxhighlighter/shBrushScala.js skin/syntaxhighlighter/shBrushScala.js.src

skin/syntaxhighlighter/shBrushSql.js: skin/syntaxhighlighter/shBrushSql.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js2 skin/syntaxhighlighter/shBrushSql.js skin/syntaxhighlighter/shBrushSql.js.src

skin/syntaxhighlighter/shBrushVb.js: skin/syntaxhighlighter/shBrushVb.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js2 skin/syntaxhighlighter/shBrushVb.js skin/syntaxhighlighter/shBrushVb.js.src

skin/syntaxhighlighter/shBrushXml.js: skin/syntaxhighlighter/shBrushXml.js.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl js2 skin/syntaxhighlighter/shBrushXml.js skin/syntaxhighlighter/shBrushXml.js.src

skin/syntaxhighlighter/shCore.css: skin/syntaxhighlighter/shCore.css.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl css skin/syntaxhighlighter/shCore.css skin/syntaxhighlighter/shCore.css.src

skin/syntaxhighlighter/shThemeDefault.css: skin/syntaxhighlighter/shThemeDefault.css.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl css skin/syntaxhighlighter/shThemeDefault.css skin/syntaxhighlighter/shThemeDefault.css.src

skin/syntaxhighlighter/shThemeDjango.css: skin/syntaxhighlighter/shThemeDjango.css.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl css skin/syntaxhighlighter/shThemeDjango.css skin/syntaxhighlighter/shThemeDjango.css.src

skin/syntaxhighlighter/shThemeEclipse.css: skin/syntaxhighlighter/shThemeEclipse.css.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl css skin/syntaxhighlighter/shThemeEclipse.css skin/syntaxhighlighter/shThemeEclipse.css.src

skin/syntaxhighlighter/shThemeEmacs.css: skin/syntaxhighlighter/shThemeEmacs.css.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl css skin/syntaxhighlighter/shThemeEmacs.css skin/syntaxhighlighter/shThemeEmacs.css.src

skin/syntaxhighlighter/shThemeFadeToGrey.css: skin/syntaxhighlighter/shThemeFadeToGrey.css.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl css skin/syntaxhighlighter/shThemeFadeToGrey.css skin/syntaxhighlighter/shThemeFadeToGrey.css.src

skin/syntaxhighlighter/shThemeMDUltra.css: skin/syntaxhighlighter/shThemeMDUltra.css.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl css skin/syntaxhighlighter/shThemeMDUltra.css skin/syntaxhighlighter/shThemeMDUltra.css.src

skin/syntaxhighlighter/shThemeMidnight.css: skin/syntaxhighlighter/shThemeMidnight.css.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl css skin/syntaxhighlighter/shThemeMidnight.css skin/syntaxhighlighter/shThemeMidnight.css.src

skin/syntaxhighlighter/shThemeRDark.css: skin/syntaxhighlighter/shThemeRDark.css.src ${BUILDMAKER}
	${PERL} ${BUILDDIR}/compressfile.pl css skin/syntaxhighlighter/shThemeRDark.css skin/syntaxhighlighter/shThemeRDark.css.src

lib/wiki_sub.cgi: lib/wiki_auth.cgi lib/wiki_db.cgi lib/wiki_func.cgi lib/wiki_html.cgi lib/wiki_http.cgi lib/wiki_init.cgi lib/wiki_link.cgi lib/wiki_plugin.cgi lib/wiki_spam.cgi lib/wiki_wiki.cgi lib/wiki_write.cgi ${BUILDMAKER}
	${PERL} ${BUILDDIR}/makewikisub.pl lib/wiki_*.cgi >lib/wiki_sub.cgi

ftp:
	@echo "Uploading public file mirrorling"
	${PERL} ${BUILDDIR}/ftp.pl


######################
%.js.gz : %.js
	echo $<
	rm -f $<.gz
	cat $<|grep -v '^\/\*'|grep -v '^ \*'|grep -v '^ \*\/' > $<.tmp
	${GZIP_JC} $<.gz < $<.tmp >/dev/null
	rm -f $<.tmp

######################
%.css.gz : %.css
	rm -f $<.gz
	cat $<|grep -v '^\/\*'|grep -v '^ \*'|grep -v '^ \*\/' > $<.tmp
	${GZIP_JC} $<.gz < $<.tmp >/dev/null
	rm -f $<.tmp

######################
temp/head.html: doc/head.html temp/installer.css
	@perl build/build.pl cp "./temp" "0644" "doc/head.html" "./temp/head.html" "devel" "lf" "euc" "all" >/dev/null

#DOC=doc/document_acknowledgment.wiki \
#	doc/document_author.wiki \
#	doc/document_changes.wiki \
#	doc/document_donation.wiki \
#	doc/document_environment.wiki \
#	doc/document_faq.wiki \
#	doc/document_files_cgi.wiki \
#	doc/document_files_chmod.wiki \
#	doc/document_files_documents.wiki \
#	doc/document_files_pub.wiki \
#	doc/document_files_ref.wiki \
#	doc/document_library.wiki \
#	doc/document_license.wiki \
#	doc/document_package.wiki \
#	doc/specification.wiki \
#	doc/specification_body.wiki \
#	doc/specification_dir.wiki \
#	doc/specification_explugin.wiki \
#	doc/specification_expluginlist.wiki \
#	doc/specification_javascript.wiki \
#	doc/specification_perlpm.wiki \
#	doc/specification_plugin.wiki \
#	doc/specification_values.wiki \
#	doc/specification_wikicgi.wiki \
DOC=${BUILDFILES} ${BUILDMAKER}

######################
%.html : %.wiki temp/head.html doc/foot.html temp/installer.css ${DOC}
	mkdir -p ${TEMP}
	perl build/build.pl cp "./temp" "0644" "$<" "$@.1" "devel" "lf" "euc" "all" >/dev/null
	cat $@.1 | REQUEST_METHOD="GET" QUERY_STRING="cmd=stdin" perl index.cgi |nkf -w -E > $@.2
	cat temp/head.html $@.2 doc/foot.html > $@.3
	perl build/compressfile.pl html $@  $@.3

######################
%.txt : %.wiki temp/head.html doc/foot.html temp/installer.css ${DOC}
	mkdir -p ${TEMP}
	perl build/build.pl cp "./temp" "0644" "$<" "$@.1" "devel" "lf" "euc" "all" >/dev/null
	cat $@.1 | REQUEST_METHOD="GET" QUERY_STRING="cmd=stdin" perl index.cgi |nkf -w -E > $@.2
	cat temp/head.html $@.2 doc/foot.html > $@.3
	cat $@.3 |grep -v jumpmenu > $@.3.html
	w3m $@.3.html | nkf -w -E | perl -pe 's/\?\)/\xe2\x98\x85\)/g;' > $@

######################
./temp/installer.css: ./build/installer.css
	mkdir -p ${TEMP}
	perl build/compressfile.pl css ./temp/installer.css.1 ./build/installer.css
	tail -1 <./temp/installer.css.1 > ./temp/installer.css

######################
README.html: doc/index.html
	cp doc/index.html README.html

document/menu.html: doc/menu.html
	cp doc/menu.html document/menu.html

######################
temp/README.html: temp/README.wiki ${DOC}

temp/README/txt: temp/README.wiki ${DOC}

temp/README.wiki: doc/README.wiki ${DOC}
	mkdir -p ${TEMP}
	cp doc/README.wiki temp/README.wiki

document/README.html: temp/README.html
	cp temp/README.html document/README.html

README.txt: temp/README.txt
	cp temp/README.txt README.txt

######################
temp/DEVEL.html: temp/DEVEL.wiki ${DOC}

temp/DEVEL/txt: temp/DEVEL.wiki ${DOC}

temp/DEVEL.wiki: doc/DEVEL.wiki ${DOC}
	mkdir -p ${TEMP}
	cp doc/DEVEL.wiki temp/DEVEL.wiki

document/DEVEL.html: temp/DEVEL.html
	cp temp/DEVEL.html document/DEVEL.html

DEVEL.txt: temp/DEVEL.txt
	cp temp/DEVEL.txt DEVEL.txt

######################
temp/CGI_INSTALLER.ja.html: temp/CGI_INSTALLER.ja.wiki ${DOC}

temp/CGI_INSTALLER.ja/txt: temp/CGI_INSTALLER.ja.wiki ${DOC}

temp/CGI_INSTALLER.ja.wiki: doc/CGI_INSTALLER.ja.wiki ${DOC}
	mkdir -p ${TEMP}
	cp doc/CGI_INSTALLER.ja.wiki temp/CGI_INSTALLER.ja.wiki

build/CGI_INSTALLER.ja.html: temp/CGI_INSTALLER.ja.html
	cp temp/CGI_INSTALLER.ja.html build/CGI_INSTALLER.ja.html

build/CGI_INSTALLER.ja.txt: temp/CGI_INSTALLER.ja.txt
	cp temp/CGI_INSTALLER.ja.txt build/CGI_INSTALLER.ja.txt

######################
temp/htaccess-sample.html: temp/htaccess-sample.wiki ${DOC}

temp/htaccess-sample.txt: temp/htaccess-sample.wiki ${DOC}

temp/htaccess-sample.wiki: doc/htaccess-sample.wiki ${DOC}
	mkdir -p ${TEMP}
	cp doc/htaccess-sample.wiki temp/htaccess-sample.wiki

document/htaccess-sample.html: temp/htaccess-sample.html
	cp temp/htaccess-sample.html document/htaccess-sample.html

document/htaccess-sample.txt: temp/htaccess-sample.txt
	cp temp/htaccess-sample.txt document/htaccess-sample.txt

######################
temp/sample.html: temp/sample.wiki ${DOC}

temp/sample.txt: temp/sample.wiki ${DOC}

temp/sample.wiki: doc/sample.wiki ${DOC}
	mkdir -p ${TEMP}
	cp doc/sample.wiki temp/sample.wiki

document/sample.html: temp/sample.html
	cp temp/sample.html document/sample.html

document/sample.txt: temp/sample.txt
	cp temp/sample.txt document/sample.txt

######################
temp/specification.html: temp/specification.wiki ${DOC}

temp/specification/txt: temp/specification.wiki ${DOC}

temp/specification.wiki: doc/specification.wiki ${DOC}
	mkdir -p ${TEMP}
	cp doc/specification.wiki temp/specification.wiki

document/specification.html: temp/specification.html
	cp temp/specification.html document/specification.html

document/specification.txt: temp/specification.txt
	cp temp/specification.txt document/specification.txt

######################
temp/specification_wikicgi.html: temp/specification_wikicgi.wiki ${DOC}

temp/specification_wikicgi/txt: temp/specification_wikicgi.wiki ${DOC}

temp/specification_wikicgi.wiki: doc/specification_wikicgi.wiki ${DOC}
	mkdir -p ${TEMP}
	cp doc/specification_wikicgi.wiki temp/specification_wikicgi.wiki

document/specification_wikicgi.html: temp/specification_wikicgi.html
	cp temp/specification_wikicgi.html document/specification_wikicgi.html

document/specification_wikicgi.txt: temp/specification_wikicgi.txt
	cp temp/specification_wikicgi.txt document/specification_wikicgi.txt

######################
temp/license_art_en.html: temp/license_art_en.wiki ${DOC}

temp/license_art_en/txt: temp/license_art_en.wiki ${DOC}

temp/license_art_en.wiki: wiki/54686520224172746973746963204C6963656E736522.txt ${DOC}
	mkdir -p ${TEMP}
	cp wiki/54686520224172746973746963204C6963656E736522.txt temp/license_art_en.wiki

build/license_art_en.html: temp/license_art_en.html
	cp temp/license_art_en.html build/license_art_en.html

build/license_art_en.txt: temp/license_art_en.txt
	cp temp/license_art_en.txt build/license_art_en.txt

######################
temp/license_art_ja.html: temp/license_art_ja.wiki ${DOC}

temp/license_art_ja/txt: temp/license_art_ja.wiki ${DOC}

temp/license_art_ja.wiki: ${DOC}
	mkdir -p ${TEMP}
	-cp wiki/546865204172746973746963204C6963656E736520C6FCCBDCB8ECCCF520312E30.txt temp/license_art_ja.wiki.tmp 2>/dev/null
	-cp wiki/546865204172746973746963204C6963656E736520E697A5E69CACE8AA9EE8A8B320312E30.txt temp/license_art_ja.wiki.tmp 2>/dev/null
	cat temp/license_art_ja.wiki.tmp|nkf -e>temp/license_art_ja.wiki

build/license_art_ja.html: temp/license_art_ja.html
	cp temp/license_art_ja.html build/license_art_ja.html

build/license_art_ja.txt: temp/license_art_ja.txt
	cp temp/license_art_ja.txt build/license_art_ja.txt

######################
temp/license_gpl_en.html: temp/license_gpl_en.wiki ${DOC}

temp/license_gpl_en/txt: temp/license_gpl_en.wiki ${DOC}

temp/license_gpl_en.wiki: wiki/474E552047656E6572616C205075626C6963204C6963656E7365.txt ${DOC}
	mkdir -p ${TEMP}
	cp wiki/474E552047656E6572616C205075626C6963204C6963656E7365.txt temp/license_gpl_en.wiki

build/license_gpl_en.html: temp/license_gpl_en.html
	cp temp/license_gpl_en.html build/license_gpl_en.html

build/license_gpl_en.txt: temp/license_gpl_en.txt
	cp temp/license_gpl_en.txt build/license_gpl_en.txt

######################
temp/license_gpl_ja.html: temp/license_gpl_ja.wiki ${DOC}

temp/license_gpl_ja/txt: temp/license_gpl_ja.wiki ${DOC}

temp/license_gpl_ja.wiki: ${DOC}
	mkdir -p ${TEMP}
	-cp wiki/474E5520B0ECC8CCB8F8BDB0CDF8CDD1B5F6C2FABDF1.txt temp/license_gpl_ja.wiki.tmp
	-cp wiki/474E5520E4B880E888ACE585ACE8A186E588A9E794A8E8A8B1E8ABBEE69BB8.txt temp/license_gpl_ja.wiki.tmp
	cat temp/license_gpl_ja.wiki.tmp | nkf -e > temp/license_gpl_ja.wiki

build/license_gpl_ja.html: temp/license_gpl_ja.html
	cp temp/license_gpl_ja.html build/license_gpl_ja.html

build/license_gpl_ja.txt: temp/license_gpl_ja.txt
	cp temp/license_gpl_ja.txt build/license_gpl_ja.txt

build/list_hiragana_euc.txt: ${BUILDMAKER}
	perl ${BUILDDIR}/list_hiragana.pl

######################
temp/plugin_admin.html: temp/plugin_admin.wiki ${DOC}

temp/plugin_admin/txt: temp/plugin_admin.wiki ${DOC}

temp/plugin_admin.wiki: doc/plugin_admin.wiki ${DOC}
	mkdir -p ${TEMP}
	cp doc/plugin_admin.wiki temp/plugin_admin.wiki

document/plugin_admin.html: temp/plugin_admin.html
	cp temp/plugin_admin.html document/plugin_admin.html

document/plugin_admin.txt: temp/plugin_admin.txt
	cp temp/plugin_admin.txt document/plugin_admin.txt

######################
temp/plugin_explugin.html: temp/plugin_explugin.wiki ${DOC}

temp/plugin_explugin/txt: temp/plugin_explugin.wiki ${DOC}

temp/plugin_explugin.wiki: doc/plugin_explugin.wiki ${DOC}
	mkdir -p ${TEMP}
	cp doc/plugin_explugin.wiki temp/plugin_explugin.wiki

document/plugin_explugin.html: temp/plugin_explugin.html
	cp temp/plugin_explugin.html document/plugin_explugin.html

document/plugin_explugin.txt: temp/plugin_explugin.txt
	cp temp/plugin_explugin.txt document/plugin_explugin.txt

######################
temp/plugin_plugin_ah.html: temp/plugin_plugin_ah.wiki ${DOC}

temp/plugin_plugin_ah.wiki: doc/plugin_plugin_ah.wiki ${DOC}
	mkdir -p ${TEMP}
	cp doc/plugin_plugin_ah.wiki temp/plugin_plugin_ah.wiki

document/plugin_plugin_ah.html: temp/plugin_plugin_ah.html
	cp temp/plugin_plugin_ah.html document/plugin_plugin_ah.html

######################
temp/plugin_plugin_ip.html: temp/plugin_plugin_ip.wiki ${DOC}

temp/plugin_plugin_ip.wiki: doc/plugin_plugin_ip.wiki ${DOC}
	mkdir -p ${TEMP}
	cp doc/plugin_plugin_ip.wiki temp/plugin_plugin_ip.wiki

document/plugin_plugin_ip.html: temp/plugin_plugin_ip.html
	cp temp/plugin_plugin_ip.html document/plugin_plugin_ip.html

######################
temp/plugin_plugin_rz.html: temp/plugin_plugin_rz.wiki ${DOC}

temp/plugin_plugin_rz.wiki: doc/plugin_plugin_rz.wiki ${DOC}
	mkdir -p ${TEMP}
	cp doc/plugin_plugin_rz.wiki temp/plugin_plugin_rz.wiki

document/plugin_plugin_rz.html: temp/plugin_plugin_rz.html
	cp temp/plugin_plugin_rz.html document/plugin_plugin_rz.html

######################
temp/plugin_plugin/txt: temp/plugin_all.wiki ${DOC}

temp/plugin_all.wiki: doc/plugin_all.wiki ${DOC}
	mkdir -p ${TEMP}
	cp doc/plugin_all.wiki temp/plugin_all.wiki

document/plugin_all.txt: temp/plugin_all.txt
	cp temp/plugin_all.txt document/plugin_all.txt

######################
doc/plugin_admin.wiki: doc/plugins_document.sh
	perl doc/plugins_document.sh

doc/plugin_explugin.wiki: doc/plugins_document.sh
#	perl doc/plugins_document.sh

doc/plugin_plugin_ah.wiki: doc/plugins_document.sh
#	perl doc/plugins_document.sh

doc/plugin_plugin_ip.wiki: doc/plugins_document.sh
#	perl doc/plugins_document.sh

doc/plugin_plugin_rz.wiki: doc/plugins_document.sh
#	perl doc/plugins_document.sh

doc/specification_wikicgi.wiki: doc/wikicgi_document.sh
	perl doc/wikicgi_document.sh


FORCE:
