######################################################################
# googlemap.inc.pl - This is PyukiWiki yet another Wiki clone
# $Id: googlemap.inc.pl,v 1.20 2013/03/30 21:24:20 papu Exp $
# Build 2013-03-27 07:36:38
#
# "googlemap" ver 1.0 $$
# Author Nanami http://nanakochi.daiba.cx/
# Copyright(C) 2004-2007 Nekyo
# Copyright(C) 2005-2013 PyukiWiki Developers Team
# http://pyukiwiki.info/
# Based on YukiWiki http://www.hyuki.com/yukiwiki/
# Powerd by PukiWiki http://pukiwiki.sfjp.jp/
# License GPL3 and/or Artistic or each later version
#
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
# Return=CRLF Code=UTF-8 1TAB=4Spaces
######################################################################

$PLUGIN="googlemap";
$VERSION="1.0";

$googlemap::link="http://maps.google.com/maps?q=\$QUERY";
$googlemap::iframe="http://maps.google.com/maps?q=\$QUERY&amp;output=embed";
$googlemap::width="500";
$googlemap::height="400";

sub plugin_googlemap_convert {
	my($query, $ratio)=split(/,/, shift);
	$query=&code_convert(\$query, "utf8", $::defaultcode);
	$query=&encode($query);
	my $url=&replace($googlemap::link
		, QUERY=>$query
	);
	my $iframe=&replace($googlemap::iframe
		, QUERY=>$query
	);
	my $body=<<EOM;
<iframe width="$googlemap::width" height="$googlemap::height" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" src="$iframe"></iframe>
<a target="_blank" href="$url">$::resource{googlemap_more}></a>
EOM
	$body;
}
1;
__END__
=head1 NAME

googlemap.inc.pl - PyukiWiki Plugin

=head1 SYNOPSIS

 #googlemap(EOM)
 <script type="text/javascript"><!--
 alert("Hello world");
 //--></script>
 EOM

=head1 DESCRIPTION

Display google map

=head1 SEE ALSO

=over 4

=item PyukiWiki/Plugin/Nanami/googlemap

L<http://pyukiwiki.info/PyukiWiki/Plugin/Nanami/googlemap/>

=item PyukiWiki CVS

L<http://sfjp.jp/cvs/view/pyukiwiki/PyukiWiki-Devel/plugin/googlemap.inc.pl?view=log>

L<http://sfjp.jp/cvs/view/pyukiwiki/PyukiWiki-Devel-UTF8/plugin/googlemap.inc.pl?view=log>

L<http://cvs.pyukiwiki.info/cgi-bin/cvsweb.cgi/PyukiWiki-Devel/plugin/googlemap.inc.pl?view=log>

L<http://cvs.pyukiwiki.info/cgi-bin/cvsweb.cgi/PyukiWiki-Devel-UTF8/plugin/googlemap.inc.pl?view=log>

=back

=head1 AUTHOR

=over 4

=item Nanami

L<http://nanakochi.daiba.cx/> etc...

=item PyukiWiki Developers Team

L<http://pyukiwiki.info/>

=back

=head1 LICENSE

Copyright(C) 2005-2013 by Nanami.

Copyright(C) 2005-2013 by PyukiWiki Developers Team

License is GNU GENERAL PUBLIC LICENSE 3 and/or Artistic 1 or each later version.

This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=cut
