######################################################################
# twitter.inc.pl - This is PyukiWiki yet another Wiki clone
# $Id: twitter.inc.pl,v 1.247 2013/03/30 21:24:22 papu Exp $
# Build 2013-03-27 07:38:48
#
# "PyukiWiki" ver 0.2.1-beta8 $$
# Author Nanami http://nanakochi.daiba.cx/
# Copyright(C) 2004-2007 Nekyo
# Copyright(C) 2005-2013 PyukiWiki Developers Team
# http://pyukiwiki.info/
# Based on YukiWiki http://www.hyuki.com/yukiwiki/
# Powerd by PukiWiki http://pukiwiki.sfjp.jp/
# License GPL3 and/or Artistic or each later version
#
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
# Return=CRLF Code=UTF-8 1TAB=4Spaces
######################################################################
# 2013/03/26 changes: support Twitter API 1.1
# 2013/03/17 changes: support Twitter widgets
# 2012/09/29 changes: support multi view
# 2012/04/09 changes: not using jquery and bug fix
# 2012/03/21 changes: support new jquery twitter client
######################################################################
# Please use new twitter widgets
# https://twitter.com/settings/widgets
#
# Step.1 Make widgets HTML tag
#
# Step.2 Paste HTML tag to wiki
# #twitter(=)
# (HTML)
# #twitter
#
# Step.3 Adjustment height
# #twitter(=,height=1000)
# (HTML)
# #twitter
#
# If use javascript client, Please regist twitter application api
# (using Twitter API 1.1)
# https://dev.twitter.com/apps
######################################################################

$twitter::newclient=1			# 私家版 twitterクライアントを使用する
	if(!defined($twitter::newclient));

######################################################################

# JavaScriptクライアントを使用する時のトークン

$twitter::ConsumerKey{twitterincpl}="a0qtCPvSWNBNg5ISsHeNgw"
	if(!defined($twitter::ConsumerKey{twitterincpl}));

$twitter::Consumersecret{twitterincpl}="vbHwBDZbbIm53ylFcjJkj0unDc0TcSDho6oO8YO8"
	if(!defined($twitter::Consumersecret{twitterincpl}));

$twitter::Accesstoken{twitterincpl}="264102049-htoXaI6vyPbr9xi41bBt38TWG6u0xgmfSIw94yKU"
	if(!defined($twitter::Accesstoken{twitterincpl}));

$twitter::Accesstokensecret{twitterincpl}="aROWE3bF6rzFmwMOCD4jM0zNjnCS0qe46er5uGaKlE"
	if(!defined($twitter::Accesstokensecret{twitterincpl}));

# タイトル
if(!defined($twitter::title)) {
	if($::lang eq "ja") {
		$twitter::title="\$1のツィート";
	} else {
		$twitter::title="Tweet of \$1";
	}
}

$twitter::max=7
	if(!defined($twitter::max));

$twitter::border_color="#434343"
	if(!defined($twitter::border_color));

$twitter::header_background="#434343"
	if(!defined($twitter::header_background));

$twitter::header_font_color="#ffffff"
	if(!defined($twitter::header_font_color));

$twitter::header_link_color="#ffffff"
	if(!defined($twitter::header_font_color));

$twitter::content_background_color="#e1e1e1"
	if(!defined($twitter::content_background_color));

$twitter::content_font_color="#333333"
	if(!defined($twitter::content_font_color));

$twitter::link_color="#307ace"
	if(!defined($twitter::link_color));

######################################################################

# 代替えウィジッドの設定

$twitter::width="1000"
	if(!defined($twitter::width));

$twitter::widget_width="500"
	if(!defined($twitter::widget_width));

$twitter::widget_height="500"
	if(!defined($twitter::widget_height));

######################################################################

$::plugin_twitter_count=0;
$twitter::tempheight;
$twitter::tempwidth;

# sample token of @pyukiwiki
$twitter::ConsumerKey{init}="ADvO6o9gFJquClxNNSnIQ";
$twitter::Consumersecret{init}="ZB8zDMw1EuGEmMHR1M9oVaqElZfyq1CRfykOSXkV8";
$twitter::Accesstoken{init}="1301567671-w8jO6LopmS0Tbu7RX7Ne0FCsWZvf4bPGr1ivAFd";
$twitter::Accesstokensecret{init}="ZOzuPnwdrrlk4GuoTmsOTEZDskQ0Oh6YQWwqmHoh9E";


$twitter::token;

sub twitter_init {
	return if($twitter::token ne "");
	$::js_lasttag=0;
	&load_module("Nana::Enc");
	my $token=Nana::Enc::maketoken;
	my $s1="$twitter::ConsumerKey{init}|$twitter::Consumersecret{init}|$twitter::Accesstoken{init}|$twitter::Accesstokensecret{init}";
	$s1="$twitter::ConsumerKey{twitterincpl}|$twitter::Consumersecret{twitterincpl}|$twitter::Accesstoken{twitterincpl}|$twitter::Accesstokensecret{twitterincpl}"
		if(    $twitter::ConsumerKey{twitterincpl} ne ""
			&& $twitter::Consumersecret{twitterincpl} ne ""
			&& $twitter::Accesstoken{twitterincpl} ne ""
			&& $twitter::Accesstokensecret{twitterincpl} ne "");
	$twitter::token="$token|" . Nana::Enc::encode($s1, $token);
}

sub plugin_twitter_convert {
	my @arg=split(/,/,shift);
	my %tparm;
#	&jscss_include("jquery/jquery");
	&twitter_init;

	foreach(@arg) {
		my($l, $r)=split(/=/,$_);
		$l=lc &trim($l);
		$r=&trim($r);
		$r="=" if($l eq "");
		$r="=" if($_ eq "=");
		$tparm{$l}=$r;
	}

	if($tparm{""} eq "=" ) {
		$::linedata="";
		$::linesave=1;
		$::eom_string=$tparm{eom};
		$twitter::tempheight=$tparm{height};
		$twitter::tempwidth=$tparm{width};

		$::eom_string="#twitter" if($eom eq '');
		$::exec_inlinefunc=\&plugin_twitter_display;
		return ' '
	} else {
		return &plugin_twitter_main($arg[0], $arg[1]);
	}
}

sub plugin_twitter_display {
	my ($html)=@_;
	if($html=~/script/ && $html=~/platform\.twitter\.com\/widgets/
	&& $html=~/class\="twitter\-/ && $html=~/data-widget-id/) {
		$html=~s/[\r|\n]//g;
		$html=~s/\<script>.*//g;
		my $href;
		my $widgetid;
		my $username;
		my $listname;
		if($html=~/href\=\"($::isurl)\"/) {
			$href=$1;
		}
		if($html=~/data-widget-id="(\d+)"/) {
			$widgetid=$1;
		}
		if($href=~/\/search\?q\=(.+?)\"/) {
			$mode="search";
			$search=&decode($1);
		} elsif($href=~/\/favorites$/) {
			$mode="favorites";
			my $test=$href;
			$test=~s/^https:\/\/twitter\.com\///g;
			($username, $listname)=split(/\//, $test);
		} else {
			my $test=$href;
			$test=~s/^https:\/\/twitter\.com\///g;
			if($test=~/\//) {
				$mode="list";
				($username, $listname)=split(/\//, $test);
			} else {
				$mode="tweet";
				($username, $listname)=split(/\//, $test);
			}
		}
		my $title=$::resource{"twitter_plugin_widget_$mode"};
		$title=~s/\$username/$username/g;
		$title=~s/\$listname/$listname/g;
		$title=~s/\$search/$search/g;

		my $height=$twitter::tempheight > 0 ? $twitter::tempheight : $twitter::widget_height;
		my $width=$twitter::tempwidth > 0 ? $twitter::tempwidth : $twitter::widget_width;

		$body=<<EOM;
<a class="twitter-timeline href="$href" width="$width" height="$height" data-widget-id="$widgetid">$title</a>
<script>!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0];if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src="//platform.twitter.com/widgets.js";fjs.parentNode.insertBefore(js,fjs);}}(document,"script","twitter-wjs");</script>
EOM
		return $body;
	}
	return " ";
}

sub plugin_twitter_main {
	my ($keywords, $title)=@_;
	if($title eq '') {
		$title=$twitter::title;
		$title=~s/\$1/$keywords/g;
	}

	my $flag=$::use_popup if($flag eq '');
	my $popup_allow=$::setting_cookie{popup} ne '' ? $::setting_cookie{popup}
					: $flag+0 ? 1 : 0;
	if($::plugin_twitter_count ne 0 && $twitter::newclient eq 0) {
		return <<EOM;
<div class="error">Can't insert more twitter plugin of this page</div>
EOM
	}
	$::plugin_twitter_count++;

	if($twitter::newclient) {
		$::IN_HEAD.=<<EOM;
@{[&jscss_include("twitter:tw")]}
EOM
		my $track=$::_exec_plugined{logs} || $::_exec_plugined{linktrack}
			? 1 : 0;

		$::IN_JSHEAD.=<<EOM;
twitwindow("$twitter::token", "twitwindow$::plugin_twitter_count", "$keywords","$title", $twitter::max, "$twitter::border_color", "$twitter::header_background", "$twitter::header_font_color", "$twitter::header_link_color", "$twitter::content_background_color", "$twitter::content_font_color", "$twitter::link_color", $twitter::width ,$popup_allow, $track);
EOM

		return <<EOM;
<p id="twitwindow$::plugin_twitter_count"></p>
EOM
	}

	$::IN_HEAD.=<<EOM;
@{[&jscss_include("twitstat:twitstat")]}
EOM

		$::IN_JSHEAD.=<<EOM;
twitstat.badge.init({
	badge_container: "twitstat_badge_$::plugin_twitter_count",
	title: "$title",
	keywords: "$keywords",
	max: $twitter::max,
	border_color: "$twitter::border_color",
	header_background: "$twitter::header_background",
	header_font_color: "$twitter::header_font_color",
	content_background_color: "$twitter::content_background_color",
	content_font_color: "$twitter::content_font_color",
	link_color: "$twitter::link_color",
	width: $twitter::width,
	popup: $popup_allow
});
EOM
	return <<EOM;
<div id="twitter">
<div class="twitstatus_badge_container" id="twitstat_badge\_$::plugin_twitter_count"></div>
</div>
EOM
}

sub plugin_twitter_action {
	&load_module("Nana::HTTP");

	my $env;
	foreach(keys %::form) {
		if($_ eq "rpp" || $_ eq "callback" || $_ eq "q" || $_ eq "near" || $_ eq "within" || $_ eq "units" || $_ eq "since_id") {
			if($_ eq "q") {
				$env.="$_=@{[&encode($::form{$_})]}&";
			} else {
				$env.="$_=$::form{$_}&";
			}
		}
	}
	$env=~s/\&$//g;
	my $http=new Nana::HTTP('plugin'=>"twitter");
	my $searchurl="http://search.twitter.com/search.json";

	my $uri="$searchurl?$env";
	my ($result, $stream) = $http->get($uri);
	if($result eq 0) {
		print &http_header("Content-type: application/json");
		print $stream;
		} else {
		print &http_header("Content-type: text/plain");
		print "Cant get '$uri'\n";
	}
	exit;
}

1;
__END__

=head1 NAME

twitter.inc.pl - PyukiWiki Plugin

=head1 SYNOPSIS

 #twitter(=)
 (Twitter Widget HTML)
 #twitter

=head1 DESCRIPTION

Display twitter username of twite of twitter of #hashtag


=head1 USAGE

=over 4

=item Make Twitter Widgets

https://twitter.com/settings/widgets

=item Place wiki

 #twitter(=)
 (Twitter Widget HTML)
 #twitter

=back

=head1 SEE ALSO

=over 4

=item PyukiWiki/Plugin/Standard/twitter

L<http://pyukiwiki.info/PyukiWiki/Plugin/Standard/twitter/>

=item PyukiWiki CVS

L<http://sfjp.jp/cvs/view/pyukiwiki/PyukiWiki-Devel/plugin/twitter.inc.pl?view=log>

L<http://sfjp.jp/cvs/view/pyukiwiki/PyukiWiki-Devel-UTF8/plugin/twitter.inc.pl?view=log>

L<http://cvs.pyukiwiki.info/cgi-bin/cvsweb.cgi/PyukiWiki-Devel/plugin/twitter.inc.pl?view=log>

L<http://cvs.pyukiwiki.info/cgi-bin/cvsweb.cgi/PyukiWiki-Devel-UTF8/plugin/twitter.inc.pl?view=log>

=back

=head1 AUTHOR

=over 4

=item Nanami

L<http://nanakochi.daiba.cx/> etc...

=item PyukiWiki Developers Team

L<http://pyukiwiki.info/>

=back

=head1 LICENSE

Copyright(C) 2005-2013 by Nanami.

Copyright(C) 2005-2013 by PyukiWiki Developers Team

License is GNU GENERAL PUBLIC LICENSE 3 and/or Artistic 1 or each later version.

This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=cut
