/*
 * Decompiled with CFR 0.152.
 */
package com.qbrowser.util;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class QBrowserUtil {
    public static final String PASSFILE_NAME = "passfile.txt";

    public static File checkIfPassFileExists() {
        File the_pass_file = new File(QBrowserUtil.getTargetPassfilePath());
        if (the_pass_file.exists()) {
            return the_pass_file;
        }
        return null;
    }

    public static void cleanupPassFile() {
        File the_pass_file = null;
        the_pass_file = QBrowserUtil.checkIfPassFileExists();
        if (the_pass_file != null) {
            try {
                the_pass_file.delete();
            }
            catch (Throwable thex) {
                System.err.println(thex.getMessage());
            }
        }
    }

    public static void createPassfile(String password) {
        try {
            File targetps = new File(QBrowserUtil.getQBrowserTempFileDir());
            targetps.mkdirs();
            File targetpassfile = new File(QBrowserUtil.getTargetPassfilePath());
            targetpassfile.createNewFile();
            PrintWriter pwr = new PrintWriter(new FileWriter(targetpassfile));
            pwr.println("imq.imqcmd.password=" + password);
            pwr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getQBrowserTempFileDir() {
        return QBrowserUtil.getUserHome() + File.separator + ".qbrowserv2" + File.separator;
    }

    public static String getTargetPassfilePath() {
        return QBrowserUtil.getQBrowserTempFileDir() + PASSFILE_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File from, File to) throws IOException {
        FilterOutputStream out = null;
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(from));
            out = new BufferedOutputStream(new FileOutputStream(to));
            byte[] buff = new byte[4096];
            int len = 0;
            while ((len = in.read(buff, 0, buff.length)) >= 0) {
                ((BufferedOutputStream)out).write(buff, 0, len);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static String getUserHome() {
        return System.getProperty("user.home");
    }

    public static void ArrayListToJComboBox(ArrayList inputarray, JComboBox targetcombobox) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)targetcombobox.getModel();
        for (int i = 0; i < inputarray.size(); ++i) {
            String key = (String)inputarray.get(i);
            if (!QBrowserUtil.checkDups(key, targetcombobox)) continue;
            model.insertElementAt(key, 0);
        }
        if (targetcombobox.getItemCount() > 0) {
            targetcombobox.setSelectedIndex(0);
        }
    }

    public static ArrayList jcomboBoxToArrayList(JComboBox inputbox) {
        ArrayList<String> targetArray = new ArrayList<String>();
        try {
            for (int i = 0; i < inputbox.getItemCount(); ++i) {
                String key = (String)inputbox.getItemAt(i);
                targetArray.add(key);
            }
        }
        catch (Throwable thex) {
            System.err.println(thex.getMessage());
        }
        return targetArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveHistoryToFile(String history_name, ArrayList target_history) {
        String targetFilePath = QBrowserUtil.getQBrowserTempFileDir() + history_name;
        File targethisfile = new File(targetFilePath);
        PrintWriter pwr = null;
        try {
            if (!targethisfile.exists()) {
                targethisfile.createNewFile();
            }
            pwr = new PrintWriter(new FileWriter(targethisfile));
            for (int i = target_history.size() - 1; i > -1; --i) {
                String history_entry = (String)target_history.get(i);
                pwr.println(history_entry);
            }
            pwr.close();
        }
        catch (Exception ioe) {
            System.err.println(ioe.getMessage());
        }
        finally {
            if (pwr != null) {
                try {
                    pwr.close();
                }
                catch (Exception pwre) {}
                pwr = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getHistoryFromFile(String history_name) {
        String targetFilePath = QBrowserUtil.getQBrowserTempFileDir() + history_name;
        File ifile = new File(targetFilePath);
        ArrayList<String> retVal = new ArrayList<String>();
        BufferedReader br = null;
        try {
            if (ifile.exists()) {
                br = new BufferedReader(new FileReader(ifile));
                String line = null;
                while ((line = br.readLine()) != null) {
                    retVal.add(line);
                }
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                    br = null;
                }
                catch (Exception fie) {}
            }
        }
        return retVal;
    }

    public static boolean checkDups(String hikaku, JComboBox targetcombobox) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)targetcombobox.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            String key = (String)model.getElementAt(i);
            if (!key.trim().equals(hikaku.trim())) continue;
            return false;
        }
        return true;
    }

    public static void addLabelAndValueComponent(GridBagConstraints valueConstraints, JPanel targetPanel, GridBagLayout valueGbag, String labelStr, Component value, int yAxis) {
        JLabel label = new JLabel(labelStr, 2);
        valueConstraints.gridx = 0;
        valueConstraints.gridy = yAxis;
        valueConstraints.weightx = 1.0;
        valueConstraints.weighty = 1.0;
        valueConstraints.anchor = 13;
        valueGbag.setConstraints(label, valueConstraints);
        targetPanel.add(label);
        valueConstraints.gridx = 1;
        valueConstraints.gridy = yAxis;
        valueConstraints.weightx = 1.0;
        valueConstraints.weighty = 1.0;
        valueConstraints.anchor = 17;
        valueGbag.setConstraints(value, valueConstraints);
        targetPanel.add(value);
    }

    public static void addBlankRow(GridBagConstraints valueConstraints, JPanel targetPanel, GridBagLayout valueGbag, int yAxis) {
        JLabel label = new JLabel(" ", 2);
        valueConstraints.gridx = 0;
        valueConstraints.gridy = yAxis;
        valueConstraints.weightx = 1.0;
        valueConstraints.weighty = 1.0;
        valueConstraints.anchor = 13;
        valueGbag.setConstraints(label, valueConstraints);
        targetPanel.add(label);
    }
}

