/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.ObjStoreListProperties;
import com.sun.messaging.jmq.admin.objstore.ObjStore;
import com.sun.messaging.jmq.admin.objstore.ObjStoreAttrs;
import com.sun.messaging.jmq.admin.objstore.ObjStoreException;
import com.sun.messaging.jmq.admin.objstore.ObjStoreManager;
import com.sun.messaging.jmq.admin.util.UserPropertiesException;
import java.util.Enumeration;

public class ConsoleObjStoreManager
extends ObjStoreManager {
    private boolean DEBUG = false;
    private static ConsoleObjStoreManager mgr = null;
    private String fileName = "objstorelist.properties";

    protected ConsoleObjStoreManager() {
    }

    public static synchronized ConsoleObjStoreManager getConsoleObjStoreManager() {
        if (mgr == null) {
            mgr = new ConsoleObjStoreManager();
        }
        return mgr;
    }

    public void readObjStoresFromFile() throws UserPropertiesException, ObjStoreException {
        ObjStoreListProperties objStoreListProperties = this.readFromFile();
        int n = objStoreListProperties.getObjStoreCount();
        for (int i = 0; i < n; ++i) {
            ObjStoreAttrs objStoreAttrs = objStoreListProperties.getObjStoreAttrs(i);
            this.createStore(objStoreAttrs);
        }
    }

    private ObjStoreListProperties readFromFile() throws UserPropertiesException {
        ObjStoreListProperties objStoreListProperties = new ObjStoreListProperties();
        objStoreListProperties.setFileName(this.fileName);
        objStoreListProperties.load();
        return objStoreListProperties;
    }

    public void writeObjStoresToFile() throws UserPropertiesException {
        Enumeration enumeration = this.objStores.elements();
        ObjStoreListProperties objStoreListProperties = new ObjStoreListProperties();
        while (enumeration.hasMoreElements()) {
            ObjStore objStore = (ObjStore)enumeration.nextElement();
            ObjStoreAttrs objStoreAttrs = objStore.getObjStoreAttrs();
            objStoreAttrs.prepareToTerminate();
            objStoreListProperties.addObjStoreAttrs(objStoreAttrs);
        }
        this.writeToFile(objStoreListProperties);
    }

    private void writeToFile(ObjStoreListProperties objStoreListProperties) throws UserPropertiesException {
        objStoreListProperties.setFileName(this.fileName);
        objStoreListProperties.save();
    }

    public void setFileName(String string) {
        this.fileName = string;
    }
}

