/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

import com.sun.messaging.jmq.util.DiagDictionaryEntry;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class DiagManager {
    public static final int VARIABLE = 1;
    public static final int CONSTANT = 2;
    public static final int COUNTER = 3;
    protected static final Vector regList = new Vector();
    protected static final HashMap diagClasses = new HashMap();
    protected static boolean allowAllReg = false;

    public static boolean register(Data data) {
        if (allowAllReg || diagClasses.get(data.getClass()) != null) {
            regList.add(data);
            return true;
        }
        return false;
    }

    public static void registerClass(String string) throws ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        Class<?> clazz = Class.forName(string);
        diagClasses.put(clazz, clazz);
    }

    public static void registerAllClasses(boolean bl) {
        allowAllReg = bl;
    }

    public static String allToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Diagnostics:");
        Enumeration enumeration = regList.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("\n");
            Data data = (Data)enumeration.nextElement();
            stringBuffer.append(DiagManager.toDiagString(data));
        }
        return stringBuffer.toString();
    }

    public static String toDiagString(Data data) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        data.update();
        String string = data.getPrefix();
        String string2 = data.getTitle();
        List list = data.getDictionary();
        if (list == null) {
            return "";
        }
        stringBuffer2.append("========== " + string2 + " (" + string + ") ========== \n");
        Iterator iterator = list.iterator();
        DiagDictionaryEntry diagDictionaryEntry = null;
        while (iterator.hasNext()) {
            String string3;
            diagDictionaryEntry = (DiagDictionaryEntry)iterator.next();
            String string4 = diagDictionaryEntry.name;
            int n2 = diagDictionaryEntry.type;
            try {
                Field field = data.getClass().getDeclaredField(string4);
                field.setAccessible(true);
                Class<?> clazz = field.getType();
                string3 = clazz == Long.TYPE ? String.valueOf(field.getLong(data)) : (clazz == Integer.TYPE ? String.valueOf(field.getInt(data)) : (clazz == Float.TYPE ? String.valueOf(field.getFloat(data)) : (clazz == Short.TYPE ? String.valueOf(field.getShort(data)) : (clazz == Byte.TYPE ? String.valueOf(field.getByte(data)) : (clazz == Boolean.TYPE ? String.valueOf(field.getBoolean(data)) : (clazz == Character.TYPE ? String.valueOf(field.getChar(data)) : (clazz == Double.TYPE ? String.valueOf(field.getDouble(data)) : field.get(data).toString())))))));
            }
            catch (Exception exception) {
                string3 = "Exception getting field value for '" + string4 + "': " + exception.toString();
            }
            stringBuffer.setLength(0);
            stringBuffer.append(string4 + "=" + string3);
            if (n > 0 && n + stringBuffer.length() > 78) {
                stringBuffer2.append("\n");
                n = stringBuffer.length();
            } else if (n == 0) {
                n += stringBuffer.length();
            } else {
                stringBuffer2.append(", ");
                n += stringBuffer.length();
            }
            n += 2;
            stringBuffer2.append(stringBuffer);
        }
        return stringBuffer2.toString();
    }

    public static void registerClasses(Properties properties, String string) throws ClassNotFoundException, IllegalAccessException {
        String string2 = properties.getProperty(string + "all");
        if (string2 != null && string2.equalsIgnoreCase("true")) {
            DiagManager.registerAllClasses(true);
            return;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string3;
            String string4 = (String)enumeration.nextElement();
            if (!string4.startsWith(string) || (string3 = string4.substring(string.length())) == null || string3.length() == 0 || !(string2 = properties.getProperty(string4)).equalsIgnoreCase("true")) continue;
            DiagManager.registerClass(string3);
        }
    }

    public static interface Data {
        public void update();

        public List getDictionary();

        public String getPrefix();

        public String getTitle();
    }
}

