/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.util.JMQXid;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Map;

public class PacketUtil {
    public static void dumpBody(PrintStream printStream, int n, InputStream inputStream, int n2, Hashtable hashtable) {
        printStream.print("   Message Body: " + n2 + " bytes ");
        if (inputStream == null) {
            printStream.println();
            printStream.flush();
            return;
        }
        switch (n) {
            case 24: 
            case 32: {
                SysMessageID sysMessageID = new SysMessageID();
                int n3 = n2 / 40;
                try {
                    Integer n4 = null;
                    if (hashtable != null) {
                        n4 = (Integer)hashtable.get("JMQBodyType");
                    }
                    DataInputStream dataInputStream = new DataInputStream(inputStream);
                    while (n3 > 0) {
                        if (n4 == null || n4 == 2) {
                            printStream.print("[" + dataInputStream.readLong() + ":");
                        } else {
                            printStream.print("[" + dataInputStream.readInt() + ":");
                        }
                        sysMessageID.readID(dataInputStream);
                        printStream.print(sysMessageID + "]");
                        --n3;
                    }
                    dataInputStream.close();
                }
                catch (Exception exception) {
                    printStream.println("Exception when reading packet body: " + exception);
                }
                break;
            }
            case 1: {
                int n5 = n2;
                if (n5 > 40) {
                    n5 = 40;
                }
                byte[] byArray = new byte[40];
                try {
                    inputStream.read(byArray);
                    printStream.print("[" + new String(byArray));
                    if (n5 < n2) {
                        printStream.print(". . .");
                    }
                    printStream.print("]");
                }
                catch (IOException iOException) {
                    printStream.println("Exception when reading packet body: " + iOException);
                }
                break;
            }
            case 3: 
            case 5: {
                try {
                    ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                    Object object = objectInputStream.readObject();
                    String string = object.toString();
                    if (string.length() > 512) {
                        printStream.println(string.substring(0, 512) + ". . .");
                    } else {
                        printStream.println(string);
                    }
                    objectInputStream.close();
                }
                catch (Exception exception) {
                    printStream.println("Exception when deserializing packet body: " + exception);
                }
                break;
            }
            case 12: {
                try {
                    String string = (String)hashtable.get("JMQAuthType");
                    printStream.print(string + ": ");
                    DataInputStream dataInputStream = new DataInputStream(inputStream);
                    if (string.equals("basic")) {
                        String string2 = dataInputStream.readUTF();
                        String string3 = dataInputStream.readUTF();
                        printStream.print("username=" + string2 + ", password=" + string3);
                        break;
                    }
                    if (string.equals("digest")) {
                        String string4 = dataInputStream.readUTF();
                        String string5 = dataInputStream.readUTF();
                        printStream.print("username=" + string4 + ", password=" + string5);
                        break;
                    }
                    printStream.print("Unknown authentication type");
                }
                catch (Exception exception) {
                    printStream.println("Exception when reading packet body: " + exception);
                }
                break;
            }
            case 61: {
                try {
                    Integer n6 = (Integer)hashtable.get("JMQQuantity");
                    int n7 = 0;
                    if (n6 != null) {
                        n7 = n6;
                    }
                    DataInputStream dataInputStream = new DataInputStream(inputStream);
                    while (n7 > 0) {
                        JMQXid jMQXid = JMQXid.read(dataInputStream);
                        printStream.println("[XID=" + jMQXid + "], ");
                        --n7;
                    }
                    break;
                }
                catch (IOException iOException) {
                    printStream.println("Could not decode XIDs: " + iOException);
                    break;
                }
            }
            case 73: {
                try {
                    ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                    Hashtable hashtable2 = (Hashtable)objectInputStream.readObject();
                    for (Map.Entry entry : hashtable2.entrySet()) {
                        Object k = entry.getKey();
                        Object v = entry.getValue();
                        if (v instanceof Hashtable) {
                            printStream.println("\tTable: " + k);
                            for (Map.Entry entry2 : ((Hashtable)v).entrySet()) {
                                Object k2 = entry2.getKey();
                                Object v2 = entry2.getValue();
                                printStream.println("\t\t" + k2 + "=" + v2);
                            }
                            continue;
                        }
                        printStream.println("\t" + k + "=" + v);
                    }
                    break;
                }
                catch (Exception exception) {
                    printStream.println("Could not decode INFO packet: " + exception);
                    break;
                }
            }
            case 44: 
            case 46: 
            case 48: 
            case 56: 
            case 58: 
            case 60: {
                try {
                    JMQXid jMQXid = JMQXid.read(new DataInputStream(inputStream));
                    printStream.println("[XID=" + jMQXid + "]");
                }
                catch (IOException iOException) {
                    printStream.println("Could not decode XID: " + iOException);
                }
                break;
            }
            case 79: {
                try {
                    ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                    Object object = objectInputStream.readObject();
                    printStream.println(object);
                    break;
                }
                catch (Exception exception) {
                    printStream.println("Could not decode verify body: " + exception);
                }
            }
        }
        printStream.println();
        printStream.flush();
    }
}

