/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.io.ReadOnlyPacket;
import com.sun.messaging.jmq.jmsclient.Consumer;
import com.sun.messaging.jmq.jmsclient.ConsumerReader;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.MessageConsumerImpl;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import javax.jms.JMSException;

public class SessionReader
extends ConsumerReader {
    private boolean debug = Debug.debug;
    protected SessionImpl session = null;
    protected volatile MessageImpl currentMessage = null;

    public SessionReader(SessionImpl sessionImpl) {
        super(sessionImpl.getConnection(), sessionImpl.getSessionQueue());
        this.session = sessionImpl;
        if (sessionImpl.acknowledgeMode == 3 && sessionImpl.dupsOkAckOnTimeout) {
            if (this.debug) {
                Debug.println("**** setting dupsOkAckTimeout: " + sessionImpl.dupsOkAckTimeout);
            }
            this.setTimeout(sessionImpl.dupsOkAckTimeout);
        }
        this.init();
    }

    protected void setCurrentMessage(MessageImpl messageImpl) {
        this.currentMessage = messageImpl;
    }

    protected void deliver(ReadOnlyPacket readOnlyPacket) throws IOException, JMSException {
        long l = 0L;
        Consumer consumer = null;
        this.currentMessage = this.getJMSMessage(readOnlyPacket);
        l = this.currentMessage.getInterestID();
        consumer = this.session.getMessageConsumer(new Long(l));
        if (consumer == null) {
            consumer = this.session.getBrowserConsumer(new Long(l));
        }
        if (consumer != null) {
            ((Consumer)consumer).onMessage(this.currentMessage);
        } else if (this.debug) {
            String string = AdministeredObject.cr.getKString("C4021");
            Debug.getPrintStream().println(string);
            readOnlyPacket.dump(Debug.getPrintStream());
        }
    }

    protected void deliver() throws IOException, JMSException {
        if (!this.sessionQueue.getIsClosed()) {
            if (this.session.dupsOkAckOnTimeout) {
                if (this.debug) {
                    Debug.println("*** Calling dups ok commit from timeout thread");
                }
                this.session.syncedDupsOkCommitAcknowledge();
            }
            if (this.sessionQueue.isListenerSetLate()) {
                this.onMessageToLateListeners();
                this.sessionQueue.setListenerLate(false);
            }
        }
    }

    protected void onMessageToLateListeners() throws JMSException {
        MessageConsumerImpl messageConsumerImpl = null;
        Enumeration enumeration = this.session.consumers.elements();
        while (enumeration.hasMoreElements()) {
            messageConsumerImpl = (MessageConsumerImpl)enumeration.nextElement();
            if (messageConsumerImpl.getSyncReadFlag()) continue;
            messageConsumerImpl.onMessageToListenerFromReceiveQueue();
        }
    }

    protected MessageImpl getJMSMessage(ReadOnlyPacket readOnlyPacket) throws JMSException {
        MessageImpl messageImpl = this.protocolHandler.getJMSMessage(readOnlyPacket);
        messageImpl.setSession(this.session);
        return messageImpl;
    }

    public void dump(PrintStream printStream) {
        printStream.println("------ SessionReader dump ------");
        printStream.println("Session ID: " + this.session.getSessionId());
        super.dump(printStream);
    }
}

