/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

import java.io.Serializable;
import javax.transaction.xa.Xid;

public class XidImpl
implements Xid,
Serializable {
    protected int formatId;
    protected byte[] branchQualifier = new byte[64];
    protected byte[] globalTxnId = new byte[64];
    protected int gtLength;
    protected int bqLength;
    public static final int MAXGTXNSIZE = 64;
    public static final int MAXBQUALSIZE = 64;
    public static final int NULL_XID = -1;
    public static final int OSICCR_XID = 0;
    private static final String hextab = "0123456789ABCDEF";

    public XidImpl() {
        this.formatId = -1;
        this.bqLength = 0;
        this.gtLength = 0;
    }

    public XidImpl(Xid xid) {
        this.copy(xid);
    }

    public void copy(Xid xid) {
        if (xid == null || xid.getFormatId() == -1) {
            this.formatId = -1;
            this.bqLength = 0;
            this.gtLength = 0;
            return;
        }
        this.formatId = xid.getFormatId();
        byte[] byArray = xid.getBranchQualifier();
        this.bqLength = byArray.length > 64 ? 64 : byArray.length;
        System.arraycopy(byArray, 0, this.branchQualifier, 0, this.bqLength);
        byArray = xid.getGlobalTransactionId();
        this.gtLength = byArray.length > 64 ? 64 : byArray.length;
        System.arraycopy(byArray, 0, this.globalTxnId, 0, this.gtLength);
    }

    public boolean equals(Object object) {
        return this.equals((Xid)object);
    }

    public boolean equals(Xid xid) {
        if (xid == null || this.formatId == -1) {
            return false;
        }
        return this.formatId == xid.getFormatId() && this.isEqualGlobalTxnId(xid.getGlobalTransactionId()) && this.isEqualBranchQualifier(xid.getBranchQualifier());
    }

    public int hashCode() {
        int n = 0;
        if (this.bqLength >= 2) {
            n += this.branchQualifier[this.bqLength - 1] << 8;
        }
        if (this.bqLength >= 1) {
            n += this.branchQualifier[0];
        }
        if (this.gtLength >= 2) {
            n += this.globalTxnId[this.gtLength - 1] << 24;
        }
        if (this.gtLength >= 1) {
            n += this.globalTxnId[0] << 16;
        }
        return n;
    }

    public String toLongString() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("{XID:hash(" + this.hashCode() + ")fmt(" + this.formatId + ")bq(");
        for (n2 = 0; n2 < this.bqLength; ++n2) {
            n = this.branchQualifier[n2] & 0xFF;
            stringBuffer.append("0x" + hextab.charAt(n / 16) + hextab.charAt(n & 0xF));
            if (n2 == this.bqLength - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")gt(");
        for (n2 = 0; n2 < this.gtLength; ++n2) {
            n = this.globalTxnId[n2] & 0xFF;
            stringBuffer.append("0x" + hextab.charAt(n / 16) + hextab.charAt(n & 0xF));
            if (n2 == this.gtLength - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")}");
        return new String(stringBuffer);
    }

    public String toString() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer(256);
        if (this.formatId == -1) {
            return "NULL_XID";
        }
        for (n2 = 0; n2 < this.bqLength; ++n2) {
            n = this.branchQualifier[n2] & 0xFF;
            stringBuffer.append(hextab.charAt(n / 16));
            stringBuffer.append(hextab.charAt(n & 0xF));
        }
        for (n2 = 0; n2 < this.gtLength; ++n2) {
            n = this.globalTxnId[n2] & 0xFF;
            stringBuffer.append(hextab.charAt(n / 16));
            stringBuffer.append(hextab.charAt(n & 0xF));
        }
        return new String(stringBuffer);
    }

    public byte[] getBranchQualifier() {
        byte[] byArray = new byte[this.bqLength];
        System.arraycopy(this.branchQualifier, 0, byArray, 0, this.bqLength);
        return byArray;
    }

    public void setBranchQualifier(byte[] byArray) {
        this.bqLength = byArray.length > 64 ? 64 : byArray.length;
        System.arraycopy(byArray, 0, this.branchQualifier, 0, this.bqLength);
    }

    public int getFormatId() {
        return this.formatId;
    }

    public void setFormatId(int n) {
        this.formatId = n;
    }

    public boolean isEqualBranchQualifier(byte[] byArray) {
        if (byArray == null) {
            return this.bqLength == 0;
        }
        if (byArray.length != this.bqLength) {
            return false;
        }
        for (int i = 0; i < this.bqLength; ++i) {
            if (byArray[i] == this.branchQualifier[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isEqualGlobalTxnId(byte[] byArray) {
        if (byArray == null) {
            return this.gtLength == 0;
        }
        if (byArray.length != this.gtLength) {
            return false;
        }
        for (int i = 0; i < this.gtLength; ++i) {
            if (byArray[i] == this.globalTxnId[i]) continue;
            return false;
        }
        return true;
    }

    public byte[] getGlobalTransactionId() {
        byte[] byArray = new byte[this.gtLength];
        System.arraycopy(this.globalTxnId, 0, byArray, 0, this.gtLength);
        return byArray;
    }

    public void setGlobalTransactionId(byte[] byArray) {
        this.gtLength = byArray.length > 64 ? 64 : byArray.length;
        System.arraycopy(byArray, 0, this.globalTxnId, 0, this.gtLength);
    }
}

