/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console.util;

import com.sun.messaging.jmq.admin.apps.console.util.IntegerField;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.util.Globals;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class TimeField
extends JPanel {
    public static final int MILLISECONDS = 0;
    public static final int SECONDS = 1;
    public static final int MINUTES = 2;
    public static final int HOURS = 3;
    public static final int DAYS = 4;
    private int msecPos = 0;
    private int secPos = 1;
    private int minPos = 2;
    private int hrPos = 3;
    private int dayPos = 4;
    private boolean showMillis = false;
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();
    private IntegerField intF;
    private JComboBox unitCB;

    public TimeField(long l, String string) {
        this(l, string, 0);
    }

    public TimeField(long l, int n) {
        this(l, null, n);
    }

    public TimeField(long l, String string, int n) {
        this(l, string, n, false);
    }

    public TimeField(long l, String string, int n, boolean bl) {
        this.showMillis = bl;
        this.initGui(l, string, n);
        this.setUnit(1);
    }

    public void addActionListener(ActionListener actionListener) {
        this.intF.addActionListener(actionListener);
    }

    public void setText(String string) {
        this.intF.setText(string);
    }

    public String getText() {
        return this.intF.getText();
    }

    public void setEnabled(boolean bl) {
        this.intF.setEnabled(bl);
        this.unitCB.setEnabled(bl);
    }

    public void setUnit(int n) {
        int n2 = this.secPos;
        switch (n) {
            case 0: {
                n2 = this.msecPos;
                break;
            }
            case 1: {
                n2 = this.secPos;
                break;
            }
            case 2: {
                n2 = this.minPos;
                break;
            }
            case 3: {
                n2 = this.hrPos;
                break;
            }
            case 4: {
                n2 = this.dayPos;
            }
        }
        if (n2 < 0 || n2 > this.dayPos) {
            return;
        }
        this.unitCB.setSelectedIndex(n2);
    }

    public long getValue() {
        long l;
        String string = this.intF.getText();
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {
            return -1L;
        }
        int n = this.unitCB.getSelectedIndex();
        if (this.showMillis) {
            if (n == this.msecPos) {
                return l;
            }
            if (n == this.secPos) {
                return l * 1000L;
            }
            if (n == this.minPos) {
                return l * 1000L * 60L;
            }
            if (n == this.hrPos) {
                return l * 1000L * 60L * 60L;
            }
            if (n == this.dayPos) {
                return l * 1000L * 60L * 60L * 24L;
            }
        } else {
            if (n == this.secPos) {
                return l * 1000L;
            }
            if (n == this.minPos) {
                return l * 1000L * 60L;
            }
            if (n == this.hrPos) {
                return l * 1000L * 60L * 60L;
            }
            if (n == this.dayPos) {
                return l * 1000L * 60L * 60L * 24L;
            }
        }
        return -1L;
    }

    private void initGui(long l, String string, int n) {
        String[] stringArray;
        this.intF = new IntegerField(0L, l, string, n);
        if (this.showMillis) {
            this.msecPos = 0;
            this.secPos = 1;
            this.minPos = 2;
            this.hrPos = 3;
            this.dayPos = 4;
            stringArray = new String[5];
            stringArray[this.msecPos] = acr.getString("A1226");
        } else {
            this.secPos = 0;
            this.minPos = 1;
            this.hrPos = 2;
            this.dayPos = 3;
            stringArray = new String[4];
        }
        stringArray[this.secPos] = acr.getString("A1227");
        stringArray[this.minPos] = acr.getString("A1228");
        stringArray[this.hrPos] = acr.getString("A1229");
        stringArray[this.dayPos] = acr.getString("A1230");
        this.unitCB = new JComboBox<String>(stringArray);
        this.setLayout(new BorderLayout());
        this.add((Component)this.intF, "Center");
        this.add((Component)this.unitCB, "East");
    }
}

