/*
 * Decompiled with CFR 0.152.
 */
package com.qbrowser.property;

import com.qbrowser.property.Property;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.ResourceBundle;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.swing.table.DefaultTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderPropertyTable
extends DefaultTableModel {
    public static ResourceBundle resources = ResourceBundle.getBundle("com.qbrowser.resourcebase");
    public static final int DEFAULT_JMSPRIORITY = 4;
    final String[] columnNames = new String[]{resources.getString("qkey.proptable.jmsheader.key"), resources.getString("qkey.proptable.jmsheader.prop_value")};
    LinkedList list = null;
    ArrayList type_selection = null;

    public HeaderPropertyTable() {
        this.init();
        this.add_one_row(new Property());
    }

    public HeaderPropertyTable(int number_of_initial_rows) {
        this.init();
        for (int i = 0; i < number_of_initial_rows; ++i) {
            this.add_one_row(new Property());
        }
    }

    @Override
    public int getRowCount() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Object.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return true;
    }

    public Class<?> getCellClassAt(int row, int column) {
        return this.getColumnClass(column);
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (this.list == null) {
            return;
        }
        if (this.list.size() < row) {
            return;
        }
        Property p = (Property)this.list.get(row);
        if (p == null) {
            return;
        }
        try {
            switch (column) {
                case 0: {
                    if (value instanceof String) {
                        p.setKey((String)value);
                    }
                    return;
                }
                case 1: {
                    p.setProperty_value(value);
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.list == null) {
            return null;
        }
        Property p = (Property)this.list.get(row);
        if (p == null) {
            return "";
        }
        try {
            switch (column) {
                case 0: {
                    return p.getKey();
                }
                case 1: {
                    return p.getProperty_value();
                }
            }
            return "Bad column value: " + column;
        }
        catch (Exception e) {
            return "Error: " + e;
        }
    }

    public int load(Enumeration e) {
        if (e == null) {
            return 0;
        }
        this.list = new LinkedList();
        while (e.hasMoreElements()) {
            this.list.add(e.nextElement());
        }
        this.fireTableDataChanged();
        return this.list.size();
    }

    public int load(Message message) {
        if (message == null) {
            return 0;
        }
        this.list = new LinkedList();
        try {
            int jpri;
            String jcorid;
            long jexp = message.getJMSExpiration();
            if (jexp != 0L) {
                Property jexp_prop = new Property();
                jexp_prop.setKey("JMSExpiration");
                jexp_prop.setProperty_type("Long");
                jexp_prop.setProperty_value(jexp);
                this.list.add(jexp_prop);
            }
            Destination d = message.getJMSReplyTo();
            String s = null;
            if (d != null) {
                s = d instanceof Queue ? ((Queue)d).getQueueName() + " : Queue" : ((Topic)d).getTopicName() + " : Topic";
            }
            if (s != null) {
                Property jrepto = new Property();
                jrepto.setKey("JMSReplyTo");
                jrepto.setProperty_type("String");
                jrepto.setProperty_value(s);
                this.list.add(jrepto);
            }
            if ((jcorid = message.getJMSCorrelationID()) != null && jcorid.length() > 0) {
                Property jcoridp = new Property();
                jcoridp.setKey("JMSCorrelationID");
                jcoridp.setProperty_type("String");
                jcoridp.setProperty_value(jcorid);
                this.list.add(jcoridp);
            }
            if ((jpri = message.getJMSPriority()) != 4) {
                Property jprip = new Property();
                jprip.setKey("JMSPriority");
                jprip.setProperty_type("Int");
                jprip.setProperty_value(jpri);
                this.list.add(jprip);
            }
            this.fireTableDataChanged();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return this.list.size();
    }

    public int loadAllProperties(Message message) {
        if (message == null) {
            return 0;
        }
        this.list = new LinkedList();
        try {
            String msgid = message.getJMSMessageID();
            Property msgidp = new Property();
            msgidp.setKey("JMSMessageID");
            msgidp.setProperty_type("String");
            msgidp.setProperty_value(msgid);
            this.list.add(msgidp);
            Destination d1 = message.getJMSDestination();
            String s1 = null;
            s1 = d1 != null ? (d1 instanceof Queue ? ((Queue)d1).getQueueName() + " : Queue" : ((Topic)d1).getTopicName() + " : Topic") : "";
            Property jdestp = new Property();
            jdestp.setKey("JMSDestination");
            jdestp.setProperty_type("String");
            jdestp.setProperty_value(s1);
            this.list.add(jdestp);
            Destination d = message.getJMSReplyTo();
            String s = null;
            s = d != null ? (d instanceof Queue ? ((Queue)d).getQueueName() + " : Queue" : ((Topic)d).getTopicName() + " : Topic") : "";
            Property jrepto = new Property();
            jrepto.setKey("JMSReplyTo");
            jrepto.setProperty_type("String");
            jrepto.setProperty_value(s);
            this.list.add(jrepto);
            String jcorid = message.getJMSCorrelationID();
            Property jcoridp = new Property();
            jcoridp.setKey("JMSCorrelationID");
            jcoridp.setProperty_type("String");
            jcoridp.setProperty_value(jcorid);
            this.list.add(jcoridp);
            int delivermode = message.getJMSDeliveryMode();
            Property delivermodep = new Property();
            delivermodep.setKey("JMSDeliverMode");
            delivermodep.setProperty_type("Int");
            delivermodep.setProperty_value(delivermode);
            this.list.add(delivermodep);
            int jpri = message.getJMSPriority();
            Property jprip = new Property();
            jprip.setKey("JMSPriority");
            jprip.setProperty_type("Int");
            jprip.setProperty_value(jpri);
            this.list.add(jprip);
            long jexp = message.getJMSExpiration();
            Property jexp_prop = new Property();
            jexp_prop.setKey("JMSExpiration");
            jexp_prop.setProperty_type("Long");
            jexp_prop.setProperty_value(jexp);
            this.list.add(jexp_prop);
            String jtype = message.getJMSType();
            Property jtypep = new Property();
            jtypep.setKey("JMSType");
            jtypep.setProperty_type("String");
            jtypep.setProperty_value(jtype);
            this.list.add(jtypep);
            boolean redelivered = message.getJMSRedelivered();
            Property redvd = new Property();
            redvd.setKey("JMSRedelivered");
            redvd.setProperty_type("Boolean");
            redvd.setProperty_value(redelivered);
            this.list.add(redvd);
            long jtimestamp = message.getJMSTimestamp();
            Property jtimestampp = new Property();
            jtimestampp.setKey("JMSTimestamp");
            jtimestampp.setProperty_type("Long");
            jtimestampp.setProperty_value(jtimestamp);
            this.list.add(jtimestampp);
            this.fireTableDataChanged();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return this.list.size();
    }

    void init() {
        this.list = new LinkedList();
    }

    public void add_one_row(Property value) {
        this.list.add(value);
        this.fireTableDataChanged();
    }

    public void add_one_empty_row() {
        this.list.add(new Property());
        this.fireTableDataChanged();
    }

    public void deletePropertyAtRow(int row) {
        if (this.list == null) {
            return;
        }
        this.list.remove(row);
        this.fireTableDataChanged();
    }

    public Property getPropertyAtRow(int row) {
        if (this.list == null) {
            return null;
        }
        return (Property)this.list.get(row);
    }
}

