/*
 * Decompiled with CFR 0.152.
 */
package com.qbrowser.property;

import com.qbrowser.property.MapMessageInputProperty;
import java.awt.BorderLayout;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.ResourceBundle;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapMessageInputTable
extends DefaultTableModel {
    public static ResourceBundle resources = ResourceBundle.getBundle("com.qbrowser.resourcebase");
    JDialog filechooseDialog = null;
    JPanel filechoosemsgPanel = null;
    JPanel temppanel = null;
    JTextField filechoose_file_path = null;
    String download_target_key = null;
    MapMessage download_target_message = null;
    JDialog msgDialog = null;
    JButton msgconfirmbutton = null;
    JPanel oya = null;
    private Message innermessage = null;
    final String[] columnNames = new String[]{resources.getString("qkey.proptable.header.key"), resources.getString("qkey.proptable.header.prop_type"), resources.getString("qkey.proptable.header.prop_value"), resources.getString("qkey.proptable.header.filechoose")};
    LinkedList list = null;
    ArrayList type_selection = null;

    public void setOya(JPanel value) {
        this.oya = value;
    }

    public MapMessageInputTable() {
        this.init();
        this.add_one_row(new MapMessageInputProperty());
    }

    public MapMessageInputProperty createMapMessageInputProperty() {
        MapMessageInputProperty newmm = new MapMessageInputProperty();
        newmm.setProperty_type_combobox(this.getMapMessagePropTypeComboBox());
        return newmm;
    }

    public MapMessageInputTable(int number_of_initial_rows) {
        this.init();
        for (int i = 0; i < number_of_initial_rows; ++i) {
            MapMessageInputProperty newmm = new MapMessageInputProperty();
            newmm.setProperty_type_combobox(this.getMapMessagePropTypeComboBox());
            this.add_one_row(newmm);
        }
    }

    public JComboBox getTypeComboBoxAt(int row) {
        MapMessageInputProperty ip = this.getPropertyAtRow(row);
        return (JComboBox)ip.getType_combo_box();
    }

    public JTextArea getStringTextAreaAt(int row) {
        MapMessageInputProperty ip = this.getPropertyAtRow(row);
        Object obj = ip.getProperty_value();
        if (obj instanceof JTextArea) {
            return (JTextArea)obj;
        }
        return null;
    }

    public JButton getStringButtonAt(int row) {
        MapMessageInputProperty ip = this.getPropertyAtRow(row);
        Object obj = ip.getFilechoose_button();
        if (obj instanceof JButton && ip.getType_combo_box() != null && ((String)((JComboBox)ip.getType_combo_box()).getSelectedItem()).equals("String")) {
            return (JButton)obj;
        }
        return null;
    }

    public void setItemListenerInComboBoxAt(int row, ItemListener lsnr) {
        JComboBox jcb = this.getTypeComboBoxAt(row);
        if (jcb != null) {
            jcb.addItemListener(lsnr);
        }
    }

    public void setMouseListenerInTextAreaAt(int row, MouseListener lsnr) {
        JTextArea jta = this.getStringTextAreaAt(row);
        if (jta != null) {
            jta.addMouseListener(lsnr);
        }
    }

    public void setActionListenerInButtonAt(int row, ActionListener lsnr) {
        JButton jbt = this.getStringButtonAt(row);
        if (jbt != null) {
            jbt.addActionListener(lsnr);
        }
    }

    public int findRowNumberFromJComboBox(JComboBox src) {
        if (this.list == null) {
            return -1;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            MapMessageInputProperty ip = (MapMessageInputProperty)this.list.get(i);
            if (!src.equals(ip.getType_combo_box())) continue;
            return i;
        }
        return -1;
    }

    public int findRowNumberFromJTextArea(JTextArea src) {
        if (this.list == null) {
            return -1;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            MapMessageInputProperty ip = (MapMessageInputProperty)this.list.get(i);
            if (!src.equals(ip.getProperty_value())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getRowCount() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Object.class;
            }
            case 2: {
                return Object.class;
            }
            case 3: {
                return Object.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        Object obj = this.getValueAt(row, column);
        if (obj instanceof JButton) {
            return true;
        }
        if (column == 2) {
            if (obj instanceof String) {
                String stobj = (String)obj;
                return !stobj.equals(resources.getString("qkey.msg.msg222"));
            }
            return true;
        }
        return column != 3;
    }

    public Class<?> getCellClassAt(int row, int column) {
        return this.getColumnClass(column);
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (this.list == null) {
            return;
        }
        if (this.list.size() < row) {
            return;
        }
        MapMessageInputProperty p = (MapMessageInputProperty)this.list.get(row);
        if (p == null) {
            return;
        }
        try {
            switch (column) {
                case 0: {
                    if (value instanceof String) {
                        p.setKey((String)value);
                    }
                    return;
                }
                case 1: {
                    if (value instanceof JComboBox) {
                        p.setProperty_type((String)((JComboBox)value).getSelectedItem());
                    } else if (value instanceof String && p.validated_type != 10) {
                        p.setProperty_type((String)value);
                    }
                    return;
                }
                case 2: {
                    p.setProperty_value(value);
                    return;
                }
                case 3: {
                    p.setFilechoose_button(value);
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return;
        }
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.list == null) {
            return null;
        }
        MapMessageInputProperty p = (MapMessageInputProperty)this.list.get(row);
        if (p == null) {
            return "";
        }
        try {
            switch (column) {
                case 0: {
                    return p.getKey();
                }
                case 1: {
                    return p.getType_combo_box();
                }
                case 2: {
                    if (p.validated_type == 10) {
                        return resources.getString("qkey.msg.msg222");
                    }
                    return p.getProperty_value();
                }
                case 3: {
                    Object no4 = p.getFilechoose_button();
                    return no4;
                }
            }
            return "Bad column value: " + column;
        }
        catch (Exception e) {
            return "Error: " + e;
        }
    }

    public int load(Enumeration e) {
        if (e == null) {
            return 0;
        }
        this.list = new LinkedList();
        while (e.hasMoreElements()) {
            this.list.add(e.nextElement());
        }
        this.fireTableDataChanged();
        return this.list.size();
    }

    public int load(MapMessage msg) {
        if (msg == null) {
            return 0;
        }
        this.list = new LinkedList();
        try {
            Enumeration enu = msg.getMapNames();
            while (enu.hasMoreElements()) {
                JComboBox jcbi;
                MapMessageInputProperty ap;
                String name = enu.nextElement().toString();
                Object obj = msg.getObject(name);
                if (obj instanceof String) {
                    ap = new MapMessageInputProperty();
                    ap.setKey(name);
                    jcbi = this.getMapMessagePropTypeComboBox();
                    jcbi.setSelectedItem("String");
                    ap.setProperty_type_combobox(jcbi);
                    JTextArea jobj = new JTextArea(1, 10);
                    jobj.setText((String)obj);
                    jobj.setToolTipText(resources.getString("qkey.msg.msg230"));
                    ap.setProperty_value(jobj);
                    JButton jbt = new JButton(resources.getString("qkey.msg.msg208"));
                    ap.setFilechoose_button(jbt);
                    this.list.add(ap);
                    continue;
                }
                if (obj instanceof Integer) {
                    ap = new MapMessageInputProperty();
                    ap.setKey(name);
                    jcbi = this.getMapMessagePropTypeComboBox();
                    jcbi.setSelectedItem("Int");
                    ap.setProperty_type_combobox(jcbi);
                    ap.setProperty_value(obj);
                    this.list.add(ap);
                    continue;
                }
                if (obj instanceof Boolean) {
                    ap = new MapMessageInputProperty();
                    ap.setKey(name);
                    jcbi = this.getMapMessagePropTypeComboBox();
                    jcbi.setSelectedItem("Boolean");
                    ap.setProperty_type_combobox(jcbi);
                    ap.setProperty_value(obj);
                    this.list.add(ap);
                    continue;
                }
                if (obj instanceof Byte) {
                    ap = new MapMessageInputProperty();
                    ap.setKey(name);
                    jcbi = this.getMapMessagePropTypeComboBox();
                    jcbi.setSelectedItem("Byte");
                    ap.setProperty_type_combobox(jcbi);
                    ap.setProperty_value(obj);
                    this.list.add(ap);
                    continue;
                }
                if (obj instanceof Double) {
                    ap = new MapMessageInputProperty();
                    ap.setKey(name);
                    jcbi = this.getMapMessagePropTypeComboBox();
                    jcbi.setSelectedItem("Double");
                    ap.setProperty_type_combobox(jcbi);
                    ap.setProperty_value(obj);
                    this.list.add(ap);
                    continue;
                }
                if (obj instanceof Float) {
                    ap = new MapMessageInputProperty();
                    ap.setKey(name);
                    jcbi = this.getMapMessagePropTypeComboBox();
                    jcbi.setSelectedItem("Float");
                    ap.setProperty_type_combobox(jcbi);
                    ap.setProperty_value(obj);
                    this.list.add(ap);
                    continue;
                }
                if (obj instanceof Long) {
                    ap = new MapMessageInputProperty();
                    ap.setKey(name);
                    jcbi = this.getMapMessagePropTypeComboBox();
                    jcbi.setSelectedItem("Long");
                    ap.setProperty_type_combobox(jcbi);
                    ap.setProperty_value(obj);
                    this.list.add(ap);
                    continue;
                }
                if (obj instanceof Short) {
                    ap = new MapMessageInputProperty();
                    ap.setKey(name);
                    jcbi = this.getMapMessagePropTypeComboBox();
                    jcbi.setSelectedItem("Short");
                    ap.setProperty_type_combobox(jcbi);
                    ap.setProperty_value(obj);
                    this.list.add(ap);
                    continue;
                }
                if (!(obj instanceof byte[])) continue;
                ap = new MapMessageInputProperty();
                ap.setKey(name);
                jcbi = this.getMapMessagePropTypeComboBox();
                jcbi.setSelectedItem("Bytes");
                ap.setProperty_type_combobox(jcbi);
                ap.setProperty_type("Pass_through");
                ap.validated_type = 10;
                ap.setProperty_value(obj);
                this.list.add(ap);
            }
        }
        catch (JMSException ex) {
            ex.printStackTrace();
        }
        this.fireTableDataChanged();
        return this.list.size();
    }

    void init() {
        this.list = new LinkedList();
    }

    public void add_one_row(MapMessageInputProperty value) {
        this.list.add(value);
        this.fireTableDataChanged();
    }

    public void add_one_empty_row() {
        this.list.add(new MapMessageInputProperty());
        this.fireTableDataChanged();
    }

    public void deletePropertyAtRow(int row) {
        if (this.list == null) {
            return;
        }
        this.list.remove(row);
        this.fireTableDataChanged();
    }

    public MapMessageInputProperty getPropertyAtRow(int row) {
        if (this.list == null) {
            return null;
        }
        return (MapMessageInputProperty)this.list.get(row);
    }

    public JDialog popupMessageDialog(String title, TextArea ta, ImageIcon icon) {
        if (this.msgDialog != null && this.msgDialog.isShowing()) {
            this.msgDialog.dispose();
        }
        this.msgDialog = new JDialog();
        this.msgDialog.setIconImage(icon.getImage());
        this.msgDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
            }
        });
        this.msgDialog.setTitle(title);
        this.msgDialog.setLocation(250, 150);
        JPanel mainmsg = new JPanel();
        mainmsg.add(ta);
        this.msgDialog.getContentPane().setLayout(new BorderLayout());
        this.msgconfirmbutton = new JButton("OK");
        this.msgconfirmbutton.addActionListener(new MsgConfirmedListener());
        this.msgDialog.getContentPane().add("North", mainmsg);
        this.msgDialog.getContentPane().add("South", this.msgconfirmbutton);
        this.msgDialog.pack();
        this.msgDialog.setLocationRelativeTo(this.oya);
        this.msgDialog.setVisible(true);
        return this.msgDialog;
    }

    private void initMapMessagePropTypeComboBox(JComboBox value) {
        value.addItem("Int");
        value.addItem("String");
        value.addItem("Boolean");
        value.addItem("Byte");
        value.addItem("Bytes");
        value.addItem("Double");
        value.addItem("Float");
        value.addItem("Long");
        value.addItem("Short");
        value.setSelectedIndex(0);
    }

    private JComboBox getMapMessagePropTypeComboBox() {
        JComboBox jcb = new JComboBox();
        this.initMapMessagePropTypeComboBox(jcb);
        return jcb;
    }

    class MsgConfirmedListener
    implements ActionListener {
        MsgConfirmedListener() {
        }

        public void actionPerformed(ActionEvent e) {
            MapMessageInputTable.this.msgDialog.setVisible(false);
        }
    }
}

