/*
 * Decompiled with CFR 0.152.
 */
package com.qbrowser.property;

import com.qbrowser.property.InputProperty;
import com.qbrowser.property.PropertyUtil;
import java.awt.event.ItemListener;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.ResourceBundle;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.swing.JComboBox;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyInputTable
extends DefaultTableModel {
    public static ResourceBundle resources = ResourceBundle.getBundle("com.qbrowser.resourcebase");
    final String[] columnNames = new String[]{resources.getString("qkey.proptable.header.key"), resources.getString("qkey.proptable.header.prop_type"), resources.getString("qkey.proptable.header.prop_value")};
    LinkedList list = null;
    ArrayList type_selection = null;

    public PropertyInputTable() {
        this.init();
    }

    public PropertyInputTable(int number_of_initial_rows) {
        this.init();
        for (int i = 0; i < number_of_initial_rows; ++i) {
            InputProperty anewprop = new InputProperty();
            JComboBox jcb = PropertyUtil.getUserPropTypeComboBox();
            anewprop.setType_combo_box(jcb);
            this.add_one_row(anewprop);
        }
    }

    public int findRowNumberFromJComboBox(JComboBox src) {
        if (this.list == null) {
            return -1;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            InputProperty ip = (InputProperty)this.list.get(i);
            if (!src.equals(ip.getType_combo_box())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getRowCount() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Object.class;
            }
            case 2: {
                return Object.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return true;
    }

    public Class<?> getCellClassAt(int row, int column) {
        return this.getColumnClass(column);
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (this.list == null) {
            return;
        }
        if (this.list.size() < row) {
            return;
        }
        InputProperty p = (InputProperty)this.list.get(row);
        if (p == null) {
            return;
        }
        try {
            switch (column) {
                case 0: {
                    if (value instanceof String) {
                        p.setKey((String)value);
                    }
                    return;
                }
                case 1: {
                    if (value instanceof JComboBox) {
                        p.setProperty_type((String)((JComboBox)value).getSelectedItem());
                    } else if (value instanceof String) {
                        p.setProperty_type((String)value);
                    }
                    return;
                }
                case 2: {
                    p.setProperty_value(value);
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return;
        }
    }

    public int findRowNumberFromJTextArea(JTextArea src) {
        if (this.list == null) {
            return -1;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            InputProperty ip = (InputProperty)this.list.get(i);
            if (!src.equals(ip.getProperty_value())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.list == null) {
            return null;
        }
        if (this.list.size() < row) {
            return null;
        }
        InputProperty p = (InputProperty)this.list.get(row);
        if (p == null) {
            return "";
        }
        try {
            switch (column) {
                case 0: {
                    return p.getKey();
                }
                case 1: {
                    return p.getType_combo_box();
                }
                case 2: {
                    return p.getProperty_value();
                }
            }
            return "Bad column value: " + column;
        }
        catch (Exception e) {
            return "Error: " + e;
        }
    }

    public int load(Enumeration e) {
        if (e == null) {
            return 0;
        }
        this.list = new LinkedList();
        while (e.hasMoreElements()) {
            this.list.add(e.nextElement());
        }
        this.fireTableDataChanged();
        return this.list.size();
    }

    public int load(Message message) {
        if (message == null) {
            return 0;
        }
        this.list = new LinkedList();
        int count = -1;
        try {
            Enumeration enu = message.getPropertyNames();
            while (enu.hasMoreElements()) {
                ++count;
                String name = enu.nextElement().toString();
                Object propvalueobj = message.getObjectProperty(name);
                InputProperty prop = new InputProperty();
                prop.setKey(name);
                if (propvalueobj instanceof String) {
                    JTextArea jobj = new JTextArea(1, 10);
                    jobj.setText((String)propvalueobj);
                    jobj.setToolTipText(resources.getString("qkey.msg.msg230"));
                    prop.setProperty_value(jobj);
                } else {
                    prop.setProperty_value(propvalueobj);
                }
                prop.autoComplementTypeNme();
                JComboBox jcb = PropertyUtil.getUserPropTypeComboBox();
                jcb.setSelectedItem(prop.getProperty_type());
                prop.setType_combo_box(jcb);
                this.list.add(prop);
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        this.fireTableDataChanged();
        return this.list.size();
    }

    void init() {
        this.list = new LinkedList();
    }

    public JTextArea getStringTextAreaAt(int row) {
        InputProperty ip = this.getPropertyAtRow(row);
        Object obj = ip.getProperty_value();
        if (obj instanceof JTextArea) {
            return (JTextArea)obj;
        }
        return null;
    }

    public void setMouseListenerInTextAreaAt(int row, MouseListener lsnr) {
        JTextArea jta = this.getStringTextAreaAt(row);
        if (jta != null) {
            jta.addMouseListener(lsnr);
        }
    }

    public void add_one_row(InputProperty value) {
        this.list.add(value);
        this.fireTableDataChanged();
    }

    public void add_one_empty_row() {
        InputProperty ip = new InputProperty();
        JComboBox jcb = PropertyUtil.getUserPropTypeComboBox();
        ip.setType_combo_box(jcb);
        this.list.add(ip);
        this.fireTableDataChanged();
    }

    public JComboBox getTypeComboBoxAt(int row) {
        InputProperty ip = this.getPropertyAtRow(row);
        return (JComboBox)ip.getType_combo_box();
    }

    public void setItemListenerInComboBoxAt(int row, ItemListener lsnr) {
        JComboBox jcb = this.getTypeComboBoxAt(row);
        if (jcb != null) {
            jcb.addItemListener(lsnr);
        }
    }

    public void deletePropertyAtRow(int row) {
        if (this.list == null) {
            return;
        }
        this.list.remove(row);
        this.fireTableDataChanged();
    }

    public InputProperty getPropertyAtRow(int row) {
        if (this.list == null) {
            return null;
        }
        if (this.list.size() < row) {
            return null;
        }
        return (InputProperty)this.list.get(row);
    }
}

