/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import com.sun.messaging.jmq.io.JMQByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

public class PacketVariableHeader {
    protected static CharsetDecoder decoder = null;
    protected static CharsetEncoder encoder = null;
    protected static Charset charset = null;
    protected ByteBuffer buffer = null;
    protected boolean bufferDirty = false;
    protected boolean bufferParsed = false;
    protected long transactionID = 0L;
    protected long producerID = 0L;
    protected String[] stringItems = new String[10];

    public PacketVariableHeader() {
        this.reset();
    }

    public synchronized void setBytes(ByteBuffer byteBuffer) {
        this.reset();
        if (byteBuffer == null) {
            this.buffer = null;
        } else {
            this.buffer = byteBuffer;
            this.buffer.rewind();
        }
        this.bufferParsed = false;
        this.bufferDirty = false;
    }

    public synchronized ByteBuffer getBytes() throws IOException {
        if (this.bufferDirty) {
            this.updateBuffer();
        }
        if (this.buffer == null) {
            return null;
        }
        this.buffer.rewind();
        return this.buffer;
    }

    public synchronized ByteBuffer getBytes2() throws IOException {
        if (this.bufferDirty || this.buffer == null) {
            this.updateBuffer();
        }
        return this.getBytes();
    }

    public synchronized String getStringField(int n) {
        if (!this.bufferParsed) {
            this.parseBuffer();
        }
        if (n < 10) {
            return this.stringItems[n];
        }
        return null;
    }

    public synchronized long getLongField(int n) {
        if (!this.bufferParsed) {
            this.parseBuffer();
        }
        switch (n) {
            case 8: {
                return this.transactionID;
            }
            case 9: {
                return this.producerID;
            }
        }
        return 0L;
    }

    public synchronized void setStringField(int n, String string) {
        if (!this.bufferParsed) {
            this.parseBuffer();
        }
        if (n < 10) {
            this.stringItems[n] = string;
            this.bufferDirty = true;
        }
    }

    public synchronized void setLongField(int n, long l) {
        if (!this.bufferParsed) {
            this.parseBuffer();
        }
        switch (n) {
            case 8: {
                this.transactionID = l;
                this.bufferDirty = true;
                break;
            }
            case 9: {
                this.producerID = l;
                this.bufferDirty = true;
                break;
            }
        }
    }

    protected void reset() {
        for (int i = 0; i < 10; ++i) {
            this.stringItems[i] = null;
        }
        this.transactionID = 0L;
        this.producerID = 0L;
        if (this.buffer != null) {
            this.buffer.clear();
        }
        this.bufferDirty = false;
        this.bufferParsed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parseBuffer() {
        short s = 0;
        if (this.buffer == null) {
            this.bufferParsed = true;
            return;
        }
        this.buffer.rewind();
        short s2 = this.buffer.getShort();
        while (s2 != 0) {
            switch (s2) {
                case 8: {
                    s = this.buffer.getShort();
                    this.transactionID = this.buffer.getLong();
                    break;
                }
                case 9: {
                    s = this.buffer.getShort();
                    this.producerID = this.buffer.getLong();
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    s = this.buffer.getShort();
                    int n = this.buffer.limit();
                    int n2 = this.buffer.position();
                    this.buffer.limit(n2 + s);
                    try {
                        CharsetDecoder charsetDecoder = decoder;
                        synchronized (charsetDecoder) {
                            this.stringItems[s2] = decoder.decode(this.buffer).toString();
                        }
                    }
                    catch (CharacterCodingException characterCodingException) {
                        System.out.println("Could not decode string " + characterCodingException);
                    }
                    this.buffer.limit(n);
                    break;
                }
                default: {
                    s = this.buffer.getShort();
                    this.buffer.position(this.buffer.position() + s);
                }
            }
            s2 = this.buffer.getShort();
        }
        this.bufferParsed = true;
    }

    private void updateBuffer() throws IOException {
        int n;
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[512];
        JMQByteArrayOutputStream jMQByteArrayOutputStream = new JMQByteArrayOutputStream(byArray2);
        DataOutputStream dataOutputStream = new DataOutputStream(jMQByteArrayOutputStream);
        if (this.transactionID != 0L) {
            this.writeLong(dataOutputStream, 8, this.transactionID);
        }
        if (this.producerID != 0L) {
            this.writeLong(dataOutputStream, 9, this.producerID);
        }
        for (n = 0; n < 10; ++n) {
            if (this.stringItems[n] == null) continue;
            this.writeString(dataOutputStream, n, this.stringItems[n]);
        }
        dataOutputStream.writeShort(0);
        dataOutputStream.flush();
        n = 4 - jMQByteArrayOutputStream.getCount() % 4;
        jMQByteArrayOutputStream.write(byArray, 0, n);
        jMQByteArrayOutputStream.flush();
        this.buffer = ByteBuffer.wrap(jMQByteArrayOutputStream.getBuf(), 0, jMQByteArrayOutputStream.getCount());
        this.bufferDirty = false;
        this.bufferParsed = true;
        jMQByteArrayOutputStream.close();
        dataOutputStream.close();
    }

    private void writeString(DataOutputStream dataOutputStream, int n, String string) throws IOException {
        if (string != null) {
            dataOutputStream.writeShort(n);
            dataOutputStream.writeUTF(string);
        }
    }

    private void writeLong(DataOutputStream dataOutputStream, int n, long l) throws IOException {
        dataOutputStream.writeShort(n);
        dataOutputStream.writeShort(8);
        dataOutputStream.writeLong(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<PacketVariableHeader> clazz = PacketVariableHeader.class;
        synchronized (PacketVariableHeader.class) {
            if (charset == null) {
                try {
                    charset = Charset.forName("UTF-8");
                    decoder = charset.newDecoder();
                    encoder = charset.newEncoder();
                }
                catch (Exception exception) {
                    System.err.println("Could not get charset: " + exception);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

