/*
 * Decompiled with CFR 0.152.
 */
package jp.sun.util;

import com.sun.messaging.jmq.admin.apps.console.event.AdminEvent;
import com.sun.messaging.jmq.admin.apps.console.event.AdminEventListener;
import com.sun.messaging.jmq.admin.apps.console.event.BrokerAdminEvent;
import com.sun.messaging.jmq.admin.apps.console.event.BrokerCmdStatusEvent;
import com.sun.messaging.jmq.admin.apps.console.event.BrokerErrorEvent;
import com.sun.messaging.jmq.admin.apps.console.event.DialogEvent;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdmin;
import com.sun.messaging.jmq.util.admin.ServiceInfo;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import jp.sun.util.ConsoleBrokerAdminManagerA;

public class BrokerUtil
implements AdminEventListener {
    private BrokerAdmin ba;

    public static StringBuffer printAllProperties(String hostname, String port, String userid, String password) {
        StringBuffer sb = new StringBuffer();
        try {
            BrokerUtil bu = new BrokerUtil();
            sb.append("BrokerAdmin instance creating...").append("\n");
            bu.initBrokerAdmin(hostname, port, userid, password);
            sb.append("BrokerAdmin instance created.").append("\n");
            sb.append("starting connect...").append("\n");
            try {
                bu.ba.connect();
            }
            catch (Exception cone) {
                sb.append("MQ Broker on " + bu.ba.getBrokerHost() + ":" + bu.ba.getBrokerPort() + " STOPPED").append("\n");
                return sb;
            }
            sb.append("connect completed.").append("\n");
            BrokerUtil brokerUtil = bu;
            sb.append("defaulttimeout : " + brokerUtil.ba.getDefaultTimeout()).append("\n");
            bu.ba.sendGetBrokerPropsMessage();
            Properties bproperties = bu.ba.receiveGetBrokerPropsReplyMessage(false);
            TreeMap<String, String> tm = new TreeMap<String, String>();
            Enumeration<Object> ekey = bproperties.keys();
            while (ekey.hasMoreElements()) {
                String k = (String)ekey.nextElement();
                String v = (String)bproperties.get(k);
                tm.put(k, v);
            }
            for (Map.Entry me : tm.entrySet()) {
                String mk = (String)me.getKey();
                String mv = (String)me.getValue();
                sb.append(mk + " = " + mv).append("\n");
            }
            bu.ba.sendGetServicesMessage(null);
            Vector vector = bu.ba.receiveGetServicesReplyMessage();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ServiceInfo serviceinfo = (ServiceInfo)enumeration.nextElement();
                sb.append(serviceinfo.name + " : " + bu.getState(serviceinfo.state)).append("\n");
            }
            bu.ba.forceClose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb;
    }

    public String getState(int i) {
        if (i == 4) {
            return "PAUSED";
        }
        if (i == 3) {
            return "RUNNING";
        }
        return "UNKNOWN";
    }

    public void initBrokerAdmin(String hostname, String port, String userid, String password) {
        try {
            ConsoleBrokerAdminManagerA cba = new ConsoleBrokerAdminManagerA();
            cba.setHostName(hostname);
            cba.setPort(port);
            cba.setUserid(userid);
            cba.setPassword(password);
            cba.readBrokerAdminsFromFile();
            Vector ve = cba.getBrokerAdmins();
            if (ve.size() != 0) {
                this.ba = (BrokerAdmin)ve.firstElement();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void adminEventDispatched(AdminEvent adminevent) {
        if (adminevent instanceof DialogEvent || adminevent instanceof BrokerAdminEvent || adminevent instanceof BrokerErrorEvent || !(adminevent instanceof BrokerCmdStatusEvent)) {
            // empty if block
        }
    }
}

