/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.xerto;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.basic.BasicPainter;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.plaf.xerto.XertoUtils;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class XertoPainter
extends BasicPainter {
    private static XertoPainter _instance;
    private static final ImageIcon SELECTED;
    private static final ImageIcon SELECTED_C;
    private static final ImageIcon ROLLOVER;
    private static final ImageIcon ROLLOVER_C;
    private static final ImageIcon PRESSED;
    private static final ImageIcon PRESSED_C;

    public static ThemePainter getInstance() {
        if (_instance == null) {
            _instance = new XertoPainter();
        }
        return _instance;
    }

    protected XertoPainter() {
    }

    public final void paintMenuItemBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2, boolean bl) {
        super.paintMenuItemBackground(jComponent, graphics, rectangle, n, n2, bl);
    }

    public final void paintButtonBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        if (n2 == 0) {
            super.paintButtonBackground(jComponent, graphics, rectangle, n, n2);
            return;
        }
        if (n2 == 2) {
            XertoPainter.paintImageBorder(graphics, rectangle, ROLLOVER, ROLLOVER_C, null);
            return;
        }
        if (n2 == 3) {
            XertoPainter.paintImageBorder(graphics, rectangle, SELECTED, SELECTED_C, Color.WHITE);
            return;
        }
        if (n2 == 1) {
            XertoPainter.paintImageBorder(graphics, rectangle, PRESSED, PRESSED_C, null);
        }
    }

    private static void paintImageBorder(Graphics graphics, Rectangle rectangle, ImageIcon serializable, ImageIcon imageIcon, Color color) {
        JideSwingUtilities.drawImageBorder(graphics, serializable, rectangle, new Insets(4, 4, 4, 4), false);
        if (imageIcon == null) {
            serializable = graphics.getColor();
            graphics.setColor(color);
            graphics.fillRect(rectangle.x + 4, rectangle.y + 4, rectangle.width - 8, rectangle.height - 8);
            graphics.setColor((Color)serializable);
            return;
        }
        graphics.drawImage(imageIcon.getImage(), rectangle.x + 4, rectangle.y + 4, rectangle.x + rectangle.width - 4, rectangle.y + rectangle.height - 4, 0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight(), color, null);
    }

    public final void paintGripper$6e95d9b1(Graphics graphics, Rectangle rectangle, int n, int n2) {
        if (rectangle.width > 30) {
            n = 1;
        }
        n2 = n == 0 ? rectangle.height : rectangle.width;
        n2 = Math.min(9, (n2 - 6) / 4);
        int n3 = rectangle.y;
        int n4 = rectangle.x;
        if (n == 0) {
            n3 += rectangle.height / 2 - (n2 << 1);
            n4 += rectangle.width / 2 - 1;
        } else {
            n4 += rectangle.width / 2 - (n2 << 1);
            n3 += rectangle.height / 2 - 1;
        }
        for (int i = 0; i < n2; ++i) {
            XertoPainter xertoPainter = this;
            graphics.setColor(Color.WHITE);
            graphics.fillRect(n4 + 1, n3 + 1, 2, 2);
            graphics.setColor(XertoUtils.getControlMidShadowColor());
            graphics.fillRect(n4, n3, 2, 2);
            graphics.setColor(XertoUtils.getControlLightShadowColor());
            graphics.fillRect(n4, n3, 1, 1);
            graphics.setColor(XertoUtils.getControlDarkShadowColor());
            graphics.fillRect(n4 + 1, n3 + 1, 1, 1);
            if (n == 0) {
                n3 += 4;
                continue;
            }
            n4 += 4;
        }
    }

    public final Color getGripperForeground() {
        return XertoUtils.getControlLightShadowColor();
    }

    public final Color getGripperForegroundLt() {
        return Color.WHITE;
    }

    public final Color getSelectionSelectedDk() {
        return XertoUtils.getControlMidShadowColor();
    }

    public final Color getSelectionSelectedLt() {
        return XertoUtils.getControlLightShadowColor();
    }

    static {
        SELECTED = IconsFactory.getImageIcon(XertoPainter.class, "icons/selected.gif");
        SELECTED_C = IconsFactory.getImageIcon(XertoPainter.class, "icons/selected_c.gif");
        ROLLOVER = IconsFactory.getImageIcon(XertoPainter.class, "icons/rollover.gif");
        ROLLOVER_C = IconsFactory.getImageIcon(XertoPainter.class, "icons/rollover_c.gif");
        PRESSED = IconsFactory.getImageIcon(XertoPainter.class, "icons/pressed.gif");
        PRESSED_C = IconsFactory.getImageIcon(XertoPainter.class, "icons/pressed_c.gif");
    }
}

