/*
 * Decompiled with CFR 0.152.
 */
package com.qbrowser.property;

import com.qbrowser.QBrowserV2;
import com.qbrowser.container.MessageContainer;
import com.qbrowser.localstore.LocalMessageContainer;
import com.qbrowser.property.Property;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ResourceBundle;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.swing.table.DefaultTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderPropertyTable
extends DefaultTableModel {
    private static ResourceBundle resources = QBrowserV2.resources;
    private String[] columnNames = new String[]{resources.getString("qkey.proptable.jmsheader.key"), resources.getString("qkey.proptable.jmsheader.prop_value")};
    LinkedList list = null;

    public HeaderPropertyTable() {
        this.init();
        this.add_one_row(new Property());
    }

    public HeaderPropertyTable(int number_of_initial_rows) {
        this.init();
        for (int i = 0; i < number_of_initial_rows; ++i) {
            this.add_one_row(new Property());
        }
    }

    @Override
    public int getRowCount() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Object.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return true;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (this.list == null) {
            return;
        }
        if (this.list.size() < row) {
            return;
        }
        Object p = (Property)this.list.get(row);
        if (p == null) {
            return;
        }
        try {
            switch (column) {
                case 0: {
                    if (value instanceof String) {
                        Object object = p;
                        p = (String)value;
                        value = object;
                        ((Property)object).key = p;
                    }
                    return;
                }
                case 1: {
                    Property property = p;
                    p = value;
                    value = property;
                    property.property_value = p;
                    return;
                }
            }
            return;
        }
        catch (Exception exception) {
            Exception e = exception;
            exception.printStackTrace();
            return;
        }
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.list == null) {
            return null;
        }
        Property p = (Property)this.list.get(row);
        if (p == null) {
            return "";
        }
        try {
            switch (column) {
                case 0: {
                    return p.key;
                }
                case 1: {
                    return p.property_value;
                }
            }
            return "Bad column value: " + column;
        }
        catch (Exception e) {
            return "Error: " + e;
        }
    }

    public int load(MessageContainer mc) {
        if (mc == null) {
            return 0;
        }
        Message message = mc.getMessage();
        if (message == null) {
            return 0;
        }
        this.list = new LinkedList();
        try {
            String jtype;
            int jpri;
            String jcorid;
            Property property;
            Object object;
            long jexp = message.getJMSExpiration();
            if (jexp != 0L) {
                Property jexp_prop = new Property();
                object = "JMSExpiration";
                property = jexp_prop;
                jexp_prop.key = object;
                object = "Long";
                property = jexp_prop;
                jexp_prop.property_type = object;
                object = jexp;
                property = jexp_prop;
                jexp_prop.property_value = object;
                this.list.add(jexp_prop);
            }
            Destination d = message.getJMSReplyTo();
            String s = null;
            if (d != null) {
                s = d instanceof Queue ? ((Queue)d).getQueueName() + " : Queue" : ((Topic)d).getTopicName() + " : Topic";
            }
            if (s != null) {
                Property jrepto = new Property();
                object = "JMSReplyTo";
                property = jrepto;
                jrepto.key = object;
                object = "String";
                property = jrepto;
                jrepto.property_type = object;
                object = s;
                property = jrepto;
                jrepto.property_value = object;
                this.list.add(jrepto);
            }
            if ((jcorid = message.getJMSCorrelationID()) != null && jcorid.length() > 0) {
                Property jcoridp = new Property();
                object = "JMSCorrelationID";
                property = jcoridp;
                jcoridp.key = object;
                object = "String";
                property = jcoridp;
                jcoridp.property_type = object;
                object = jcorid;
                property = jcoridp;
                jcoridp.property_value = object;
                this.list.add(jcoridp);
            }
            if ((jpri = message.getJMSPriority()) != 4) {
                Property jprip = new Property();
                object = "JMSPriority";
                property = jprip;
                jprip.key = object;
                object = "Int";
                property = jprip;
                jprip.property_type = object;
                object = jpri;
                property = jprip;
                jprip.property_value = object;
                this.list.add(jprip);
            }
            if ((jtype = message.getJMSType()) != null && jtype.length() > 0) {
                Property jtypep = new Property();
                object = "JMSType";
                property = jtypep;
                jtypep.key = object;
                object = "String";
                property = jtypep;
                jtypep.property_type = object;
                object = jtype;
                property = jtypep;
                jtypep.property_value = object;
                this.list.add(jtypep);
            }
            this.fireTableDataChanged();
        }
        catch (JMSException jMSException) {}
        return this.list.size();
    }

    public final int load(LocalMessageContainer message) {
        if (message == null) {
            return 0;
        }
        this.list = new LinkedList();
        try {
            String jtype;
            int jpri;
            String jcorid;
            Property property;
            Object object;
            long jexp = message.getVexpiration();
            if (jexp != 0L) {
                Property jexp_prop = new Property();
                object = "JMSExpiration";
                property = jexp_prop;
                jexp_prop.key = object;
                object = "Long";
                property = jexp_prop;
                jexp_prop.property_type = object;
                object = jexp;
                property = jexp_prop;
                jexp_prop.property_value = object;
                this.list.add(jexp_prop);
            }
            Destination d = message.getVreplyto();
            String s = null;
            if (d != null) {
                s = d instanceof Queue ? ((Queue)d).getQueueName() + " : Queue" : ((Topic)d).getTopicName() + " : Topic";
            }
            if (s != null) {
                Property jrepto = new Property();
                object = "JMSReplyTo";
                property = jrepto;
                jrepto.key = object;
                object = "String";
                property = jrepto;
                jrepto.property_type = object;
                object = s;
                property = jrepto;
                jrepto.property_value = object;
                this.list.add(jrepto);
            }
            if ((jcorid = message.getVcorrelationid()) != null && jcorid.length() > 0) {
                Property jcoridp = new Property();
                object = "JMSCorrelationID";
                property = jcoridp;
                jcoridp.key = object;
                object = "String";
                property = jcoridp;
                jcoridp.property_type = object;
                object = jcorid;
                property = jcoridp;
                jcoridp.property_value = object;
                this.list.add(jcoridp);
            }
            if ((jpri = message.getVpriority()) != 4) {
                Property jprip = new Property();
                object = "JMSPriority";
                property = jprip;
                jprip.key = object;
                object = "Int";
                property = jprip;
                jprip.property_type = object;
                object = jpri;
                property = jprip;
                jprip.property_value = object;
                this.list.add(jprip);
            }
            if ((jtype = message.getVjms_type()) != null && jtype.length() > 0) {
                Property jtypep = new Property();
                object = "JMSType";
                property = jtypep;
                jtypep.key = object;
                object = "String";
                property = jtypep;
                jtypep.property_type = object;
                object = jtype;
                property = jtypep;
                jtypep.property_value = object;
                this.list.add(jtypep);
            }
            ArrayList<Property> ahp = message.getAdditionalHeaders();
            for (int i = 0; i < ahp.size(); ++i) {
                this.list.add(ahp.get(i));
            }
            this.fireTableDataChanged();
        }
        catch (JMSException jMSException) {}
        return this.list.size();
    }

    public int loadAllProperties(MessageContainer mc) {
        if (mc == null) {
            return 0;
        }
        this.list = new LinkedList();
        try {
            Message message = mc.getMessage();
            String msgid = message.getJMSMessageID();
            Property msgidp = new Property();
            Object object = "JMSMessageID";
            Property property = msgidp;
            msgidp.key = object;
            object = "String";
            property = msgidp;
            msgidp.property_type = object;
            object = msgid;
            property = msgidp;
            msgidp.property_value = object;
            this.list.add(msgidp);
            Object s1 = mc.getVdest();
            s1 = s1 != null ? (s1 instanceof Queue ? ((Queue)s1).getQueueName() + " : Queue" : ((Topic)s1).getTopicName() + " : Topic") : "";
            Property jdestp = new Property();
            object = "JMSDestination";
            property = jdestp;
            jdestp.key = object;
            object = "String";
            property = jdestp;
            jdestp.property_type = object;
            object = s1;
            property = jdestp;
            jdestp.property_value = object;
            this.list.add(jdestp);
            Object s = mc.getVreplyto();
            s = s != null ? (s instanceof Queue ? ((Queue)s).getQueueName() + " : Queue" : ((Topic)s).getTopicName() + " : Topic") : "";
            Property jrepto = new Property();
            object = "JMSReplyTo";
            property = jrepto;
            jrepto.key = object;
            object = "String";
            property = jrepto;
            jrepto.property_type = object;
            object = s;
            property = jrepto;
            jrepto.property_value = object;
            this.list.add(jrepto);
            String jcorid = message.getJMSCorrelationID();
            Property jcoridp = new Property();
            object = "JMSCorrelationID";
            property = jcoridp;
            jcoridp.key = object;
            object = "String";
            property = jcoridp;
            jcoridp.property_type = object;
            object = jcorid;
            property = jcoridp;
            jcoridp.property_value = object;
            this.list.add(jcoridp);
            int delivermode = message.getJMSDeliveryMode();
            Property delivermodep = new Property();
            object = "JMSDeliverMode";
            property = delivermodep;
            delivermodep.key = object;
            object = "Int";
            property = delivermodep;
            delivermodep.property_type = object;
            object = delivermode;
            property = delivermodep;
            delivermodep.property_value = object;
            this.list.add(delivermodep);
            int jpri = message.getJMSPriority();
            Property jprip = new Property();
            object = "JMSPriority";
            property = jprip;
            jprip.key = object;
            object = "Int";
            property = jprip;
            jprip.property_type = object;
            object = jpri;
            property = jprip;
            jprip.property_value = object;
            this.list.add(jprip);
            long jexp = message.getJMSExpiration();
            Property jexp_prop = new Property();
            object = "JMSExpiration";
            property = jexp_prop;
            jexp_prop.key = object;
            object = "Long";
            property = jexp_prop;
            jexp_prop.property_type = object;
            object = jexp;
            property = jexp_prop;
            jexp_prop.property_value = object;
            this.list.add(jexp_prop);
            String jtype = message.getJMSType();
            Property jtypep = new Property();
            object = "JMSType";
            property = jtypep;
            jtypep.key = object;
            object = "String";
            property = jtypep;
            jtypep.property_type = object;
            object = jtype;
            property = jtypep;
            jtypep.property_value = object;
            this.list.add(jtypep);
            boolean redelivered = message.getJMSRedelivered();
            Property redvd = new Property();
            object = "JMSRedelivered";
            property = redvd;
            redvd.key = object;
            object = "Boolean";
            property = redvd;
            redvd.property_type = object;
            object = redelivered;
            property = redvd;
            redvd.property_value = object;
            this.list.add(redvd);
            long jtimestamp = message.getJMSTimestamp();
            Property jtimestampp = new Property();
            object = "JMSTimestamp";
            property = jtimestampp;
            jtimestampp.key = object;
            object = "Long";
            property = jtimestampp;
            jtimestampp.property_type = object;
            object = jtimestamp;
            property = jtimestampp;
            jtimestampp.property_value = object;
            this.list.add(jtimestampp);
            ArrayList<Property> ahp = mc.getAdditionalHeaders();
            for (int i = 0; i < ahp.size(); ++i) {
                this.list.add(ahp.get(i));
            }
            this.fireTableDataChanged();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return this.list.size();
    }

    public final int loadAllProperties(LocalMessageContainer message) {
        if (message == null) {
            return 0;
        }
        this.list = new LinkedList();
        try {
            String msgid = message.getVmsgid();
            Property msgidp = new Property();
            Object object = "JMSMessageID";
            Property property = msgidp;
            msgidp.key = object;
            object = "String";
            property = msgidp;
            msgidp.property_type = object;
            object = msgid;
            property = msgidp;
            msgidp.property_value = object;
            this.list.add(msgidp);
            Object s1 = message.getVdest();
            s1 = s1 != null ? (s1 instanceof Queue ? ((Queue)s1).getQueueName() + " : Queue" : ((Topic)s1).getTopicName() + " : Topic") : "";
            Property jdestp = new Property();
            object = "JMSDestination";
            property = jdestp;
            jdestp.key = object;
            object = "String";
            property = jdestp;
            jdestp.property_type = object;
            object = s1;
            property = jdestp;
            jdestp.property_value = object;
            this.list.add(jdestp);
            Object s = message.getVreplyto();
            s = s != null ? (s instanceof Queue ? ((Queue)s).getQueueName() + " : Queue" : ((Topic)s).getTopicName() + " : Topic") : "";
            Property jrepto = new Property();
            object = "JMSReplyTo";
            property = jrepto;
            jrepto.key = object;
            object = "String";
            property = jrepto;
            jrepto.property_type = object;
            object = s;
            property = jrepto;
            jrepto.property_value = object;
            this.list.add(jrepto);
            String jcorid = message.getVcorrelationid();
            Property jcoridp = new Property();
            object = "JMSCorrelationID";
            property = jcoridp;
            jcoridp.key = object;
            object = "String";
            property = jcoridp;
            jcoridp.property_type = object;
            object = jcorid;
            property = jcoridp;
            jcoridp.property_value = object;
            this.list.add(jcoridp);
            int delivermode = message.getVdeliverymode();
            Property delivermodep = new Property();
            object = "JMSDeliverMode";
            property = delivermodep;
            delivermodep.key = object;
            object = "Int";
            property = delivermodep;
            delivermodep.property_type = object;
            object = delivermode;
            property = delivermodep;
            delivermodep.property_value = object;
            this.list.add(delivermodep);
            int jpri = message.getVpriority();
            Property jprip = new Property();
            object = "JMSPriority";
            property = jprip;
            jprip.key = object;
            object = "Int";
            property = jprip;
            jprip.property_type = object;
            object = jpri;
            property = jprip;
            jprip.property_value = object;
            this.list.add(jprip);
            long jexp = message.getVexpiration();
            Property jexp_prop = new Property();
            object = "JMSExpiration";
            property = jexp_prop;
            jexp_prop.key = object;
            object = "Long";
            property = jexp_prop;
            jexp_prop.property_type = object;
            object = jexp;
            property = jexp_prop;
            jexp_prop.property_value = object;
            this.list.add(jexp_prop);
            String jtype = message.getVjms_type();
            Property jtypep = new Property();
            object = "JMSType";
            property = jtypep;
            jtypep.key = object;
            object = "String";
            property = jtypep;
            jtypep.property_type = object;
            object = jtype;
            property = jtypep;
            jtypep.property_value = object;
            this.list.add(jtypep);
            boolean redelivered = message.isVredelivered();
            Property redvd = new Property();
            object = "JMSRedelivered";
            property = redvd;
            redvd.key = object;
            object = "Boolean";
            property = redvd;
            redvd.property_type = object;
            object = redelivered;
            property = redvd;
            redvd.property_value = object;
            this.list.add(redvd);
            long jtimestamp = message.getVtimestamp();
            Property jtimestampp = new Property();
            object = "JMSTimestamp";
            property = jtimestampp;
            jtimestampp.key = object;
            object = "Long";
            property = jtimestampp;
            jtimestampp.property_type = object;
            object = jtimestamp;
            property = jtimestampp;
            jtimestampp.property_value = object;
            this.list.add(jtimestampp);
            ArrayList<Property> ahp = message.getAdditionalHeaders();
            for (int i = 0; i < ahp.size(); ++i) {
                this.list.add(ahp.get(i));
            }
            this.fireTableDataChanged();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return this.list.size();
    }

    private void init() {
        this.list = new LinkedList();
    }

    private void add_one_row(Property value) {
        this.list.add(value);
        this.fireTableDataChanged();
    }

    public final void add_one_empty_row() {
        this.list.add(new Property());
        this.fireTableDataChanged();
    }

    public final void deletePropertyAtRow(int row) {
        if (this.list == null) {
            return;
        }
        this.list.remove(row);
        this.fireTableDataChanged();
    }

    public final Property getPropertyAtRow(int row) {
        if (this.list == null) {
            return null;
        }
        return (Property)this.list.get(row);
    }
}

