/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console.util;

import com.sun.messaging.jmq.admin.apps.console.util.LongField;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.util.SizeString;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class BytesField
extends JPanel {
    public static final int BYTES = 0;
    public static final int KILOBYTES = 1;
    public static final int MEGABYTES = 2;
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();
    private LongField lf;
    private JComboBox unitCB;

    public BytesField(long l, long l2, String string) {
        this(l, l2, string, 0);
    }

    public BytesField(long l, long l2, int n) {
        this(l, l2, null, n);
    }

    public BytesField(long l, long l2, String string, int n) {
        this.initGui(l, l2, string, n);
        this.setUnit(1);
    }

    public void addActionListener(ActionListener actionListener) {
        this.lf.addActionListener(actionListener);
    }

    public void setText(String string) {
        this.lf.setText(string);
    }

    public String getText() {
        return this.lf.getText();
    }

    public void setEnabled(boolean bl) {
        this.lf.setEnabled(bl);
        this.unitCB.setEnabled(bl);
    }

    public void setUnit(int n) {
        if (n < 0 || n > 2) {
            return;
        }
        this.unitCB.setSelectedIndex(n);
    }

    public int getUnit() {
        int n = this.unitCB.getSelectedIndex();
        return n;
    }

    public void setSizeString(String string) {
        int n;
        long l;
        SizeString sizeString;
        String string2 = string.trim();
        try {
            sizeString = new SizeString(string2);
        }
        catch (Exception exception) {
            return;
        }
        char c = string2.charAt(string2.length() - 1);
        if (Character.isLetter(c)) {
            switch (c) {
                case 'M': 
                case 'm': {
                    l = sizeString.getMBytes();
                    n = 2;
                    break;
                }
                case 'K': 
                case 'k': {
                    l = sizeString.getKBytes();
                    n = 1;
                    break;
                }
                case 'B': 
                case 'b': {
                    l = sizeString.getBytes();
                    n = 0;
                    break;
                }
                default: {
                    l = 0L;
                    n = 0;
                    break;
                }
            }
        } else {
            l = sizeString.getBytes();
            n = 0;
        }
        this.setText(Long.toString(l));
        this.setUnit(n);
    }

    public String getSizeString() {
        String string;
        String string2 = this.getText();
        int n = this.getUnit();
        switch (n) {
            case 0: {
                string = "b";
                break;
            }
            case 1: {
                string = "k";
                break;
            }
            case 2: {
                string = "m";
                break;
            }
            default: {
                string = "b";
            }
        }
        return string2 + string;
    }

    public long getValue() {
        long l;
        String string = this.lf.getText();
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {
            return -1L;
        }
        int n = this.unitCB.getSelectedIndex();
        switch (n) {
            case 2: {
                return l * 0x100000L;
            }
            case 1: {
                return l * 1024L;
            }
            case 0: {
                return l;
            }
        }
        return -1L;
    }

    private void initGui(long l, long l2, String string, int n) {
        this.lf = new LongField(l, l2, string, n);
        String[] stringArray = new String[3];
        stringArray[2] = acr.getString("A1219");
        stringArray[1] = acr.getString("A1220");
        stringArray[0] = acr.getString("A1221");
        this.unitCB = new JComboBox<String>(stringArray);
        this.setLayout(new BorderLayout());
        this.add((Component)this.lf, "Center");
        this.add((Component)this.unitCB, "East");
    }
}

