/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.aqua;

import com.jidesoft.plaf.aqua.XMLParseException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

final class XMLElement {
    private HashMap attributes;
    private ArrayList children;
    private String name;
    private String contents;
    private HashMap entities;
    private boolean ignoreCase;
    private boolean ignoreWhitespace;
    private char charReadTooMuch;
    private Reader reader;
    private int parserLineNr;

    public XMLElement() {
        this(new HashMap(), false, true, true);
    }

    public XMLElement(HashMap hashMap, boolean bl, boolean bl2) {
        this(hashMap, false, true, false);
    }

    private XMLElement(HashMap object, boolean bl, boolean bl2, boolean bl3) {
        this.ignoreWhitespace = bl;
        this.ignoreCase = bl3;
        this.name = null;
        this.contents = "";
        this.attributes = new HashMap();
        this.children = new ArrayList();
        this.entities = object;
        for (Object e : this.entities.keySet()) {
            Object object2 = this.entities.get(e);
            if (!(object2 instanceof String)) continue;
            object2 = ((String)object2).toCharArray();
            this.entities.put(e, object2);
        }
        if (bl2) {
            this.entities.put("amp", new char[]{'&'});
            this.entities.put("quot", new char[]{'\"'});
            this.entities.put("apos", new char[]{'\''});
            this.entities.put("lt", new char[]{'<'});
            this.entities.put("gt", new char[]{'>'});
        }
    }

    public final void addChild(XMLElement xMLElement) {
        this.children.add(xMLElement);
    }

    public final void setAttribute(String string, Object object) {
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        this.attributes.put(string, object.toString());
    }

    public final Iterator iterateChildren() {
        return this.children.iterator();
    }

    public final String getContent() {
        return this.contents;
    }

    public final String getName() {
        return this.name;
    }

    public final void parseFromReader(Reader reader, int n) throws IOException, XMLParseException {
        char c;
        this.name = null;
        this.contents = "";
        this.attributes = new HashMap();
        this.children = new ArrayList();
        this.charReadTooMuch = '\u0000';
        this.reader = reader;
        this.parserLineNr = 1;
        while (true) {
            if ((c = this.scanWhitespace()) != '<') {
                throw this.expectedInput("<");
            }
            c = this.readChar();
            if (c != '!' && c != '?') break;
            this.skipSpecialTag(0);
        }
        n = c;
        XMLElement xMLElement = this;
        this.charReadTooMuch = (char)n;
        this.scanElement(this);
    }

    public final XMLElement createAnotherElement() {
        return new XMLElement(this.entities, this.ignoreWhitespace, false, this.ignoreCase);
    }

    public final void setContent(String string) {
        this.contents = string;
    }

    public final void setName(String string) {
        this.name = string;
    }

    public final String toString() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
            this.write(outputStreamWriter);
            outputStreamWriter.flush();
            return new String(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            return super.toString();
        }
    }

    private void write(Writer writer) throws IOException {
        Iterator iterator;
        if (this.name == null) {
            XMLElement.writeEncoded(writer, this.contents);
            return;
        }
        writer.write(60);
        writer.write(this.name);
        if (!this.attributes.isEmpty()) {
            iterator = this.attributes.keySet().iterator();
            while (iterator.hasNext()) {
                writer.write(32);
                Object object = (String)iterator.next();
                String string = (String)this.attributes.get(object);
                writer.write((String)object);
                writer.write(61);
                writer.write(34);
                XMLElement.writeEncoded(writer, string);
                writer.write(34);
            }
        }
        if (this.contents != null && this.contents.length() > 0) {
            writer.write(62);
            XMLElement.writeEncoded(writer, this.contents);
        } else {
            if (this.children.isEmpty()) {
                writer.write(47);
                writer.write(62);
                return;
            }
            writer.write(62);
            iterator = this;
            for (Object object : ((XMLElement)((Object)iterator)).children) {
                ((XMLElement)object).write(writer);
            }
        }
        writer.write(60);
        writer.write(47);
        writer.write(this.name);
        writer.write(62);
    }

    private static void writeEncoded(Writer writer, String string) throws IOException {
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    writer.write(38);
                    writer.write(108);
                    writer.write(116);
                    writer.write(59);
                    continue block7;
                }
                case '>': {
                    writer.write(38);
                    writer.write(103);
                    writer.write(116);
                    writer.write(59);
                    continue block7;
                }
                case '&': {
                    writer.write(38);
                    writer.write(97);
                    writer.write(109);
                    writer.write(112);
                    writer.write(59);
                    continue block7;
                }
                case '\"': {
                    writer.write(38);
                    writer.write(113);
                    writer.write(117);
                    writer.write(111);
                    writer.write(116);
                    writer.write(59);
                    continue block7;
                }
                case '\'': {
                    writer.write(38);
                    writer.write(97);
                    writer.write(112);
                    writer.write(111);
                    writer.write(115);
                    writer.write(59);
                    continue block7;
                }
                default: {
                    char c2 = c;
                    if (c2 < ' ' || c2 > '~') {
                        writer.write(38);
                        writer.write(35);
                        writer.write(120);
                        writer.write(Integer.toString(c2, 16));
                        writer.write(59);
                        continue block7;
                    }
                    writer.write(c);
                }
            }
        }
    }

    private void scanIdentifier(StringBuffer object) throws IOException {
        while (true) {
            char c;
            if (!((c = this.readChar()) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_' || c == '.' || c == ':' || c == '-' || c > '~')) {
                object = this;
                this.charReadTooMuch = c;
                return;
            }
            ((StringBuffer)object).append(c);
        }
    }

    private char scanWhitespace() throws IOException {
        char c;
        block3: while (true) {
            c = this.readChar();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
            }
            break;
        }
        return c;
    }

    private char scanWhitespace(StringBuffer stringBuffer) throws IOException {
        char c;
        block4: while (true) {
            c = this.readChar();
            switch (c) {
                case '\t': 
                case '\n': 
                case ' ': {
                    stringBuffer.append(c);
                }
                case '\r': {
                    continue block4;
                }
            }
            break;
        }
        return c;
    }

    private void scanString(StringBuffer stringBuffer) throws IOException {
        char c = this.readChar();
        if (c != '\'' && c != '\"') {
            throw this.expectedInput("' or \"");
        }
        char c2;
        while ((c2 = this.readChar()) != c) {
            if (c2 == '&') {
                this.resolveEntity(stringBuffer);
                continue;
            }
            stringBuffer.append(c2);
        }
        return;
    }

    private void scanPCData(StringBuffer object) throws IOException {
        while (true) {
            char c;
            if ((c = this.readChar()) == '<') {
                c = this.readChar();
                if (c == '!') {
                    this.checkCDATA((StringBuffer)object);
                    continue;
                }
                object = this;
                this.charReadTooMuch = c;
                return;
            }
            if (c == '&') {
                this.resolveEntity((StringBuffer)object);
                continue;
            }
            ((StringBuffer)object).append(c);
        }
    }

    private boolean checkCDATA(StringBuffer object) throws IOException {
        char c = this.readChar();
        if (c != '[') {
            object = this;
            this.charReadTooMuch = c;
            this.skipSpecialTag(0);
            return false;
        }
        if (!this.checkLiteral("CDATA[")) {
            this.skipSpecialTag(1);
            return false;
        }
        block4: while (true) {
            int n = 0;
            block5: while (n < 3) {
                int n2;
                c = this.readChar();
                switch (c) {
                    case ']': {
                        if (n < 2) {
                            ++n;
                            continue block5;
                        }
                        ((StringBuffer)object).append(']');
                        ((StringBuffer)object).append(']');
                        continue block4;
                    }
                    case '>': {
                        if (n < 2) {
                            for (n2 = 0; n2 < n; ++n2) {
                                ((StringBuffer)object).append(']');
                            }
                            n = 0;
                            ((StringBuffer)object).append('>');
                            continue block5;
                        }
                        n = 3;
                        continue block5;
                    }
                }
                for (n2 = 0; n2 < n; ++n2) {
                    ((StringBuffer)object).append(']');
                }
                ((StringBuffer)object).append(c);
                continue block4;
            }
            break;
        }
        return true;
    }

    private void skipComment() throws IOException {
        int n = 2;
        while (n > 0) {
            char c = this.readChar();
            if (c == '-') {
                --n;
                continue;
            }
            n = 2;
        }
        if (this.readChar() != '>') {
            throw this.expectedInput(">");
        }
    }

    private void skipSpecialTag(int n) throws IOException {
        char c;
        int n2 = 1;
        char c2 = '\u0000';
        if (n == 0) {
            c = this.readChar();
            if (c == '[') {
                ++n;
            } else if (c == '-') {
                c = this.readChar();
                if (c == '[') {
                    ++n;
                } else if (c == ']') {
                    --n;
                } else if (c == '-') {
                    this.skipComment();
                    return;
                }
            }
        }
        while (n2 > 0) {
            c = this.readChar();
            if (c2 == '\u0000') {
                if (c == '\"' || c == '\'') {
                    c2 = c;
                } else if (n <= 0) {
                    if (c == '<') {
                        ++n2;
                    } else if (c == '>') {
                        --n2;
                    }
                }
                if (c == '[') {
                    ++n;
                    continue;
                }
                if (c != ']') continue;
                --n;
                continue;
            }
            if (c != c2) continue;
            c2 = '\u0000';
        }
    }

    private boolean checkLiteral(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (this.readChar() == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private char readChar() throws IOException {
        if (this.charReadTooMuch != '\u0000') {
            char c = this.charReadTooMuch;
            this.charReadTooMuch = '\u0000';
            return c;
        }
        int n = this.reader.read();
        if (n < 0) {
            XMLElement xMLElement = this;
            String string = "Unexpected end of data reached";
            XMLElement xMLElement2 = xMLElement;
            throw new XMLParseException(xMLElement2.name, xMLElement.parserLineNr, string);
        }
        if (n == 10) {
            ++this.parserLineNr;
            return '\n';
        }
        return (char)n;
    }

    private void scanElement(XMLElement xMLElement) throws IOException {
        Object object;
        char c;
        XMLElement xMLElement2;
        String string;
        StringBuffer stringBuffer;
        block24: {
            stringBuffer = new StringBuffer();
            this.scanIdentifier(stringBuffer);
            String string2 = string = stringBuffer.toString();
            xMLElement2 = xMLElement;
            xMLElement.name = string2;
            c = this.scanWhitespace();
            while (c != '>' && c != '/') {
                stringBuffer.setLength(0);
                char c2 = c;
                xMLElement2 = this;
                this.charReadTooMuch = c2;
                this.scanIdentifier(stringBuffer);
                object = stringBuffer.toString();
                c = this.scanWhitespace();
                if (c != '=') {
                    throw this.expectedInput("=");
                }
                c2 = this.scanWhitespace();
                xMLElement2 = this;
                this.charReadTooMuch = c2;
                stringBuffer.setLength(0);
                this.scanString(stringBuffer);
                xMLElement.setAttribute((String)object, stringBuffer);
                c = this.scanWhitespace();
            }
            if (c == '/') {
                c = this.readChar();
                if (c != '>') {
                    throw this.expectedInput(">");
                }
                return;
            }
            stringBuffer.setLength(0);
            c = this.scanWhitespace(stringBuffer);
            if (c != '<') {
                char c3 = c;
                xMLElement2 = this;
                this.charReadTooMuch = c3;
                this.scanPCData(stringBuffer);
            } else {
                while ((c = this.readChar()) == '!') {
                    if (this.checkCDATA(stringBuffer)) {
                        this.scanPCData(stringBuffer);
                    } else {
                        c = this.scanWhitespace(stringBuffer);
                        if (c == '<') continue;
                        char c4 = c;
                        xMLElement2 = this;
                        this.charReadTooMuch = c4;
                        this.scanPCData(stringBuffer);
                    }
                    break block24;
                }
                if (c != '/' || this.ignoreWhitespace) {
                    stringBuffer.setLength(0);
                }
                if (c == '/') {
                    char c5 = c;
                    xMLElement2 = this;
                    this.charReadTooMuch = c5;
                }
            }
        }
        if (stringBuffer.length() == 0) {
            while (c != '/') {
                if (c == '!') {
                    c = this.readChar();
                    if (c != '-') {
                        throw this.expectedInput("Comment or Element");
                    }
                    c = this.readChar();
                    if (c != '-') {
                        throw this.expectedInput("Comment or Element");
                    }
                    this.skipComment();
                } else {
                    char c6 = c;
                    xMLElement2 = this;
                    this.charReadTooMuch = c6;
                    object = this.createAnotherElement();
                    this.scanElement((XMLElement)object);
                    xMLElement.addChild((XMLElement)object);
                }
                c = this.scanWhitespace();
                if (c != '<') {
                    throw this.expectedInput("<");
                }
                c = this.readChar();
            }
            char c7 = c;
            xMLElement2 = this;
            this.charReadTooMuch = c7;
        } else if (this.ignoreWhitespace) {
            String string3 = stringBuffer.toString().trim();
            xMLElement2 = xMLElement;
            xMLElement.contents = string3;
        } else {
            String string4 = stringBuffer.toString();
            xMLElement2 = xMLElement;
            xMLElement.contents = string4;
        }
        c = this.readChar();
        if (c != '/') {
            throw this.expectedInput("/");
        }
        char c8 = this.scanWhitespace();
        xMLElement2 = this;
        this.charReadTooMuch = c8;
        if (!this.checkLiteral(string)) {
            throw this.expectedInput(string);
        }
        if (this.scanWhitespace() != '>') {
            throw this.expectedInput(">");
        }
    }

    private void resolveEntity(StringBuffer stringBuffer) throws IOException {
        char c = '\u0000';
        CharSequence charSequence = new StringBuffer();
        while ((c = this.readChar()) != ';') {
            ((StringBuffer)charSequence).append(c);
        }
        if (((String)(charSequence = ((StringBuffer)charSequence).toString())).charAt(0) == '#') {
            try {
                c = ((String)charSequence).charAt(1) == 'x' ? (char)Integer.parseInt(((String)charSequence).substring(2), 16) : (char)Integer.parseInt(((String)charSequence).substring(1), 10);
            }
            catch (NumberFormatException numberFormatException) {
                throw this.unknownEntity((String)charSequence);
            }
            stringBuffer.append(c);
            return;
        }
        char[] cArray = (char[])this.entities.get(charSequence);
        if (cArray == null) {
            throw this.unknownEntity((String)charSequence);
        }
        stringBuffer.append(cArray);
    }

    private XMLParseException expectedInput(String string) {
        string = "Expected: " + string;
        XMLElement xMLElement = this;
        return new XMLParseException(xMLElement.name, this.parserLineNr, string);
    }

    private XMLParseException unknownEntity(String string) {
        string = "Unknown or invalid entity: &" + string + ";";
        XMLElement xMLElement = this;
        return new XMLParseException(xMLElement.name, this.parserLineNr, string);
    }
}

