/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicJideButtonUI;
import com.jidesoft.plaf.basic.LazyActionMap;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.EventObject;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.basic.BasicButtonListener;

public class BasicJideButtonListener
extends BasicButtonListener {
    private boolean _mouseOver = false;

    public BasicJideButtonListener(AbstractButton abstractButton) {
        super(abstractButton);
    }

    public void mouseEntered(MouseEvent serializable) {
        serializable = (AbstractButton)((EventObject)serializable).getSource();
        ButtonModel buttonModel = ((AbstractButton)serializable).getModel();
        if (((AbstractButton)serializable).isRolloverEnabled()) {
            buttonModel.setRollover(true);
        }
        this._mouseOver = true;
        if (buttonModel.isPressed()) {
            buttonModel.setArmed(true);
        }
    }

    public void propertyChange(PropertyChangeEvent serializable) {
        super.propertyChange((PropertyChangeEvent)serializable);
        String string = ((PropertyChangeEvent)serializable).getPropertyName();
        if ("buttonStyle".equals(string) || "opaque".equals(string) || "contentAreaFilled".equals(string)) {
            serializable = (AbstractButton)((EventObject)serializable).getSource();
            ((Component)serializable).repaint();
            return;
        }
        if ("orientation".equals(string) || "hideActionText".equals(string)) {
            serializable = (AbstractButton)((EventObject)serializable).getSource();
            ((Container)serializable).invalidate();
            ((Component)serializable).repaint();
            return;
        }
        if ("verticalTextPosition".equals(string) || "horizontalTextPosition".equals(string)) {
            serializable = (AbstractButton)((EventObject)serializable).getSource();
            ((AbstractButton)serializable).updateUI();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
        BasicJideButtonListener.cancelMenuIfNecessary(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
        ButtonModel buttonModel = abstractButton.getModel();
        if (abstractButton.contains(mouseEvent.getPoint()) && abstractButton.isRolloverEnabled()) {
            buttonModel.setRollover(true);
        }
        if (!this._mouseOver) {
            buttonModel.setArmed(false);
            buttonModel.setPressed(false);
        }
        super.mouseReleased(mouseEvent);
        BasicJideButtonListener.cancelMenuIfNecessary(mouseEvent);
    }

    private static void cancelMenuIfNecessary(MouseEvent serializable) {
        serializable = (AbstractButton)((EventObject)serializable).getSource();
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
        for (int i = menuElementArray.length - 1; i >= 0; --i) {
            MenuElement menuElement = menuElementArray[i];
            if (!(menuElement instanceof JPopupMenu) || !((JPopupMenu)menuElement).isAncestorOf((Component)serializable)) continue;
            ((AbstractButton)serializable).getModel().setPressed(false);
            ((AbstractButton)serializable).getModel().setArmed(false);
            ((AbstractButton)serializable).getModel().setRollover(false);
            if (Boolean.FALSE.equals(((JComponent)serializable).getClientProperty("JideButton.hidePopupMenu"))) break;
            menuSelectionManager.clearSelectedPath();
            return;
        }
    }

    public void mouseExited(MouseEvent serializable) {
        serializable = (AbstractButton)((EventObject)serializable).getSource();
        ButtonModel buttonModel = ((AbstractButton)serializable).getModel();
        if (((AbstractButton)serializable).isRolloverEnabled()) {
            buttonModel.setRollover(false);
        }
        buttonModel.setArmed(false);
        this._mouseOver = false;
    }

    public void installKeyboardActions(JComponent jComponent) {
        Object object;
        AbstractButton abstractButton = (AbstractButton)jComponent;
        AbstractButton abstractButton2 = abstractButton;
        abstractButton2 = abstractButton;
        int n = abstractButton.getMnemonic();
        if (n != 0) {
            object = SwingUtilities.getUIInputMap(abstractButton2, 2);
            if (object == null) {
                object = new ComponentInputMapUIResource(abstractButton2);
                SwingUtilities.replaceUIInputMap(abstractButton2, 2, (InputMap)object);
            }
            ((InputMap)object).clear();
            ((InputMap)object).put(KeyStroke.getKeyStroke(n, 8, false), "pressed");
            ((InputMap)object).put(KeyStroke.getKeyStroke(n, 8, true), "released");
            ((InputMap)object).put(KeyStroke.getKeyStroke(n, 0, true), "released");
        } else {
            object = SwingUtilities.getUIInputMap(abstractButton2, 2);
            if (object != null) {
                ((InputMap)object).clear();
            }
        }
        LazyActionMap.installLazyActionMap(jComponent, BasicJideButtonListener.class, "JideButton.actionMap");
        Object object2 = jComponent;
        boolean bl = false;
        ButtonUI buttonUI = ((AbstractButton)object2).getUI();
        object2 = BasicJideButtonUI.class;
        ButtonUI buttonUI2 = buttonUI;
        object = (BasicJideButtonUI)(((Class)object2).isInstance(buttonUI2) ? buttonUI2 : null);
        buttonUI2 = object != null ? (InputMap)UIDefaultsLookup.get(BasicJideButtonUI.getPropertyPrefix() + "focusInputMap") : null;
        SwingUtilities.replaceUIInputMap(jComponent, 0, (InputMap)((Object)buttonUI2));
    }
}

