/*
 * Decompiled with CFR 0.152.
 */
package com.qbrowser.persist;

import com.qbrowser.QBrowserV2;
import com.qbrowser.localstore.LocalMessageContainer;
import com.qbrowser.persist.PersistedMessageReader;
import com.qbrowser.util.QBrowserUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import javax.jms.BytesMessage;
import javax.jms.Message;
import javax.jms.Session;

public class BytesMessageReader
extends PersistedMessageReader {
    private File target_file;
    private long body_size = -1L;

    public static void main(String[] args) {
        Object bmr = new BytesMessageReader();
        try {
            bmr.readPersistedMessage(new File("c:\\temp1\\ID49-192.168.11.2(e18a30e4fe7f)-4203-1245762696859_BytesMessage.zip"));
            return;
        }
        catch (Exception exception) {
            Object e = exception;
            exception.printStackTrace();
            return;
        }
    }

    public final File readPersistedMessage(File msgArchive) throws Exception {
        File workdirFile = super.readPersistedMessage(msgArchive);
        try {
            this.target_file = new File(workdirFile.getAbsolutePath() + File.separator + "MessageBody_" + "Bytes");
            if (this.target_file == null || !this.target_file.exists()) {
                throw new IOException(QBrowserV2.resources.getString("qkey.msg.msg332") + this.target_file.getName() + QBrowserV2.resources.getString("qkey.msg.msg333"));
            }
        }
        catch (Exception e) {
            BytesMessageReader.clearDir(workdirFile);
            throw e;
        }
        return workdirFile;
    }

    public final File readPersistedMessageWithLazyLoad(File msgArchive) throws Exception {
        File workdirFile = super.readPersistedMessageWithLazyLoad(msgArchive);
        File size_file = new File(workdirFile.getAbsolutePath() + File.separator + "bytesbodysize");
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(size_file));
            String line = br.readLine();
            if (line != null) {
                try {
                    this.body_size = Long.parseLong(line.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            }
            br.close();
        }
        catch (IOException ie) {
            BytesMessageReader.clearDir(workdirFile);
            this.body_size = 0L;
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return workdirFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final LocalMessageContainer recreateMessagefromReadData(Session session) throws Exception {
        BytesMessage bmsg2222 = session.createBytesMessage();
        LocalMessageContainer lmc = new LocalMessageContainer();
        if (this.properties != null) {
            QBrowserUtil.copyUserProperties(this.properties, (Message)bmsg2222);
        }
        lmc.setMessage((Message)bmsg2222);
        lmc.setReal_file_path(this.source_file_path);
        if (this.headers != null) {
            QBrowserUtil.copyMessageHeaders(this.headers, (Message)bmsg2222);
            QBrowserUtil.populateHeadersOfLocalMessageContainer(this.headers, lmc);
        }
        FileInputStream fi = null;
        try {
            fi = new FileInputStream(this.target_file);
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = fi.read(buf)) != -1) {
                bmsg2222.writeBytes(buf, 0, len);
            }
        }
        catch (IOException iOException) {
            try {
                IOException ioe = iOException;
                iOException.printStackTrace();
                throw new IOException(QBrowserV2.resources.getString("qkey.msg.msg331") + ioe.getMessage() + "\n\nFile=" + this.target_file.getName());
            }
            catch (Throwable bmsg2222) {
                if (fi == null) throw bmsg2222;
                try {
                    fi.close();
                    throw bmsg2222;
                }
                catch (IOException iOException2) {}
                throw bmsg2222;
            }
        }
        try {
            fi.close();
            return lmc;
        }
        catch (IOException iOException) {
            return lmc;
        }
    }

    public final LocalMessageContainer recreateMessagefromReadDataWithLazyLoad() throws Exception {
        LocalMessageContainer lmc = super.recreateMessagefromReadDataWithLazyLoad();
        lmc.setBody_size(this.body_size);
        lmc.setMessage_type("BytesMessage");
        return lmc;
    }
}

