#ifndef QRK_IMAGE_SURFACE_H
#define QRK_IMAGE_SURFACE_H

/*!
  \file
  \brief 画像からサーフェスを作成

  \author Satofumi KAMIMURA

  $Id: ImageSurface.h 707 2009-04-04 01:52:23Z satofumi $
*/

#include "Surface.h"
#include <memory>


namespace qrk
{
  class ImageSurface : public Surface
  {
    ImageSurface(const ImageSurface& rhs);
    ImageSurface& operator = (const ImageSurface& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    explicit ImageSurface(const char* file, bool transparent = false);
    ~ImageSurface(void);

    bool isValid(void) const;
    Rect<long> rect(void) const;
    void setAlpha(float alpha);
    float alpha(void) const;
    void draw(const Rect<long>* src, const Rect<long>* dest);
    // !!!
  };
}

#endif /* !QRK_IMAGE_SURFACE_H */
