/*!
  \file
  \brief Lua の補助

  \author Satofumi KAMIMURA

  $Id: LuaHandler.cpp 702 2009-04-01 19:37:33Z satofumi $
*/

#include "LuaHandler.h"
#include "log_printf.h"
#include <string>

using namespace qrk;
using namespace std;


namespace
{
  void handleError(lua_State* lua)
  {
    string error_message = lua_tostring(lua, -1);
    log_printf("%s\n", error_message.c_str());
  }
}


struct LuaHandler::pImpl
{
  string error_message_;
  lua_State* lua_;


  pImpl(void)
  : error_message_("Not initialized."), lua_(lua_open())
  {
    luaL_openlibs(lua_);
  }


  ~pImpl(void)
  {
    lua_close(lua_);
  }


  static pImpl* object(void)
  {
    static pImpl singleton_object;
    return &singleton_object;
  }
};


LuaHandler::LuaHandler(void) : pimpl(pImpl::object())
{
}


LuaHandler::~LuaHandler(void)
{
}


lua_State* LuaHandler::pointer(void)
{
  return pimpl->lua_;
}


int LuaHandler::doFile(const char* lua_file)
{
  LuaHandler lua_handler;
  lua_State* lua = lua_handler.pointer();
  int ret = luaL_dofile(lua, lua_file);
  if (ret) {
    handleError(lua);
  }
  return ret;
}


int LuaHandler::doString(const char* lua_string)
{
  LuaHandler lua_handler;
  lua_State* lua = lua_handler.pointer();
  int ret = luaL_dostring(lua, lua_string);
  if (ret) {
    handleError(lua);
  }
  return ret;
}
