#ifndef SDL_INIT_H
#define SDL_INIT_H

/*!
  \file
  \brief SDL システムの初期化

  \author Satofumi KAMIMURA

  $Id: SdlInit.h 686 2009-03-29 04:09:38Z satofumi $
*/

#include <memory>


namespace qrk
{
  /*!
    \brief SDL システムの初期化クラス
  */
  class SdlInit
  {
    SdlInit(const SdlInit& rhs);
    SdlInit& operator = (const SdlInit& rhs);

    struct pImpl;
    const std::auto_ptr<pImpl> pimpl;

  protected:
    SdlInit(void);
    ~SdlInit(void);
  };
}

#endif /* !SDL_INIT_H */
