/*!
  \file
  \brief Lua への geometry モジュール登録

  \author Satofumi KAMIMURA

  $Id: luabindGeometry.cpp 705 2009-04-01 22:37:10Z satofumi $
*/

#include "luabindGeometry.h"
#include "luabindInit.h"
#include "Grid.h"
#include "Rect.h"
#include <luabind/luabind.hpp>

using namespace qrk;
using namespace luabind;


void qrk::luabindGeometry(void)
{
  lua_State* lua = luabindInit();

  module(lua)
    [
     class_<Grid<long> >("Grid")
     .def(constructor<long, long>())
     .def_readwrite("x", &Grid<long>::x)
     .def_readwrite("y", &Grid<long>::y),

     class_<Grid<double> >("fGrid")
     .def(constructor<double, double>())
     .def_readwrite("x", &Grid<double>::x)
     .def_readwrite("y", &Grid<double>::y),

     class_<Rect<long> >("Rect")
     .def(constructor<long, long, long, long>())
     .def_readwrite("x", &Rect<long>::x)
     .def_readwrite("y", &Rect<long>::y)
     .def_readwrite("w", &Rect<long>::w)
     .def_readwrite("h", &Rect<long>::h),

     class_<Rect<double> >("fRect")
     .def(constructor<double, double, double, double>())
     .def_readwrite("x", &Rect<double>::x)
     .def_readwrite("y", &Rect<double>::y)
     .def_readwrite("w", &Rect<double>::w)
     .def_readwrite("h", &Rect<double>::h)
     ];
}
