/*!
  \example scip_20_md.cpp

  \brief MD ̎gpTv

  \author Satofumi KAMIMURA

  $Id: scip_20_md.cpp 1474 2009-11-01 05:33:08Z satofumi $
*/

#include "DetectOS.h"
#include "SerialDevice.h"
#include "ConnectionUtils.h"
#include "ScipUtils.h"
#include <cstdio>

using namespace qrk;


//! main
int main(int argc, char *argv[]) {

  // K؂Ƀ|[gύX邱
#if defined(WINDOWS_OS)
  const char device[] = "COM3";
#elif defined(LINUX_OS)
  const char device[] = "/dev/ttyACM0";
#else
  const char device[] = "/dev/tty.usbmodem1d11";
#endif

  SerialDevice con;
  if (! con.connect(device, 19200)) {
    printf("SerialDevice::connect: %s\n", con.what());
    exit(1);
  }

  // SCIP2.0 ̌ĂяoƁA̖
  enum { Timeout = 200 };
  con.send("SCIP2.0\n", 8);
  skip(&con, Timeout);

  // "MD" R}h̑M
  /*
    MD    ܂́AMS
    0000  AMIN ̒lgׂ
    0768  AMAX ȉłȂ΂ȂȂ
    01    ܂Ƃ߂鐔
    0     t[ԈBX w肷 X ̃f[^𑗂ȂȂ
    02    f[^̑M񐔁B00 wŖɃf[^𑗂葱
  */
  con.send("MD0000076801000\n", 16);

  // Mf[^̕\
  // ŏ̂P̓[UԂł邽߁A
  // ۂɕԂ鉞̓R}hs̎̎ɂȂ
  enum {
    LineMax = 64 + 1 + 1,
    URG_04LX_MAX = 768,
    TryTimes = 5,
  };
  char buffer[LineMax];
  int n;
  for (int j = 0; j < TryTimes; ++j) { // f[^ǂݏo
    while ((n = readline(&con, buffer, LineMax, Timeout)) > 0) {
      printf("%s\n", buffer);
    }
    printf("\n");

    // Q񕪂̃f[^擾 "QT" păf[^擾~
    if (j >= 1) {
      con.send("QT\n", 3);
    }
  }
  printf("\n");

  // f[^̃fR[h́Aȗ܂
  // GR[obNƃXe[^XR[hɁAAf[^܂A
  // { "GD" ̏ƓłB

  return 0;
}
