/*!
  \example scip_20_pp.cpp

  \brief PP ̎擾

  \author Satofumi KAMIMURA

  $Id: scip_20_pp.cpp 1099 2009-06-30 02:47:18Z satofumi $
*/

#include "SerialDevice.h"
#include "DetectOS.h"
#include "ConnectionUtils.h"
#include <cstdio>
#include <cstdlib>

using namespace qrk;


//! main
int main(int argc, char *argv[]) {

  // K؂Ƀ|[gύX邱
#if defined(WINDOWS_OS)
  const char device[] = "COM3";
#elif defined(LINUX_OS)
  const char device[] = "/dev/ttyACM0";
#else
  const char device[] = "/dev/tty.usbmodem1d11";
#endif

  SerialDevice con;
  if (! con.connect(device, 19200)) {
    printf("SerialDevice::connect: %s\n", con.what());
    exit(1);
  }

  // SCIP2.0 ̌ĂяoƁA̖
  enum { Timeout = 200 };
  con.send("SCIP2.0\n", 8);
  skip(&con, Timeout);

  // "PP" R}h̔s
  con.send("PP\n", 3);

  // Mf[^̕\
  enum { LineMax = 64 + 1 };
  char buffer[LineMax];
  int n;
  while ((n = readline(&con, buffer, LineMax, Timeout)) > 0) {
    printf("%s\n", buffer);
  }

  return 0;
}
