/*!
  \file
  \brief レジスト制限付きデータアーカイブシステム
  \todo 宣言の引数には、変数名を含める
*/

/* =====================================================================

   LiMo - Liblary
   Rero2's Resistrict Data Archive System.
   - レジスト制限付きデータアーカイブシステム

   Programed by Rero2 (K.Kunikane)

   ====================================================================== */

#ifndef LM_RRDA

#define LM_RRDA


/* -------------------------------------------------------------
   --- Structure
   -------------------------------------------------------------- */

/* -------------------------------------------------------------
   --- Define
   -------------------------------------------------------------- */

#ifndef TRUE
#  define TRUE 1
#endif
#ifndef FALSE
#  define FALSE 0
#endif

/* -------------------------------------------------------------
   --- Extern
   -------------------------------------------------------------- */
#ifdef __cplusplus
extern "C"
{
#endif  /* __cplusplus */

  int            lm_rrda_open(const char*, const char*);
  void           lm_rrda_close(void);
  int            lm_rrda_check_open(void);
  int            lm_rrda_check_key(void);
  int            lm_rrda_check_data(const char*);
  unsigned long  lm_rrda_data_size(const char*);
  void          *lm_rrda_load_data(const char*);

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif
