#ifndef RRDA_ENCODER_H
#define RRDA_ENCODER_H

/*!
  \file
  \brief RRDA 形式データのエンコード

  \author Satofumi KAMIMURA

  $Id$
*/

#include <memory>
#include <vector>
#include <string>

class RrdaResource;


class RrdaEncoder {
  RrdaEncoder(void);
  RrdaEncoder(const RrdaEncoder& rhs);
  RrdaEncoder& operator = (const RrdaEncoder& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

public:
  explicit RrdaEncoder(const char* fileName, const char* key);
  ~RrdaEncoder(void);

  /*!
    \brief リソース名の一覧を返す

    \return リソース名の一覧
  */
  void getResourceNames(std::vector<std::string>& names);

  /*!
    \brief リソースを返す

    \param resource_name [i] リソース名

    \return RrdaResouce オブジェクト

    !!! auto_ptr(), shared_ptr() を使った例を記述する
  */
  RrdaResource* getResource(const char* resource_name);
};

#endif /* !RRDA_ENCODER_H */
