#ifndef THEME_CLOCK_DRAW_H
#define THEME_CLOCK_DRAW_H

/*!
  \file
  \brief テーマ時計の描画

  \author Satofumi KAMIMURA

  $Id$
*/

#include <QWidget>


/*!
  \brief テーマ時計の描画クラス
*/
class ThemeClockDraw : public QWidget {
  Q_OBJECT;

  ThemeClockDraw(const ThemeClockDraw& rhs);
  ThemeClockDraw& operator = (const ThemeClockDraw& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

protected:
  void paintEvent(QPaintEvent* event);

public:
  /*!
    \brief コンストラクタ

    \param theme_file [i] テーマファイル名
    \param parent [i] 親ウィジット
  */
  ThemeClockDraw(QWidget* parent = 0);
  ~ThemeClockDraw(void);

  bool loadThemeFile(const QString& theme_file);

  /*!
    \brief テーマがロードされたかを返す

    \retval true 成功
    \retval false 失敗
  */
  bool isThemeLoaded(void);

  /*!
    \brief テーマファイル名を返す

    \return テーマファイル名

    \attention テーマがロードされていない場合は、"" を返す
  */
  const QString getThemeFile(void);

  /*!
    \brief テーマ時計の再描画を行う
  */
  void redraw(void);

  QRegion* getRegion(void);

signals:
  /*!
    \brief 終了シグナルを投げる
  */
  void quit(void);
};

#endif /*! THEME_CLOCK_DRAW_H */
