#ifndef RRDA_RESOURCE_H
#define RRDA_RESOURCE_H

/*!
  \file
  \brief RRDA のリソース管理

  \author Satofumi KAMIMURA

  $Id$
*/

#include <memory>


/*!
  \brief RRDA のリソース管理
*/
class RrdaResource {

  RrdaResource(void);
  RrdaResource(const RrdaResource& rhs);
  RrdaResource& operator = (const RrdaResource& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

 public:

  /*!
    \brief コンストラクタ

    \param fin [i] 圧縮ファイル位置の読み出しストリーム
    \param size [i] 圧縮ファイルのサイズ
  */
  explicit RrdaResource(std::ifstream& fin, size_t size);
  ~RrdaResource(void);

  /*!
    \brief メモリの先頭アドレスを返す

    \param size [o] リソースのサイズ [byte]

    \return メモリの先頭アドレス
  */
  unsigned char* get(size_t* size = NULL);
};

#endif /* !RRDA_RESOURCE_H */
