#ifndef SETTING_CONFIG_H
#define SETTING_CONFIG_H

/*!
  \file
  \brief XML 設定ファイルの管理

  \author Satofumi KAMIMURA

  $Id$

  \todo qtmclokc の内容読み出しと共通にする
*/

#include <memory>
#include <QMap>
#include <QString>


class SettingConfig {

  SettingConfig(void);
  SettingConfig(const SettingConfig& rhs);
  SettingConfig& operator = (const SettingConfig& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

 public:

  // !!! データへのアクセスは、map でなくて、ラップする、かな？
  // !!! ArchiveConfig がラップしたからなぁ...

  /*!
    \brief コンストラクタ

    \param config_file [i] 設定の XML ファイル
  */
  explicit SettingConfig(const char* config_file);

  /*!
    \brief コンストラクタ

    \param tags [o] タグ情報の格納先
    \param data [i] XML データ配列
  */
  explicit SettingConfig(QMap<QString, QString>& tags, QByteArray& data);
  ~SettingConfig(void);


  /*!
    \brief 値の取得

    \param key [i] タグ

    \retval 値
  */
  const char* getValue(const char* tag);


  /*!
    \brief 値の設定

    \param tag [i] タグ
    \param value [i] 値
  */
  void setValue(const char* tag, const char* value);


  /*!
    \brief アーカイブファイルの更新

    \retval true 正常
    \retval false エラー
  */
  void save(void);
};

#endif /* !SETTING_CONFIG_H */
