#ifndef THEME_CLOCK_WIDGET_H
#define THEME_CLOCK_WIDGET_H

/*!
  \file
  \brief ThemeClock の描画処理

  \author Satofumi KAMIMURA

  $Id$
*/

#include <QWidget>


/*!
  \brief テーマ時計のウィジット管理クラス
*/
class ThemeClockWidget : public QWidget {
  Q_OBJECT;

  ThemeClockWidget(void);
  ThemeClockWidget(const ThemeClockWidget& rhs);
  ThemeClockWidget& operator = (const ThemeClockWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

private slots:
  void redraw(void);

protected:
  /*!
    \brief Qt のリサイズイベント処理

    \param event [i/o] イベント
  */
  void resizeEvent(QResizeEvent* event);

  /*!
    \brief Qt のマウス押下イベント処理

    \param event [i/o] イベント
  */
  void mousePressEvent(QMouseEvent* event);

  /*!
    \brief Qt のマウス押下イベント処理

    \param event [i/o] イベント
  */
  void mouseMoveEvent(QMouseEvent* event);

  /*!
    \brief Qt のドラッグイベント

    \param event [i/o] イベント
  */
  void dragEnterEvent(QDragEnterEvent* event);

  /*!
    \brief Qt ドラッグ移動イベント

    \param event [i/o] イベント
  */
  void dragMoveEvent(QDragEnterEvent* event);

  /*!
    \brief Qt のドロップイベント

    \param event [i/o] イベント
  */
  void dropEvent(QDropEvent* event);

public:
  /*!
    \brief コンストラクタ

    \param theme_file [i] テーマファイル名
    \param position_specified [i] 描画位置がシステムに渡されている場合 true
    \param parent [i] 親ウィジット
  */
  ThemeClockWidget(const QString& theme_file, const bool position_specified,
                   QWidget* parent = 0);
  ~ThemeClockWidget(void);
};

#endif /* !THEME_CLOCK_WIDGET_H */
