/*!
  \file
  \brief RRDA リソースのデコード

  \author Satofumi KAMIMURA

  $Id$
*/

#include "RrdaDecoder.h"
#include <string>


struct RrdaDecoder::pImpl {

  std::string release_file_;
  std::string rrda_key_;

  pImpl(const char* fileName, const char* key)
    : release_file_(fileName), rrda_key_(key) {

    // !!!
  }
};


RrdaDecoder::RrdaDecoder(const char* fileName, const char* key)
  : pimpl(new pImpl(fileName, key)) {
}


RrdaDecoder::~RrdaDecoder(void) {
}


void RrdaDecoder::setNormalData(const std::string& tag,
                                const std::string& file) {
  static_cast<void>(tag);
  static_cast<void>(file);

  // !!!
}


void RrdaDecoder::setRestrictedData(const std::string& tag,
                                    const std::string& file) {
  static_cast<void>(tag);
  static_cast<void>(file);

  // !!!
}


void RrdaDecoder::release(void) {

  // !!!
}
