/*!
  \file
  \brief テーマ時計の部品描画

  \author Satofumi KAMIMURA

  $Id$
*/

#include <QPainter>
#include <QTime>
#include "ClockPartsDraw.h"


struct ClockPartsDraw::pImpl {

  static const bool CenterPosition = true; // 画像中心を基準にして描画

  // !!!

  // 再描画
  void paintEvent(ClockPartsDraw* parent) {

    QPainter painter(parent);
    painter.setRenderHint(QPainter::SmoothPixmapTransform);

    // ベース画像の描画
    //drawPixmap(painter, "base/base_org");

    // 部品画像の描画
    //QTime time = QTime::currentTime();
    //updateDigital(painter, time.hour(), time.minute(), time.second());
    //updateAnalog(painter, time.hour(), time.minute(), time.second());
  }

#if 0
  // アナログ部分の再描画
  void updateAnalog(QPainter& painter, int hour, int minute, int second) {

    // 針の角度を再計算
    qreal analog_h = (360.0 * (hour / 12.0)) + (30.0 * (minute / 60.0));
    drawPixmap(painter, "analog/hari_h", analog_h, CenterPosition);

    qreal analog_m = 360.0 * minute / 60.0;
    drawPixmap(painter, "analog/hari_m", analog_m, CenterPosition);

    if (! theme_resource_.option.value("analog/sec", "").compare("on")) {
      // 秒針は、指定があるときのみ描画する
      qreal analog_s = 360.0 * second / 60.0;
      drawPixmap(painter, "analog/hari_s", analog_s, CenterPosition);
    }
  }


  // デジタル部分の再描画
  void updateDigital(QPainter& painter, int hour, int minute, int second) {

    enum { BufferSize = 11 };
    char buffer[BufferSize] = "hh:mm ss x";

    if (! compare_value("digital/sec", "on")) {
      // 秒を描画する
      snprintf(buffer, BufferSize, "%02d:%02d_%02d_%c",
               hour, minute, second, (hour >= 12) ? 'P' : 'A');
    } else {
      // 秒は描画しない
      snprintf(buffer, BufferSize, "%02d:%02d____%c",
               hour, minute, (hour >= 12) ? 'P' : 'A');
    }

    if (! compare_value("digital/colon", "on")) {
      // コロンを点滅させる
      if (second & 0x01) {
        buffer[2] = ' ';
      }
    }

    // 描画処理
    char digital_char[] = "_";
    size_t n = strlen(buffer);
    for (size_t i = 0; i < n; ++i) {
      digital_char[0] = buffer[i];
      QPixmap* parts = theme_resource_.pixmap.value(digital_char, NULL);
      if (! parts) {
        continue;
      }

      int x = digital_positions_[i].x();
      int y = digital_positions_[i].y();
      painter.drawPixmap(QPoint(x, y), *parts);
    }
  }


  // 画像の描画
  void drawPixmap(QPainter& painter,
                  const QString& tag_name,
                  qreal rotate_degree = 0,
                  bool center_position = false) {

    QPixmap* pixmap = theme_resource_.pixmap.value(tag_name, NULL);
    if (! pixmap) {
      return;
    }

    QRect offset = theme_resource_.offset.value(tag_name, QRect(0, 0, 0, 0));

    if (center_position) {
      // 回転前の状態をスタックに積んでおく
      painter.save();

      // 画像の中心で回転させてから、所定の場所に描画を行う
      painter.translate(offset.x(), offset.y());
      painter.rotate(rotate_degree);

      int x = -offset.width() / 2;
      int y = -offset.height() / 2;
      painter.drawPixmap(QPoint(x, y), *pixmap);
      painter.restore();

    } else {
      int x = offset.x();
      int y = offset.y();
      painter.drawPixmap(QPoint(x, y), *pixmap);
    }
  }
#endif
};


ClockPartsDraw::ClockPartsDraw(QWidget* parent)
  : QWidget(parent), pimpl(new pImpl) {
}


ClockPartsDraw::~ClockPartsDraw(void) {
}


// 描画イベント
void ClockPartsDraw::paintEvent(QPaintEvent* event) {
  static_cast<void>(event);

  pimpl->paintEvent(this);
}


// 再描画
void ClockPartsDraw::redraw(void) {

  // 描画イベントを発生させる
  update();
}
