#ifndef TO_SJIS_STRING_H
#define TO_SJIS_STRING_H

/*!
  \file
  \brief SJIS 文字列への変換

  Windows 環境において、ファイルのパスを std::string 形式にするために用いる

  \author Satofumi KAMIMURA

  $Id$

  \attention Linux 環境で、日本語文字がどう扱われるかは未検証
*/

class QString;


namespace qrk {

  /*!
    \brief 文字列の SJIS 変換

    \param text [i] 変換前の文字列

    \return 変換後の文字列
  */
  extern const QString toStdStringPath(const QString& text);


  /*!
    \brief 文字列の UTF-16 変換

    \param text [i] 変換前の文字列

    \return SJIS 変換後の文字列
  */
  extern const QString fromStdStringPath(const std::string& text);
};

#endif /* !TO_SJIS_STRING_H */
